/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.bind.DatatypeConverter;

public class DsGUI {
    private static Double height;
    private static JFrame frame;
    private JButton selectPEMButton;
    private JTextField selectedPEM;
    private JCheckBox CODCheckBox;
    private JCheckBox CODEHCheckBox;
    private JButton selectDocButton;
    private JTextField selectedDoc;
    private JTextField selectedOut;
    private JButton selectOutButton;
    private JButton signButton;
    private JPanel panelMain;
    private JPasswordField passwordField;
    private JTextField selectedConf;
    private JButton selectConfButton;
    private JCheckBox CODCheckBoxH;
    private JCheckBox CODEHCheckBoxH;
    private JTextField selectedDocH;
    private JButton selectDocButtonH;
    private JTextField selectedOutH;
    private JButton selectOutButtonH;
    private JButton signButtonH;
    private JTextField selectedDocVal;
    private JButton selectDocValButton;
    private JTextField selectedXSD;
    private JButton selectXSDButton;
    private JTextField selectedDocXSD;
    private JButton selectDocXSDButton;
    private JButton validateButton;
    private JButton validateXSDButton;
    private JTextArea certSwTextArea;
    private JTextField selectedPEMCert;
    private JButton selectPEMCertButton;
    private JButton certSwButton;
    private JTextArea certHwTextArea;
    private JButton certHwButton;
    private JTextField selectedConfCert;
    private JButton selectConfCertButton;
    private JPasswordField passwordCertField;
    private JButton openXMLH;
    private JButton openXML;
    private JTabbedPane tabbedPane;
    private JTabbedPane tabbedPaneFirmar;
    private JTextPane textPane2;
    private JEditorPane editorPane1;
    private JButton openLog;
    private JButton openLogH;
    private JCheckBox listDocCheckBoxH;
    private JCheckBox listDocCheckBox;
    private JCheckBox listValCheckBox;
    private JCheckBox listXSDCheckBox;
    private JButton openLogVal;
    private JButton openLogXSD;
    private JTextField issuerS;
    private JTextField sinceS;
    private JTextField untilS;
    private JTextField keyS;
    private JTextField algorithmS;
    private JTextField issuerH;
    private JTextField sinceH;
    private JTextField untilH;
    private JTextField algorithmH;
    private JButton moreInfoH;
    private JButton moreInfoS;
    private JTextField serialH;
    private JTextField serialS;
    private JEditorPane editorPane2;
    private JScrollPane jScrollPane2;
    private JEditorPane editorPaneCert;
    private JScrollPane jScrollPaneCert;
    private JLabel jlabel1;
    private JTabbedPane jTabbedPaneLog;
    private File pemFile;
    private File docFile;
    private File docFileH;
    private File outFile;
    private File outFileH;
    private File confFile;
    private File docVal;
    private File docValXSD;
    private File xsd;
    private File pemCertFile;
    private File confCertFile;
    private JFileChooser fc;
    private JFileChooser fcOut;
    private String outputMsg;
    private String outputWarn;
    private String outputErr;
    private String pemPath;

    private DsGUI() {
        this.$$$setupUI$$$();
        this.editorPane2 = new JEditorPane();
        this.jScrollPane2 = new JScrollPane(this.editorPane2);
        this.editorPaneCert = new JEditorPane();
        this.jScrollPaneCert = new JScrollPane(this.editorPaneCert);
        this.jTabbedPaneLog = new JTabbedPane(1);
        this.fc = new JFileChooser();
        this.fcOut = new JFileChooser();
        this.outputMsg = this.getExecutionPath() + File.separator + "output-msg.txt";
        this.outputWarn = this.getExecutionPath() + File.separator + "output-warn.txt";
        this.outputErr = this.getExecutionPath() + File.separator + "output-err.txt";
        this.pemPath = this.getExecutionPath() + "pem.pem";
        String version = Runtime.class.getPackage().getImplementationVersion();
        if (!version.split("\\.")[1].equals("8")) {
            JOptionPane.showMessageDialog(frame, "Versi\u00f3n de Java incorrecta. \nVersi\u00f3n detectada: " + version + "\nVersi\u00f3n necesaria: 1.8.x", "Versi\u00f3n de Java incorrecta", 0);
            System.exit(1);
        }
        ArrayList<Path> paths = new ArrayList<Path>();
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "xmlsec-1.5.5.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "validar-xsd.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "validar.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "org.apache.commons.io.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "jaxb-api-2.4.0-b180830.0359.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "javax.activation-api-1.2.0.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "iaikPkcs11Wrapper.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "iaikPkcs11Provider.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "iaik_xsect.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "iaik_jce.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "firmar-gui.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "firmar.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "commons-logging-1.2.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "commons-codec-1.11.jar", new String[0]));
        paths.add(Paths.get(this.getExecutionPath() + File.separator + "certificado.jar", new String[0]));
        for (Path p : paths) {
            if (p.toFile().exists()) continue;
            JOptionPane.showMessageDialog(frame, "Dependencias no encontradas. \nPor favor no mueva el archivo de su carpeta de origen", "Dependencias no encontradas", 0);
            System.exit(1);
        }
        this.selectedPEM.setText("Nada seleccionado");
        this.selectedDoc.setText("Nada seleccionado");
        this.selectedDocVal.setText("Nada seleccionado");
        this.selectedDocXSD.setText("Nada seleccionado");
        this.selectedXSD.setText("Elija un archivo XSD o se utilizar\u00e1 el del documento");
        this.selectedConf.setText("Nada seleccionado");
        this.selectedDocH.setText("Nada seleccionado");
        this.selectedPEMCert.setText("Nada seleccionado");
        this.selectedConfCert.setText("Nada seleccionado");
        this.CODCheckBox.setSelected(true);
        this.CODCheckBoxH.setSelected(true);
        this.signButtonH.setPreferredSize(this.openXMLH.getPreferredSize());
        this.signButton.setPreferredSize(this.openXML.getPreferredSize());
        this.openLog.setPreferredSize(this.openXML.getPreferredSize());
        this.openLogH.setPreferredSize(this.openXMLH.getPreferredSize());
        this.openLogVal.setPreferredSize(this.validateButton.getPreferredSize());
        this.openLogXSD.setPreferredSize(this.validateXSDButton.getPreferredSize());
        this.validateButton.setPreferredSize(this.selectDocValButton.getPreferredSize());
        this.validateXSDButton.setPreferredSize(this.selectDocXSDButton.getPreferredSize());
        this.certSwButton.setPreferredSize(this.selectPEMCertButton.getPreferredSize());
        this.certHwButton.setPreferredSize(this.selectConfCertButton.getPreferredSize());
        this.editorPane1.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.editorPane1.setText("<html>&nbsp; <br><b><center>" + frame.getTitle() + "</center></b>&nbsp; <br>&nbsp; ATENCI\u00d3N: Esta versi\u00f3n del DS-COD (versi\u00f3n 1) no tiene m\u00e1s soporte <br>&nbsp; <br>&nbsp; Esta aplicaci\u00f3n tiene por objetivo proveer un mecanismo sencillo de integraci\u00f3n para aquellos sistemas <br>&nbsp; pre existentes en instalaciones de exportadores y/o despachantes de aduana. Est\u00e1 orientado su uso al \u00e1rea <br>&nbsp; de sistemas de dichas entidades. <br>&nbsp; <br>&nbsp; Esta aplicaci\u00f3n es de distrubici\u00f3n gratuita con c\u00f3digo fuente bajo la licencia de uso <a href=\"GPLv2\">GPLv2</a>&nbsp; <br>&nbsp; <br>&nbsp; <br>&nbsp; <b>Referencias: </b><br>&nbsp; <br>&nbsp; COD AFIP: <a href=\"http://www.afip.gob.ar/cod\">http://www.afip.gob.ar/cod</a> <br>&nbsp; Visualizador COD: <a href=\"http://www.afip.gob.ar/aladi/cod_visualizer.html\">http://www.afip.gob.ar/aladi/cod_visualizer.html</a> <br>&nbsp; COD ALADI: <a href=\"https://www.codaladi.org/\">https://www.codaladi.org/</a> <br>&nbsp; Versiones del COD: <a href=\"http://foros.aladi.org/gtah/inicio_versiones.asp\">http://foros.aladi.org/gtah/inicio_versiones.asp</a> <br>&nbsp; Directorio del COD: <a href=\"http://www.codaladi.org/directorio\">http://www.codaladi.org/directorio</a> <br>&nbsp; P\u00e1gina p\u00fablica del COD de ALADI: <a href=\"http://www.aladi.org/sitioAladi/facilitacionComercioCOD.html\">http://www.aladi.org/sitioAladi/facilitacionComercioCOD.html</a> <br>&nbsp; P\u00e1gina del foro t\u00e9cnico de ALADI: <a href=\"http://foros.aladi.org/gtah/inicio.asp\">http://foros.aladi.org/gtah/inicio.asp</a> <br>&nbsp; <br>&nbsp; <br>&nbsp; <br>&nbsp; <br>&nbsp; <br>&nbsp; <br>&nbsp; &nbsp; Fuente - GitHub: <a href=\"https://github.com/riosmartinivan/ds-cod\">https://github.com/riosmartinivan/ds-cod</a> </p></div>&nbsp; <br> </html>");
        this.editorPane2.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.editorPane2.setEditable(false);
        this.editorPane2.setOpaque(false);
        this.editorPane2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.editorPane2.setText("<html> Derechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A. <br><br> Este es un Software Libre; como tal redistribuirlo y/o modificarlo est\u00e1 <br> permitido, siempre y cuando se haga bajo los t\u00e9rminos y condiciones de la <br> Licencia P\u00fablica General GNU publicada por la Free Software Foundation, <br> ya sea en su versi\u00f3n 2 \u00f3 cualquier otra de las posteriores a la misma. <br><br> Este \"Programa\" se distribuye con la intenci\u00f3n de que sea \u00fatil, sin <br> embargo carece de garant\u00eda, ni siquiera tiene la garant\u00eda impl\u00edcita de <br> tipo comercial o inherente al prop\u00f3sito del mismo \"Programa\". Ver la <br> Licencia P\u00fablica General GNU para m\u00e1s detalles. <br><br> Se debe haber recibido una copia de la Licencia P\u00fablica General GNU con <br> este \"Programa\", si este no fue el caso, favor de escribir a la Free <br> Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, <br> MA 02110-1301 USA. <br><br> Autor: Mart\u00edn Iv\u00e1n R\u00edos <br> Correo electr\u00f3nico: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com <br> Empresa: Grupo Sauken S.A. <br> WebSite: <a href=\"http://www.sauken.com.ar/\">http://www.sauken.com.ar/</a> <br><br>                                  -------------------------------------------------------------- <br><br> Copyright \u00a9 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A. <br><br> This program is free software; you can redistribute it and/or modify <br> it under the terms of the GNU General Public License as published by <br> the Free Software Foundation; either version 2 of the License, or <br> (at your option) any later version. <br><br> This program is distributed in the hope that it will be useful,<br> but WITHOUT ANY WARRANTY; without even the implied warranty of <br> MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the <br> GNU General Public License for more details. <br><br> You should have received a copy of the GNU General Public License along <br> with this program; if not, write to the Free Software Foundation, Inc., <br> 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA. <br><br> Author: Mart\u00edn Iv\u00e1n R\u00edos <br> E-mail: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com <br> Company: Grupo Sauken S.A. <br> WebSite: <a href=\"http://www.sauken.com.ar/\">http://www.sauken.com.ar/</a> <br>&nbsp;</html>");
        this.editorPaneCert.setEditorKit(JEditorPane.createEditorKitForContentType("text/html"));
        this.editorPaneCert.setEditable(false);
        this.editorPaneCert.setOpaque(false);
        this.editorPaneCert.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.editorPane1.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (e.getDescription().equals("GPLv2")) {
                    JDialog jDialog = new JDialog();
                    jDialog.setTitle("GNU General Public License, version 2");
                    jDialog.setContentPane(this.jScrollPane2);
                    jDialog.setDefaultCloseOperation(2);
                    jDialog.setPreferredSize(new Dimension(jDialog.getPreferredSize().width, height.intValue()));
                    jDialog.pack();
                    jDialog.setLocationRelativeTo(null);
                    jDialog.setVisible(true);
                } else if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (IOException | URISyntaxException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.editorPane2.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (IOException | URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        });
        JTextArea jTextAreaMsg = new JTextArea();
        JTextArea jTextAreaWarn = new JTextArea();
        JTextArea jTextAreaErr = new JTextArea();
        JScrollPane jScrollPaneMsg = new JScrollPane(jTextAreaMsg);
        JScrollPane jScrollPaneWarn = new JScrollPane(jTextAreaWarn);
        JScrollPane jScrollPaneErr = new JScrollPane(jTextAreaErr);
        jTextAreaMsg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jTextAreaWarn.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jTextAreaErr.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jTextAreaMsg.setEditable(false);
        jTextAreaWarn.setEditable(false);
        jTextAreaErr.setEditable(false);
        JPanel mJPanelMsg = new JPanel(new BorderLayout());
        JPanel mJPanelWarn = new JPanel(new BorderLayout());
        JPanel mJPanelErr = new JPanel(new BorderLayout());
        mJPanelMsg.add((Component)jScrollPaneMsg, "Center");
        mJPanelWarn.add((Component)jScrollPaneWarn, "Center");
        mJPanelErr.add((Component)jScrollPaneErr, "Center");
        mJPanelMsg.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mJPanelWarn.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        mJPanelErr.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jTabbedPaneLog.addTab("Mensajes", mJPanelMsg);
        this.jTabbedPaneLog.addTab("Advertencias", mJPanelWarn);
        this.jTabbedPaneLog.addTab("Errores", mJPanelErr);
        this.selectPEMButton.addActionListener(e -> {
            FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos PEM (*.pem)", "pem");
            this.fc.setDialogTitle("Seleccionar PEM");
            this.fc.resetChoosableFileFilters();
            this.fc.setFileFilter(xmlFilter);
            this.fc.setMultiSelectionEnabled(false);
            this.fc.setFileSelectionMode(0);
            int returnVal = this.fc.showOpenDialog(frame);
            if (returnVal == 0) {
                this.pemFile = this.fc.getSelectedFile();
                this.selectedPEM.setText(this.pemFile.getAbsolutePath());
            }
        });
        this.selectConfButton.addActionListener(e -> {
            FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos TXT (*.txt)", "txt");
            this.fc.setDialogTitle("Seleccionar conf");
            this.fc.resetChoosableFileFilters();
            this.fc.setFileFilter(xmlFilter);
            this.fc.setMultiSelectionEnabled(false);
            this.fc.setFileSelectionMode(0);
            int returnVal = this.fc.showOpenDialog(frame);
            if (returnVal == 0) {
                this.confFile = this.fc.getSelectedFile();
                this.selectedConf.setText(this.confFile.getAbsolutePath());
            }
        });
        this.selectDocButton.addActionListener(e -> {
            if (this.listDocCheckBox.isSelected()) {
                FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos TXT (*.txt)", "txt");
                String title = "Seleccionar lista a firmar";
                this.docFile = this.openDocFCList(this.fc, xmlFilter, this.selectedDoc, title);
                if (this.docFile == null) {
                    this.selectedDoc.setText("");
                }
            } else {
                FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos XML (*.xml)", "xml");
                String title = "Seleccionar xml a firmar";
                this.docFile = this.openDocFC(this.fc, xmlFilter, this.listDocCheckBox, this.selectedDoc, title);
                if (this.docFile == null) {
                    this.selectedDoc.setText("");
                }
            }
        });
        this.selectDocButtonH.addActionListener(e -> {
            if (this.listDocCheckBoxH.isSelected()) {
                FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos TXT (*.txt)", "txt");
                String title = "Seleccionar lista a firmar";
                this.docFileH = this.openDocFCList(this.fc, xmlFilter, this.selectedDocH, title);
                if (this.docFileH == null) {
                    this.selectedDocH.setText("");
                }
            } else {
                FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos XML (*.xml)", "xml");
                String title = "Seleccionar xml a firmar";
                this.docFileH = this.openDocFC(this.fc, xmlFilter, this.listDocCheckBoxH, this.selectedDocH, title);
                if (this.docFileH == null) {
                    this.selectedDocH.setText("");
                }
            }
        });
        this.selectOutButton.addActionListener(e -> {
            int returnVal;
            FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos XML (*.xml)", "xml");
            this.fcOut.resetChoosableFileFilters();
            this.fcOut.setFileFilter(xmlFilter);
            this.fcOut.setMultiSelectionEnabled(false);
            this.fcOut.setDialogTitle("Xml o carpeta de salida");
            this.fcOut.setFileSelectionMode(2);
            if (this.docFile != null && !this.docFile.getName().contains(".xml")) {
                this.fcOut.setDialogTitle("Carpeta de salida");
                this.fcOut.setFileSelectionMode(1);
            }
            if ((returnVal = this.fcOut.showOpenDialog(frame)) == 0) {
                this.outFile = this.fcOut.getSelectedFile();
                this.selectedOut.setText(this.outFile.getAbsolutePath());
            }
        });
        this.selectOutButtonH.addActionListener(e -> {
            int returnVal;
            FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos XML (*.xml)", "xml");
            this.fcOut.resetChoosableFileFilters();
            this.fcOut.setFileFilter(xmlFilter);
            this.fcOut.setMultiSelectionEnabled(false);
            this.fcOut.setDialogTitle("Xml o carpeta de salida");
            this.fcOut.setFileSelectionMode(2);
            if (this.docFileH != null && !this.docFileH.getName().contains(".xml")) {
                this.fcOut.setDialogTitle("Carpeta de salida");
                this.fcOut.setFileSelectionMode(1);
            }
            if ((returnVal = this.fcOut.showOpenDialog(frame)) == 0) {
                this.outFileH = this.fcOut.getSelectedFile();
                this.selectedOutH.setText(this.outFileH.getAbsolutePath());
            }
        });
        this.selectDocValButton.addActionListener(e -> {
            if (this.listValCheckBox.isSelected()) {
                FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos TXT (*.txt)", "txt");
                String title = "Seleccionar lista a validar";
                this.docVal = this.openDocFCList(this.fc, xmlFilter, this.selectedDocH, title);
                if (this.docVal != null) {
                    this.selectedDocH.setText("");
                }
            } else {
                FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos XML (*.xml)", "xml");
                String title = "Seleccionar xml a validar";
                this.docVal = this.openDocFC(this.fc, xmlFilter, this.listValCheckBox, this.selectedDocVal, title);
                if (this.docVal != null) {
                    this.selectedDocH.setText("");
                }
            }
        });
        this.selectXSDButton.addActionListener(e -> {
            FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos XSD (*.xsd)", "xsd");
            this.fc.setDialogTitle("Seleccionar esqema XSD");
            this.fc.setFileFilter(xmlFilter);
            this.fc.setMultiSelectionEnabled(false);
            this.fc.setFileSelectionMode(0);
            int returnVal = this.fc.showOpenDialog(frame);
            if (returnVal == 0) {
                this.xsd = this.fc.getSelectedFile();
                this.selectedXSD.setText(this.xsd.getAbsolutePath());
            }
        });
        this.selectDocXSDButton.addActionListener(e -> {
            if (this.listXSDCheckBox.isSelected()) {
                FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos TXT (*.txt)", "txt");
                String title = "Seleccionar lista a validar por esquema";
                this.docValXSD = this.openDocFCList(this.fc, xmlFilter, this.selectedDocH, title);
                if (this.docValXSD != null) {
                    this.selectedDocXSD.setText(this.docValXSD.getAbsolutePath());
                }
            } else {
                FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos XML (*.xml)", "xml");
                String title = "Seleccionar xml a validar por esquema";
                this.docValXSD = this.openDocFC(this.fc, xmlFilter, this.listXSDCheckBox, this.selectedDocXSD, title);
                if (this.docValXSD != null) {
                    this.selectedDocXSD.setText(this.docValXSD.getAbsolutePath());
                }
            }
        });
        this.selectPEMCertButton.addActionListener(e -> {
            FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("Archivos PEM (*.pem)", "pem");
            this.fc.setDialogTitle("Seleccionar PEM");
            this.fc.resetChoosableFileFilters();
            this.fc.setFileFilter(xmlFilter);
            this.fc.setMultiSelectionEnabled(false);
            this.fc.setFileSelectionMode(0);
            int returnVal = this.fc.showOpenDialog(frame);
            if (returnVal == 0) {
                this.pemCertFile = this.fc.getSelectedFile();
                this.selectedPEMCert.setText(this.pemCertFile.getAbsolutePath());
                this.issuerS.setText("");
                this.sinceS.setText("");
                this.untilS.setText("");
                this.algorithmS.setText("");
                this.serialS.setText("");
                this.moreInfoS.setEnabled(false);
            }
        });
        this.selectConfCertButton.addActionListener(e -> {
            this.fc.setDialogTitle("Seleccionar conf");
            this.fc.resetChoosableFileFilters();
            this.fc.setMultiSelectionEnabled(false);
            this.fc.setFileSelectionMode(0);
            int returnVal = this.fc.showOpenDialog(frame);
            if (returnVal == 0) {
                this.confCertFile = this.fc.getSelectedFile();
                this.selectedConfCert.setText(this.confCertFile.getAbsolutePath());
            }
        });
        this.CODCheckBox.addActionListener(e -> {
            if (this.CODCheckBox.isSelected()) {
                this.CODEHCheckBox.setSelected(false);
            } else {
                this.CODEHCheckBox.setSelected(true);
            }
        });
        this.CODCheckBoxH.addActionListener(e -> {
            if (this.CODCheckBoxH.isSelected()) {
                this.CODEHCheckBoxH.setSelected(false);
            } else {
                this.CODEHCheckBoxH.setSelected(true);
            }
        });
        this.CODEHCheckBox.addActionListener(e -> {
            if (this.CODEHCheckBox.isSelected()) {
                this.CODCheckBox.setSelected(false);
            } else {
                this.CODCheckBox.setSelected(true);
            }
        });
        this.CODEHCheckBoxH.addActionListener(e -> {
            if (this.CODEHCheckBoxH.isSelected()) {
                this.CODCheckBoxH.setSelected(false);
            } else {
                this.CODCheckBoxH.setSelected(true);
            }
        });
        this.signButton.addActionListener(e -> {
            String CODSelection = this.CODCheckBox.isSelected() ? "COD" : "CODEH";
            ProcessBuilder pb = null;
            ArrayList<ProcessBuilder> pbL = null;
            if (this.pemFile == null || !this.pemFile.toPath().toFile().exists()) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione un certificado v\u00e1lido", "Certificado no seleccionado", 1);
                return;
            }
            if (this.docFile == null || !this.docFile.toPath().toFile().exists()) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione un documento v\u00e1lido", "Documento no seleccionado", 1);
                return;
            }
            if (this.outFile == null) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione una salida v\u00e1lida", "Salida no seleccionada", 1);
                return;
            }
            if (this.listDocCheckBox.isSelected()) {
                Scanner sc = null;
                try {
                    sc = new Scanner(new File(this.docFile.getAbsolutePath()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                pbL = new ArrayList<ProcessBuilder>();
                while (sc.hasNextLine()) {
                    pbL.add(new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "firmar.jar", "-s", this.pemFile.getAbsolutePath(), CODSelection, sc.nextLine(), this.outFile.getAbsolutePath(), this.outputMsg, this.outputErr));
                }
            } else {
                pb = new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "firmar.jar", "-s", this.pemFile.getAbsolutePath(), CODSelection, this.docFile.getAbsolutePath(), this.outFile.getAbsolutePath(), this.outputMsg, this.outputErr);
            }
            try {
                int result = 0;
                if (pb != null) {
                    pb.directory(new File(this.getExecutionPath()));
                    Process p = pb.start();
                    result = p.waitFor();
                } else if (pbL != null) {
                    for (ProcessBuilder processBuilder : pbL) {
                        Process process = processBuilder.start();
                        process.waitFor();
                    }
                }
                if (result == 0) {
                    this.openXML.setEnabled(true);
                    this.openLog.setEnabled(true);
                    if (!this.listDocCheckBox.isSelected()) {
                        this.displayResults();
                        this.displayErrors();
                    }
                } else {
                    this.openLog.setEnabled(true);
                    if (!this.listDocCheckBox.isSelected()) {
                        this.displayErrors();
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.nullDocFile();
        });
        this.signButtonH.addActionListener(e -> {
            String passText = new String(this.passwordField.getPassword());
            String CODSelection = this.CODCheckBoxH.isSelected() ? "COD" : "CODEH";
            ProcessBuilder pb = null;
            ArrayList<ProcessBuilder> pbL = null;
            if (this.confFile == null || !this.confFile.toPath().toFile().exists()) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione un archivo de configuraci\u00f3n v\u00e1lido", "Archivo de configuraci\u00f3n no seleccionado", 1);
                return;
            }
            if (passText.equals("")) {
                JOptionPane.showMessageDialog(frame, "Por favor, escriba una contrase\u00f1a", "Contrase\u00f1a no encontrada", 1);
                return;
            }
            if (this.docFileH == null || !this.docFileH.toPath().toFile().exists()) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione un documento v\u00e1lido", "Documento no seleccionado", 1);
                return;
            }
            if (this.outFileH == null) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione una salida v\u00e1lida", "Salida no seleccionada", 1);
                return;
            }
            if (this.listDocCheckBoxH.isSelected()) {
                Scanner sc = null;
                try {
                    sc = new Scanner(new File(this.docFileH.getAbsolutePath()));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                pbL = new ArrayList<ProcessBuilder>();
                while (sc.hasNextLine()) {
                    pbL.add(new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "firmar.jar", "-t", this.confFile.getAbsolutePath(), passText, CODSelection, sc.nextLine(), this.outFileH.getAbsolutePath(), this.outputMsg, this.outputErr));
                }
            } else {
                pb = new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "firmar.jar", "-t", this.confFile.getAbsolutePath(), passText, CODSelection, this.docFileH.getAbsolutePath(), this.outFileH.getAbsolutePath(), this.outputMsg, this.outputErr);
            }
            try {
                int result = 0;
                if (pb != null) {
                    pb.directory(new File(this.getExecutionPath()));
                    Process p = pb.start();
                    result = p.waitFor();
                } else if (pbL != null) {
                    for (ProcessBuilder processBuilder : pbL) {
                        Process process = processBuilder.start();
                        process.waitFor();
                    }
                }
                if (result == 0) {
                    this.openXMLH.setEnabled(true);
                    this.openLogH.setEnabled(true);
                    if (!this.listDocCheckBoxH.isSelected()) {
                        this.displayResults();
                        this.displayErrors();
                    }
                } else {
                    this.openLogH.setEnabled(true);
                    if (!this.listDocCheckBoxH.isSelected()) {
                        this.displayErrors();
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.nullDocFileH();
        });
        this.validateButton.addActionListener(e -> {
            if (this.docVal == null || !this.docVal.toPath().toFile().exists()) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione un documento v\u00e1lido", "Documento no seleccionado", 1);
                return;
            }
            ProcessBuilder pb = this.listValCheckBox.isSelected() ? new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "validar.jar", "--list", this.docVal.getAbsolutePath(), this.outputMsg, this.outputErr) : new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "validar.jar", "--xml", this.docVal.getAbsolutePath(), this.outputMsg, this.outputErr);
            pb.directory(new File(this.getExecutionPath()));
            try {
                Process p = pb.start();
                int result = p.waitFor();
                if (result == 0) {
                    this.openLogVal.setEnabled(true);
                    if (!this.listValCheckBox.isSelected()) {
                        this.displayResults();
                        this.displayErrors();
                    }
                } else {
                    this.openLogVal.setEnabled(true);
                    if (!this.listValCheckBox.isSelected()) {
                        this.displayErrors();
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.nullDocVal();
        });
        this.validateXSDButton.addActionListener(e -> {
            if (this.docValXSD == null || !this.docValXSD.toPath().toFile().exists()) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione un documento v\u00e1lido", "Documento no seleccionado", 1);
                return;
            }
            ProcessBuilder pb = this.listXSDCheckBox.isSelected() ? (this.xsd == null ? new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "validar-xsd.jar", "DEFAULT", "--list", this.docValXSD.getAbsolutePath(), this.outputMsg, this.outputWarn, this.outputErr) : new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "validar-xsd.jar", this.xsd.getAbsolutePath(), "--list", this.docValXSD.getAbsolutePath(), this.outputMsg, this.outputWarn, this.outputErr)) : (this.xsd == null ? new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "validar-xsd.jar", "DEFAULT", "--xml", this.docValXSD.getAbsolutePath(), this.outputMsg, this.outputWarn, this.outputErr) : new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "validar-xsd.jar", this.xsd.getAbsolutePath(), "--xml", this.docValXSD.getAbsolutePath(), this.outputMsg, this.outputWarn, this.outputErr));
            pb.directory(new File(this.getExecutionPath()));
            try {
                Process p = pb.start();
                int result = p.waitFor();
                if (result == 0) {
                    this.openLogXSD.setEnabled(true);
                    if (!this.listXSDCheckBox.isSelected()) {
                        this.displayResults();
                        this.displayWarnings();
                        this.displayErrors();
                    }
                } else {
                    this.openLogXSD.setEnabled(true);
                    if (!this.listXSDCheckBox.isSelected()) {
                        this.displayWarnings();
                        this.displayErrors();
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            this.nullDocValXSD();
        });
        this.certSwButton.addActionListener(e -> {
            if (this.pemCertFile == null || !this.pemCertFile.toPath().toFile().exists()) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione un certificado v\u00e1lido", "Certificado no seleccionado", 1);
                return;
            }
            ProcessBuilder pb = new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "certificado.jar", "-s", this.pemCertFile.getAbsolutePath(), this.outputMsg, this.outputErr);
            pb.directory(new File(this.getExecutionPath()));
            try {
                Process p = pb.start();
                int result = p.waitFor();
                if (result == 0) {
                    this.displayCert(0);
                } else {
                    this.displayErrors();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        this.certHwButton.addActionListener(e -> {
            String passText = new String(this.passwordCertField.getPassword());
            if (this.confCertFile == null || !this.confCertFile.toPath().toFile().exists()) {
                JOptionPane.showMessageDialog(frame, "Por favor, seleccione un archivo de configuraci\u00f3n v\u00e1lido", "Archivo de configuraci\u00f3n no seleccionado", 1);
                return;
            }
            if (passText.equals("")) {
                JOptionPane.showMessageDialog(frame, "Por favor, escriba una contrase\u00f1a", "Contrase\u00f1a no encontrada", 1);
                return;
            }
            ProcessBuilder pb = new ProcessBuilder("java", "-jar", this.getExecutionPath() + File.separator + "certificado.jar", "-t", this.confCertFile.getAbsolutePath(), passText, this.outputMsg, this.outputErr);
            pb.directory(new File(this.getExecutionPath()));
            try {
                Process p = pb.start();
                int result = p.waitFor();
                if (result == 0) {
                    this.displayCert(1);
                } else {
                    this.displayErrors();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        });
        this.moreInfoS.addActionListener(e -> {
            JDialog jDialog = new JDialog();
            jDialog.setTitle("Certificado Completo");
            jDialog.setContentPane(this.jScrollPaneCert);
            jDialog.setDefaultCloseOperation(2);
            jDialog.setPreferredSize(new Dimension(jDialog.getPreferredSize().width, height.intValue()));
            jDialog.pack();
            jDialog.setLocationRelativeTo(null);
            jDialog.setVisible(true);
        });
        this.moreInfoH.addActionListener(e -> {
            JDialog jDialog = new JDialog();
            jDialog.setTitle("Certificado Completo");
            jDialog.setContentPane(this.jScrollPaneCert);
            jDialog.setDefaultCloseOperation(2);
            jDialog.setPreferredSize(new Dimension(jDialog.getPreferredSize().width, height.intValue()));
            jDialog.pack();
            jDialog.setLocationRelativeTo(null);
            jDialog.setVisible(true);
        });
        this.openXML.addActionListener(e -> {
            Desktop dt = Desktop.getDesktop();
            try {
                dt.open(this.outFile);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
        this.openXMLH.addActionListener(e -> {
            Desktop dt = Desktop.getDesktop();
            try {
                dt.open(this.outFileH);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        });
        ActionListener actionListenerLogs = e -> {
            boolean next;
            Path file;
            try {
                List<String> mOutputMsg;
                file = Paths.get(this.outputMsg, new String[0]);
                if (file.toFile().exists() && !(mOutputMsg = Files.readAllLines(Paths.get(this.outputMsg, new String[0]), StandardCharsets.UTF_8)).isEmpty()) {
                    StringBuilder resultMsg = new StringBuilder();
                    next = false;
                    for (String lines : mOutputMsg) {
                        if (next) {
                            resultMsg.append(lines).append("\n");
                        }
                        if (!lines.contains("####")) continue;
                        next = true;
                    }
                    if (resultMsg.length() > 0) {
                        System.out.println(resultMsg.toString());
                        jTextAreaMsg.setText(resultMsg.toString());
                    }
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            try {
                file = Paths.get(this.outputWarn, new String[0]);
                if (file.toFile().exists()) {
                    FileReader fr = new FileReader(this.outputWarn);
                    BufferedReader reader = new BufferedReader(fr);
                    jTextAreaWarn.read(reader, "Advertencias");
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            try {
                List<String> mOutputErr;
                file = Paths.get(this.outputErr, new String[0]);
                if (file.toFile().exists() && !(mOutputErr = Files.readAllLines(Paths.get(this.outputErr, new String[0]), StandardCharsets.ISO_8859_1)).isEmpty()) {
                    StringBuilder resultErr = new StringBuilder();
                    next = false;
                    for (String lines : mOutputErr) {
                        if (next) {
                            resultErr.append(lines).append("\n");
                        }
                        if (!lines.contains("####")) continue;
                        next = true;
                    }
                    if (resultErr.length() > 0) {
                        jTextAreaErr.setText(resultErr.toString());
                    }
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            JDialog jDialog = new JDialog();
            jDialog.setTitle("Logs");
            jDialog.setContentPane(this.jTabbedPaneLog);
            jDialog.setDefaultCloseOperation(2);
            jDialog.setPreferredSize(new Dimension(800, height.intValue()));
            jDialog.pack();
            jDialog.setLocationRelativeTo(null);
            jDialog.setVisible(true);
        };
        this.openLog.addActionListener(actionListenerLogs);
        this.openLogH.addActionListener(actionListenerLogs);
        this.openLogVal.addActionListener(actionListenerLogs);
        this.openLogXSD.addActionListener(actionListenerLogs);
    }

    public static void main(String[] args) {
        DsGUI dsGUI = new DsGUI();
        frame.setContentPane(dsGUI.panelMain);
        frame.setDefaultCloseOperation(3);
        Double width = (double)DsGUI.frame.getPreferredSize().width * 1.7;
        height = (double)DsGUI.frame.getPreferredSize().height * 1.4;
        frame.setPreferredSize(new Dimension(width.intValue(), height.intValue()));
        frame.setIconImage(Toolkit.getDefaultToolkit().getImage("icon.png"));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private ArrayList<String> listf(File directory, ArrayList<String> files) {
        File[] fList = directory.listFiles();
        if (fList != null) {
            for (File file : fList) {
                if (file.isFile()) {
                    if (!file.getName().contains(".xml")) continue;
                    files.add(file.getAbsolutePath());
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.listf(file, files);
            }
            return files;
        }
        return null;
    }

    private File openDocFC(JFileChooser mFc, FileNameExtensionFilter xmlFilter, JCheckBox listCheckBox, JTextField mDocText, String title) {
        File mDocFile = null;
        Path lastSign = Paths.get(this.getExecutionPath() + File.separator + "ultima-firma.txt", new String[0]);
        try {
            Files.deleteIfExists(lastSign);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mFc.setDialogTitle(title);
        mFc.resetChoosableFileFilters();
        mFc.setFileFilter(xmlFilter);
        mFc.setMultiSelectionEnabled(true);
        mFc.setFileSelectionMode(2);
        int returnVal = mFc.showOpenDialog(frame);
        if (returnVal == 0) {
            File[] files = mFc.getSelectedFiles();
            if (files.length > 1) {
                try {
                    Files.deleteIfExists(lastSign);
                    Files.createFile(lastSign, new FileAttribute[0]);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ArrayList<String> fileList = new ArrayList<String>();
                for (File file : files) {
                    if (file.isDirectory()) {
                        ArrayList<String> fileTemp = new ArrayList<String>();
                        ArrayList<String> fileListTmp = this.listf(file, fileTemp);
                        if (fileListTmp == null) continue;
                        fileList.addAll(fileListTmp);
                        continue;
                    }
                    fileList.add(file.getAbsolutePath());
                }
                try {
                    Files.write(lastSign, fileList, Charset.forName("UTF-8"), StandardOpenOption.TRUNCATE_EXISTING);
                    mDocFile = new File(String.valueOf(lastSign));
                    listCheckBox.setSelected(true);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (files[0].isDirectory()) {
                try {
                    Files.deleteIfExists(lastSign);
                    Files.createFile(lastSign, new FileAttribute[0]);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                ArrayList<String> fileTemp = new ArrayList<String>();
                ArrayList<String> fileList = this.listf(files[0], fileTemp);
                if (fileList != null) {
                    try {
                        Files.write(lastSign, fileList, Charset.forName("UTF-8"), StandardOpenOption.TRUNCATE_EXISTING);
                        mDocFile = new File(String.valueOf(lastSign));
                        listCheckBox.setSelected(true);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            } else {
                mDocFile = files[0];
            }
            if (mDocFile != null) {
                mDocText.setText(mDocFile.getAbsolutePath());
            }
        }
        return mDocFile;
    }

    private File openDocFCList(JFileChooser mFc, FileNameExtensionFilter xmlFilter, JTextField mDocText, String title) {
        File mDocFile = null;
        mFc.setDialogTitle(title);
        mFc.resetChoosableFileFilters();
        mFc.setFileFilter(xmlFilter);
        mFc.setMultiSelectionEnabled(false);
        mFc.setFileSelectionMode(0);
        int returnVal = mFc.showOpenDialog(frame);
        if (returnVal == 0) {
            mDocFile = mFc.getSelectedFile();
            mDocText.setText(mDocFile.getAbsolutePath());
        }
        return mDocFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate loadPublicX509(String fileName) throws IOException, GeneralSecurityException {
        X509Certificate crt;
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuilder builder = new StringBuilder();
            boolean inKey = false;
            String line = br.readLine();
            while (line != null) {
                if (!inKey) {
                    if (line.startsWith("-----BEGIN") && line.endsWith(" CERTIFICATE-----")) {
                        inKey = true;
                    }
                } else {
                    if (line.startsWith("-----END") && line.endsWith(" CERTIFICATE-----")) break;
                    builder.append(line);
                }
                line = br.readLine();
            }
            byte[] encoded = DatatypeConverter.parseBase64Binary((String)builder.toString());
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream in = new ByteArrayInputStream(encoded);
            crt = (X509Certificate)certFactory.generateCertificate(in);
        }
        catch (Throwable throwable) {
            DsGUI.closeSilent(is);
            throw throwable;
        }
        DsGUI.closeSilent(is);
        return crt;
    }

    private void displayResults() throws Exception {
        List<String> outputMsg;
        File f = new File(this.outputMsg);
        if (f.exists() && !(outputMsg = Files.readAllLines(Paths.get(this.outputMsg, new String[0]), StandardCharsets.UTF_8)).isEmpty()) {
            StringBuilder resultMsg = new StringBuilder();
            boolean next = false;
            for (String lines : outputMsg) {
                if (next) {
                    resultMsg.append(lines).append("\n");
                }
                if (!lines.contains("####")) continue;
                next = true;
            }
            if (resultMsg.length() > 0) {
                JOptionPane.showMessageDialog(frame, resultMsg.toString(), "Resultados", 1);
            }
        }
    }

    private void displayErrors() throws Exception {
        List<String> outputErr;
        File f = new File(this.outputErr);
        if (f.exists() && !(outputErr = Files.readAllLines(Paths.get(this.outputErr, new String[0]), StandardCharsets.ISO_8859_1)).isEmpty()) {
            StringBuilder resultErr = new StringBuilder();
            boolean next = false;
            for (String lines : outputErr) {
                if (next) {
                    resultErr.append(lines).append("\n");
                }
                if (!lines.contains("####")) continue;
                next = true;
            }
            if (resultErr.length() > 0) {
                JOptionPane.showMessageDialog(frame, resultErr.toString(), "Error", 0);
            }
        }
    }

    private void displayWarnings() throws Exception {
        List<String> outputWarn;
        File f = new File(this.outputWarn);
        if (f.exists() && !(outputWarn = Files.readAllLines(Paths.get(this.outputWarn, new String[0]), StandardCharsets.UTF_8)).isEmpty()) {
            StringBuilder resultErr = new StringBuilder();
            for (String lines : outputWarn) {
                resultErr.append(lines).append("\n");
            }
            if (resultErr.length() > 0) {
                JOptionPane.showMessageDialog(frame, resultErr.toString(), "Advertencia", 2);
            }
        }
    }

    private String getExecutionPath() {
        URL rootPath = this.getClass().getProtectionDomain().getCodeSource().getLocation();
        String URI2 = rootPath.toString().substring(6);
        String[] currentPath = URI2.split("firmar-gui.jar");
        currentPath[0] = currentPath[0].replaceAll("%20", " ");
        return currentPath[0];
    }

    private static void closeSilent(InputStream is) {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void checkCertValidity(String pem) throws CertificateException, IOException, CRLException {
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream(pem);
        X509Certificate cert = (X509Certificate)fact.generateCertificate(is);
        is.close();
        String cn = cert.getIssuerX500Principal().toString().split("CN=")[1].split(",")[0];
        try {
            cert.checkValidity();
            JOptionPane.showMessageDialog(frame, "El certificado que se est\u00e1 utilizando es v\u00e1lido actualmente", "Certificado v\u00e1lido", 1);
        }
        catch (CertificateExpiredException e) {
            JOptionPane.showMessageDialog(frame, "El certificado que se est\u00e1 utilizando ha expirado", "Certificado expirado", 2);
        }
        catch (CertificateNotYetValidException e) {
            JOptionPane.showMessageDialog(frame, "El certificado que se est\u00e1 utilizando todab\u00eda no es v\u00e1lido", "Certificado invalido", 2);
        }
        String certString = cert.toString();
        if (certString.contains("CRLDistributionPoints")) {
            String[] tmp = certString.split("CRLDistributionPoints \\[");
            String[] parts = tmp[1].split("]]");
            String[] distPoints = parts[0].substring(4, parts[0].length() - 1).split(",");
            boolean noInternetError = false;
            boolean revoked = false;
            for (String tempDist : distPoints) {
                X509CRL crl;
                String[] tmpUrl = tempDist.split("\\[URIName: ");
                String url = tmpUrl[1].substring(0, tmpUrl[1].length() - 1).replaceAll("]", "");
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                try {
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                }
                catch (Exception sc) {
                    // empty catch block
                }
                URL crlUrl = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)crlUrl.openConnection();
                connection.connect();
                try {
                    String tmp2;
                    if (connection.getResponseCode() == 301) {
                        connection = (HttpURLConnection)new URL(connection.getHeaderField("Location")).openConnection();
                    }
                    StringBuilder inputLine = new StringBuilder();
                    DataInputStream inStream = new DataInputStream(connection.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inStream));
                    int i2 = 0;
                    while ((tmp2 = bufferedReader.readLine()) != null) {
                        if (i2 > 20) {
                            i2 = 0;
                            break;
                        }
                        inputLine.append(tmp2);
                        ++i2;
                    }
                    bufferedReader.close();
                    inStream.close();
                    if (i2 > 0 && inputLine.toString().contains(".assign(\"")) {
                        String[] a2 = inputLine.toString().split(Pattern.quote(".assign(\""));
                        String finalStr = a2[1].split(Pattern.quote("\");"))[0];
                        connection = (HttpURLConnection)new URL(finalStr).openConnection();
                    } else {
                        connection.disconnect();
                        connection = (HttpURLConnection)crlUrl.openConnection();
                        if (connection.getResponseCode() == 301) {
                            connection = (HttpURLConnection)new URL(connection.getHeaderField("Location")).openConnection();
                        }
                    }
                    inStream = new DataInputStream(connection.getInputStream());
                    crl = (X509CRL)fact.generateCRL(inStream);
                }
                catch (UnknownHostException e) {
                    noInternetError = true;
                    break;
                }
                X509CRLEntry revokedCertificate = crl.getRevokedCertificate(cert.getSerialNumber());
                if (revokedCertificate == null) continue;
                revoked = true;
            }
            if (noInternetError) {
                JOptionPane.showMessageDialog(frame, "No es posible validar contra AC del certificado actual, no hay conneci\u00f3n a internet", "No hay conecci\u00f3n", 2);
                return;
            }
            if (revoked) {
                JOptionPane.showMessageDialog(frame, "El certificado que se est\u00e1 utilizando esta actualmente revocado, contra la AC: " + cn, "Certificado revocado", 2);
            } else {
                JOptionPane.showMessageDialog(frame, "El certificado que se est\u00e1 utilizando es actualmente v\u00e1lido, contra la AC: " + cn, "Certificado v\u00e1lido", 1);
            }
        } else {
            JOptionPane.showMessageDialog(frame, "No pudo validarse si la firma esta revocada", "No pudo validarse revocados", 0);
        }
    }

    private void displayCert(int isToken) throws Exception {
        List<String> outputMsg = Files.readAllLines(Paths.get(this.outputMsg, new String[0]), StandardCharsets.UTF_8);
        if (!outputMsg.isEmpty()) {
            StringBuilder resultMsg = new StringBuilder();
            resultMsg.append("<html>");
            for (String lines : outputMsg) {
                resultMsg.append(lines).append("<br>");
            }
            resultMsg.append("</html>");
            if (resultMsg.length() > 0) {
                LdapName ln;
                X509Certificate cert = DsGUI.loadPublicX509(this.pemPath);
                if (isToken == 1) {
                    ln = new LdapName(cert.getIssuerX500Principal().toString());
                    for (Rdn rdn : ln.getRdns()) {
                        if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                        this.issuerH.setText(rdn.getValue().toString());
                        break;
                    }
                    this.sinceH.setText(cert.getNotBefore().toString());
                    this.untilH.setText(cert.getNotAfter().toString());
                    this.algorithmH.setText(cert.getSigAlgName());
                    this.serialH.setText(cert.getSerialNumber().toString(16));
                    this.editorPaneCert.setText(resultMsg.toString());
                    this.moreInfoH.setEnabled(true);
                    DsGUI.checkCertValidity(this.pemPath);
                    Files.deleteIfExists(Paths.get(this.pemPath, new String[0]));
                } else if (isToken == 0) {
                    ln = new LdapName(cert.getIssuerX500Principal().toString());
                    for (Rdn rdn : ln.getRdns()) {
                        if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                        this.issuerS.setText(rdn.getValue().toString());
                        break;
                    }
                    this.sinceS.setText(cert.getNotBefore().toString());
                    this.untilS.setText(cert.getNotAfter().toString());
                    this.algorithmS.setText(cert.getSigAlgName());
                    this.serialS.setText(cert.getSerialNumber().toString(16));
                    this.editorPaneCert.setText(resultMsg.toString());
                    this.moreInfoS.setEnabled(true);
                    DsGUI.checkCertValidity(this.pemPath);
                    Files.deleteIfExists(Paths.get(this.pemPath, new String[0]));
                }
            }
        }
    }

    private void nullDocFile() {
        this.docFile = null;
        this.selectedDoc.setText("");
    }

    private void nullDocFileH() {
        this.docFileH = null;
        this.selectedDocH.setText("");
    }

    private void nullDocVal() {
        this.docVal = null;
        this.selectedDocVal.setText("");
    }

    private void nullDocValXSD() {
        this.docValXSD = null;
        this.selectedDocXSD.setText("");
    }

    static {
        frame = new JFrame("DS-COD 1.2.2 - Certificado de Origen Digital de ALADI - Grupo Sauken S.A.");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JEditorPane jEditorPane;
        JButton jButton;
        JTextField jTextField;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JTextField jTextField5;
        JPasswordField jPasswordField;
        JButton jButton2;
        JButton jButton3;
        JTextField jTextField6;
        JButton jButton4;
        JTextField jTextField7;
        JTextField jTextField8;
        JTextField jTextField9;
        JTextField jTextField10;
        JTextField jTextField11;
        JButton jButton5;
        JButton jButton6;
        JTextField jTextField12;
        JButton jButton7;
        JButton jButton8;
        JCheckBox jCheckBox;
        JCheckBox jCheckBox2;
        JButton jButton9;
        JButton jButton10;
        JButton jButton11;
        JButton jButton12;
        JTextField jTextField13;
        JButton jButton13;
        JTextField jTextField14;
        JTextField jTextField15;
        JCheckBox jCheckBox3;
        JButton jButton14;
        JButton jButton15;
        JButton jButton16;
        JPasswordField jPasswordField2;
        JButton jButton17;
        JButton jButton18;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JTextField jTextField16;
        JButton jButton19;
        JTextField jTextField17;
        JTextField jTextField18;
        JCheckBox jCheckBox6;
        JButton jButton20;
        JButton jButton21;
        JButton jButton22;
        JButton jButton23;
        JButton jButton24;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JTextField jTextField19;
        JButton jButton25;
        JTextField jTextField20;
        JTextField jTextField21;
        JTabbedPane jTabbedPane;
        JTabbedPane jTabbedPane2;
        JPanel jPanel;
        this.panelMain = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(3, 1, 1, 1), -1, -1, false, false));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.tabbedPane = jTabbedPane2 = new JTabbedPane();
        ((Component)jTabbedPane2).setVisible(true);
        jPanel.add((Component)jTabbedPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 1, new Insets(2, 4, 2, 4), -1, -1, false, false));
        jTabbedPane2.addTab("Firmar", null, jPanel2, null);
        this.tabbedPaneFirmar = jTabbedPane = new JTabbedPane();
        jPanel2.add((Component)jTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(16, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Software", null, jPanel3, null);
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), null, 0, 0, null, null));
        this.selectedPEM = jTextField21 = new JTextField();
        jTextField21.setEditable(false);
        ((Component)jTextField21).setEnabled(true);
        jTextField21.setFocusable(true);
        jTextField21.setText("");
        jPanel3.add((Component)jTextField21, new GridConstraints(2, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 1, new Insets(10, 20, 10, 20), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jPanel4.add((Component)jSeparator, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Seleccionar el certificado:");
        jPanel3.add((Component)jLabel, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Etiqueta XML a firmar:");
        jPanel3.add((Component)jLabel2, new GridConstraints(4, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel3 = new JLabel();
        jLabel3.setFocusable(true);
        jLabel3.setText("Documento XML a firmar:");
        jPanel3.add((Component)jLabel3, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.selectedDoc = jTextField20 = new JTextField();
        jTextField20.setEditable(false);
        ((Component)jTextField20).setEnabled(true);
        jTextField20.setFocusable(true);
        jTextField20.setText("");
        jPanel3.add((Component)jTextField20, new GridConstraints(8, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel4 = new JLabel();
        jLabel4.setFocusable(true);
        Font font = this.$$$getFont$$$(null, -1, -1, jLabel4.getFont());
        if (font != null) {
            jLabel4.setFont(font);
        }
        jLabel4.setText("Documento XML o carpeta de salida:");
        jPanel3.add((Component)jLabel4, new GridConstraints(10, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.selectOutButton = jButton25 = new JButton();
        jButton25.setFocusPainted(false);
        jButton25.setFocusable(true);
        Font font2 = this.$$$getFont$$$(null, 0, -1, jButton25.getFont());
        if (font2 != null) {
            jButton25.setFont(font2);
        }
        jButton25.setText("Seleccionar");
        jPanel3.add((Component)jButton25, new GridConstraints(11, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.selectedOut = jTextField19 = new JTextField();
        jTextField19.setEditable(false);
        ((Component)jTextField19).setEnabled(true);
        jTextField19.setFocusable(true);
        jTextField19.setText("");
        jPanel3.add((Component)jTextField19, new GridConstraints(11, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.CODCheckBox = jCheckBox8 = new JCheckBox();
        jCheckBox8.setFocusPainted(false);
        Font font3 = this.$$$getFont$$$(null, 0, -1, jCheckBox8.getFont());
        if (font3 != null) {
            jCheckBox8.setFont(font3);
        }
        jCheckBox8.setSelected(false);
        jCheckBox8.setText("Firmar COD por Exportador");
        jPanel3.add((Component)jCheckBox8, new GridConstraints(5, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.CODEHCheckBox = jCheckBox7 = new JCheckBox();
        jCheckBox7.setFocusPainted(false);
        Font font4 = this.$$$getFont$$$(null, 0, -1, jCheckBox7.getFont());
        if (font4 != null) {
            jCheckBox7.setFont(font4);
        }
        jCheckBox7.setText("Firmar CODEH por Funcionario");
        jPanel3.add((Component)jCheckBox7, new GridConstraints(5, 1, 1, 2, 0, 0, 3, 2, null, null, null));
        this.signButton = jButton24 = new JButton();
        jButton24.setFocusPainted(false);
        Font font5 = this.$$$getFont$$$(null, 1, -1, jButton24.getFont());
        if (font5 != null) {
            jButton24.setFont(font5);
        }
        jButton24.setText("Firmar");
        jPanel3.add((Component)jButton24, new GridConstraints(13, 1, 1, 2, 0, 0, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel5, new GridConstraints(15, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.selectPEMButton = jButton23 = new JButton();
        jButton23.setFocusPainted(false);
        jButton23.setFocusable(true);
        Font font6 = this.$$$getFont$$$(null, 0, -1, jButton23.getFont());
        if (font6 != null) {
            jButton23.setFont(font6);
        }
        jButton23.setText("Seleccionar");
        jPanel3.add((Component)jButton23, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 1, new Insets(10, 20, 10, 20), -1, -1, false, false));
        jPanel3.add((Component)jPanel6, new GridConstraints(12, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator2 = new JSeparator();
        jPanel6.add((Component)jSeparator2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 6, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(9, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.openXML = jButton22 = new JButton();
        ((Component)jButton22).setEnabled(false);
        jButton22.setFocusPainted(false);
        Font font7 = this.$$$getFont$$$(null, 1, -1, jButton22.getFont());
        if (font7 != null) {
            jButton22.setFont(font7);
        }
        jButton22.setText("Abrir documento");
        jPanel3.add((Component)jButton22, new GridConstraints(14, 1, 1, 2, 0, 0, 3, 0, null, null, null));
        this.openLog = jButton21 = new JButton();
        ((Component)jButton21).setEnabled(false);
        jButton21.setFocusPainted(false);
        Font font8 = this.$$$getFont$$$(null, 1, -1, jButton21.getFont());
        if (font8 != null) {
            jButton21.setFont(font8);
        }
        jButton21.setText("Abrir logs");
        jPanel3.add((Component)jButton21, new GridConstraints(14, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.selectDocButton = jButton20 = new JButton();
        jButton20.setFocusPainted(false);
        jButton20.setFocusable(true);
        Font font9 = this.$$$getFont$$$(null, 0, -1, jButton20.getFont());
        if (font9 != null) {
            jButton20.setFont(font9);
        }
        jButton20.setText("Seleccionar");
        jPanel3.add((Component)jButton20, new GridConstraints(8, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.listDocCheckBox = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Utilizar lista");
        jPanel3.add((Component)jCheckBox6, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(18, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Hardware", null, jPanel9, null);
        jPanel9.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), null, 0, 0, null, null));
        this.selectedConf = jTextField18 = new JTextField();
        jTextField18.setEditable(false);
        ((Component)jTextField18).setEnabled(true);
        jTextField18.setFocusable(true);
        jTextField18.setText("");
        jPanel9.add((Component)jTextField18, new GridConstraints(2, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(1, 1, new Insets(10, 20, 10, 20), -1, -1, false, false));
        jPanel9.add((Component)jPanel10, new GridConstraints(5, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator3 = new JSeparator();
        jPanel10.add((Component)jSeparator3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 6, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel11, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Seleccionar el archivo de configuraci\u00f3n:");
        jPanel9.add((Component)jLabel5, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Etiqueta XML a firmar:");
        jPanel9.add((Component)jLabel6, new GridConstraints(6, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel7 = new JLabel();
        jLabel7.setFocusable(true);
        jLabel7.setText("Documento XML a firmar:");
        jPanel9.add((Component)jLabel7, new GridConstraints(8, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.selectedDocH = jTextField17 = new JTextField();
        jTextField17.setEditable(false);
        ((Component)jTextField17).setEnabled(true);
        jTextField17.setFocusable(true);
        jTextField17.setText("");
        jPanel9.add((Component)jTextField17, new GridConstraints(10, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel8 = new JLabel();
        jLabel8.setFocusable(true);
        Font font10 = this.$$$getFont$$$(null, -1, -1, jLabel8.getFont());
        if (font10 != null) {
            jLabel8.setFont(font10);
        }
        jLabel8.setText("Documento XML o carpeta de salida:");
        jPanel9.add((Component)jLabel8, new GridConstraints(12, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.selectOutButtonH = jButton19 = new JButton();
        jButton19.setFocusPainted(false);
        jButton19.setFocusable(true);
        Font font11 = this.$$$getFont$$$(null, 0, -1, jButton19.getFont());
        if (font11 != null) {
            jButton19.setFont(font11);
        }
        jButton19.setText("Seleccionar");
        jPanel9.add((Component)jButton19, new GridConstraints(13, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.selectedOutH = jTextField16 = new JTextField();
        jTextField16.setEditable(false);
        ((Component)jTextField16).setEnabled(true);
        jTextField16.setFocusable(true);
        jTextField16.setText("");
        jPanel9.add((Component)jTextField16, new GridConstraints(13, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.CODCheckBoxH = jCheckBox5 = new JCheckBox();
        jCheckBox5.setFocusPainted(false);
        Font font12 = this.$$$getFont$$$(null, 0, -1, jCheckBox5.getFont());
        if (font12 != null) {
            jCheckBox5.setFont(font12);
        }
        jCheckBox5.setSelected(false);
        jCheckBox5.setText("Firmar COD por Exportador");
        jPanel9.add((Component)jCheckBox5, new GridConstraints(7, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.CODEHCheckBoxH = jCheckBox4 = new JCheckBox();
        jCheckBox4.setFocusPainted(false);
        Font font13 = this.$$$getFont$$$(null, 0, -1, jCheckBox4.getFont());
        if (font13 != null) {
            jCheckBox4.setFont(font13);
        }
        jCheckBox4.setText("Firmar CODEH por Funcionario");
        jPanel9.add((Component)jCheckBox4, new GridConstraints(7, 1, 1, 2, 0, 0, 3, 2, null, null, null));
        this.signButtonH = jButton18 = new JButton();
        jButton18.setFocusPainted(false);
        Font font14 = this.$$$getFont$$$(null, 1, -1, jButton18.getFont());
        if (font14 != null) {
            jButton18.setFont(font14);
        }
        jButton18.setText("Firmar");
        jPanel9.add((Component)jButton18, new GridConstraints(15, 1, 1, 2, 0, 0, 3, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel12, new GridConstraints(17, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(1, 1, new Insets(10, 20, 10, 20), -1, -1, false, false));
        jPanel9.add((Component)jPanel13, new GridConstraints(14, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator4 = new JSeparator();
        jPanel13.add((Component)jSeparator4, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 6, null, null, null));
        this.selectConfButton = jButton17 = new JButton();
        jButton17.setFocusPainted(false);
        jButton17.setFocusable(true);
        Font font15 = this.$$$getFont$$$(null, 0, -1, jButton17.getFont());
        if (font15 != null) {
            jButton17.setFont(font15);
        }
        jButton17.setText("Seleccionar");
        jPanel9.add((Component)jButton17, new GridConstraints(2, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Contrase\u00f1a:");
        jPanel9.add((Component)jLabel9, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.passwordField = jPasswordField2 = new JPasswordField();
        jPasswordField2.setText("");
        jPanel9.add((Component)jPasswordField2, new GridConstraints(4, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel14, new GridConstraints(11, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.openXMLH = jButton16 = new JButton();
        ((Component)jButton16).setEnabled(false);
        jButton16.setFocusPainted(false);
        Font font16 = this.$$$getFont$$$(null, 1, -1, jButton16.getFont());
        if (font16 != null) {
            jButton16.setFont(font16);
        }
        jButton16.setText("Abrir documento");
        jPanel9.add((Component)jButton16, new GridConstraints(16, 1, 1, 2, 0, 0, 3, 0, null, null, null));
        this.openLogH = jButton15 = new JButton();
        ((Component)jButton15).setEnabled(false);
        jButton15.setFocusPainted(false);
        Font font17 = this.$$$getFont$$$(null, 1, -1, jButton15.getFont());
        if (font17 != null) {
            jButton15.setFont(font17);
        }
        jButton15.setText("Abrir logs");
        jPanel9.add((Component)jButton15, new GridConstraints(16, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.selectDocButtonH = jButton14 = new JButton();
        jButton14.setFocusPainted(false);
        jButton14.setFocusable(true);
        Font font18 = this.$$$getFont$$$(null, 0, -1, jButton14.getFont());
        if (font18 != null) {
            jButton14.setFont(font18);
        }
        jButton14.setText("Seleccionar");
        jPanel9.add((Component)jButton14, new GridConstraints(10, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.listDocCheckBoxH = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Utilizar lista");
        jPanel9.add((Component)jCheckBox3, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout(new GridLayoutManager(20, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane2.addTab("Validar", null, jPanel15, null);
        jPanel15.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), null, 0, 0, null, null));
        this.selectedDocVal = jTextField15 = new JTextField();
        jTextField15.setEditable(false);
        ((Component)jTextField15).setEnabled(true);
        jTextField15.setFocusable(true);
        jTextField15.setText("");
        jPanel15.add((Component)jTextField15, new GridConstraints(5, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Documento XML a validar:");
        jPanel15.add((Component)jLabel10, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel11 = new JLabel();
        jLabel11.setFocusable(true);
        jLabel11.setText("Seleccionar XSD:");
        jPanel15.add((Component)jLabel11, new GridConstraints(11, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.selectedXSD = jTextField14 = new JTextField();
        jTextField14.setEditable(false);
        ((Component)jTextField14).setEnabled(true);
        jTextField14.setFocusable(true);
        jTextField14.setText("");
        jPanel15.add((Component)jTextField14, new GridConstraints(12, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel12 = new JLabel();
        jLabel12.setFocusable(true);
        Font font19 = this.$$$getFont$$$(null, -1, -1, jLabel12.getFont());
        if (font19 != null) {
            jLabel12.setFont(font19);
        }
        jLabel12.setText("Documento XML a validar:");
        jPanel15.add((Component)jLabel12, new GridConstraints(14, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.selectDocXSDButton = jButton13 = new JButton();
        jButton13.setFocusPainted(false);
        jButton13.setFocusable(true);
        Font font20 = this.$$$getFont$$$(null, 0, -1, jButton13.getFont());
        if (font20 != null) {
            jButton13.setFont(font20);
        }
        jButton13.setText("Seleccionar");
        jPanel15.add((Component)jButton13, new GridConstraints(16, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.selectedDocXSD = jTextField13 = new JTextField();
        jTextField13.setEditable(false);
        ((Component)jTextField13).setEnabled(true);
        jTextField13.setFocusable(true);
        jTextField13.setText("");
        jPanel15.add((Component)jTextField13, new GridConstraints(16, 0, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel16, new GridConstraints(19, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel16.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.selectXSDButton = jButton12 = new JButton();
        jButton12.setFocusPainted(false);
        jButton12.setFocusable(true);
        Font font21 = this.$$$getFont$$$(null, 0, -1, jButton12.getFont());
        if (font21 != null) {
            jButton12.setFont(font21);
        }
        jButton12.setText("Seleccionar");
        jPanel15.add((Component)jButton12, new GridConstraints(12, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.selectDocValButton = jButton11 = new JButton();
        jButton11.setFocusPainted(false);
        jButton11.setFocusable(true);
        Font font22 = this.$$$getFont$$$(null, 0, -1, jButton11.getFont());
        if (font22 != null) {
            jButton11.setFont(font22);
        }
        jButton11.setText("Seleccionar");
        jPanel15.add((Component)jButton11, new GridConstraints(5, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new GridLayoutManager(1, 1, new Insets(0, 20, 0, 20), -1, -1, false, false));
        jPanel15.add((Component)jPanel17, new GridConstraints(8, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JSeparator jSeparator5 = new JSeparator();
        jPanel17.add((Component)jSeparator5, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 6, null, null, null));
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel18, new GridConstraints(13, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel19 = new JPanel();
        jPanel19.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel19, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel13 = new JLabel();
        Font font23 = this.$$$getFont$$$(null, -1, -1, jLabel13.getFont());
        if (font23 != null) {
            jLabel13.setFont(font23);
        }
        jLabel13.setText("Validaci\u00f3n contra esquema");
        jPanel15.add((Component)jLabel13, new GridConstraints(9, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        JLabel jLabel14 = new JLabel();
        Font font24 = this.$$$getFont$$$(null, -1, -1, jLabel14.getFont());
        if (font24 != null) {
            jLabel14.setFont(font24);
        }
        jLabel14.setText("Validaci\u00f3n de la firma");
        jPanel15.add((Component)jLabel14, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 2));
        JPanel jPanel20 = new JPanel();
        jPanel20.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel20, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel21 = new JPanel();
        jPanel21.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel21, new GridConstraints(10, 1, 1, 2, 0, 3, 3, 3, null, null, null));
        this.validateButton = jButton10 = new JButton();
        jButton10.setFocusPainted(false);
        Font font25 = this.$$$getFont$$$(null, 1, -1, jButton10.getFont());
        if (font25 != null) {
            jButton10.setFont(font25);
        }
        jButton10.setText("Validar");
        jPanel15.add((Component)jButton10, new GridConstraints(7, 1, 1, 2, 0, 0, 3, 0, null, null, null));
        this.validateXSDButton = jButton9 = new JButton();
        jButton9.setFocusPainted(false);
        Font font26 = this.$$$getFont$$$(null, 1, -1, jButton9.getFont());
        if (font26 != null) {
            jButton9.setFont(font26);
        }
        jButton9.setText("Validar");
        jPanel15.add((Component)jButton9, new GridConstraints(18, 1, 1, 2, 0, 0, 3, 0, null, null, null));
        JPanel jPanel22 = new JPanel();
        jPanel22.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel22, new GridConstraints(6, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel23 = new JPanel();
        jPanel23.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel23, new GridConstraints(17, 2, 1, 1, 0, 3, 3, 3, null, null, null));
        this.listValCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Utilizar lista");
        jPanel15.add((Component)jCheckBox2, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.listXSDCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Utilizar lista");
        jPanel15.add((Component)jCheckBox, new GridConstraints(15, 0, 1, 1, 8, 0, 3, 0, null, null, null, 2));
        this.openLogXSD = jButton8 = new JButton();
        ((Component)jButton8).setEnabled(false);
        jButton8.setFocusPainted(false);
        Font font27 = this.$$$getFont$$$(null, 1, -1, jButton8.getFont());
        if (font27 != null) {
            jButton8.setFont(font27);
        }
        jButton8.setText("Abrir logs");
        jPanel15.add((Component)jButton8, new GridConstraints(18, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        this.openLogVal = jButton7 = new JButton();
        ((Component)jButton7).setEnabled(false);
        jButton7.setFocusPainted(false);
        Font font28 = this.$$$getFont$$$(null, 1, -1, jButton7.getFont());
        if (font28 != null) {
            jButton7.setFont(font28);
        }
        jButton7.setText("Abrir logs");
        jPanel15.add((Component)jButton7, new GridConstraints(7, 0, 1, 1, 0, 0, 3, 0, null, null, null));
        JPanel jPanel24 = new JPanel();
        jPanel24.setLayout(new GridLayoutManager(1, 1, new Insets(2, 4, 2, 4), -1, -1, false, false));
        jTabbedPane2.addTab("Certificado", null, jPanel24, null);
        JTabbedPane jTabbedPane3 = new JTabbedPane();
        jPanel24.add((Component)jTabbedPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel25 = new JPanel();
        jPanel25.setLayout(new GridLayoutManager(9, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane3.addTab("Software", null, jPanel25, null);
        jPanel25.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), null, 0, 0, null, null));
        this.selectedPEMCert = jTextField12 = new JTextField();
        jTextField12.setEditable(false);
        ((Component)jTextField12).setEnabled(true);
        jTextField12.setFocusable(true);
        jTextField12.setText("");
        jPanel25.add((Component)jTextField12, new GridConstraints(2, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.selectPEMCertButton = jButton6 = new JButton();
        jButton6.setFocusPainted(false);
        jButton6.setFocusable(true);
        Font font29 = this.$$$getFont$$$(null, 0, -1, jButton6.getFont());
        if (font29 != null) {
            jButton6.setFont(font29);
        }
        jButton6.setText("Seleccionar");
        jPanel25.add((Component)jButton6, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel25.add((Component)spacer2, new GridConstraints(5, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.certSwButton = jButton5 = new JButton();
        jButton5.setFocusPainted(false);
        Font font30 = this.$$$getFont$$$(null, 1, -1, jButton5.getFont());
        if (font30 != null) {
            jButton5.setFont(font30);
        }
        jButton5.setText("Extraer");
        jPanel25.add((Component)jButton5, new GridConstraints(4, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JLabel jLabel15 = new JLabel();
        jLabel15.setText("                               ");
        jPanel25.add((Component)jLabel15, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel16 = new JLabel();
        jLabel16.setText("                               ");
        jPanel25.add((Component)jLabel16, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel17 = new JLabel();
        jLabel17.setText("Seleccionar certificado:");
        jPanel25.add((Component)jLabel17, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JPanel jPanel26 = new JPanel();
        jPanel26.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel25.add((Component)jPanel26, new GridConstraints(6, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel27 = new JPanel();
        jPanel27.setLayout(new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel26.add((Component)jPanel27, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.issuerS = jTextField11 = new JTextField();
        jTextField11.setEditable(false);
        ((Component)jTextField11).setEnabled(true);
        jTextField11.setFocusable(true);
        jTextField11.setText("");
        jPanel27.add((Component)jTextField11, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.sinceS = jTextField10 = new JTextField();
        jTextField10.setEditable(false);
        ((Component)jTextField10).setEnabled(true);
        jTextField10.setFocusable(true);
        jTextField10.setText("");
        jPanel27.add((Component)jTextField10, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel18 = new JLabel();
        jLabel18.setText("V\u00e1lido desde:");
        jPanel27.add((Component)jLabel18, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.untilS = jTextField9 = new JTextField();
        jTextField9.setEditable(false);
        ((Component)jTextField9).setEnabled(true);
        jTextField9.setFocusable(true);
        jTextField9.setText("");
        jPanel27.add((Component)jTextField9, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel19 = new JLabel();
        jLabel19.setText("hasta:");
        jPanel27.add((Component)jLabel19, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null, 1));
        JLabel jLabel20 = new JLabel();
        jLabel20.setText("Emisor:");
        jPanel27.add((Component)jLabel20, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.algorithmS = jTextField8 = new JTextField();
        jTextField8.setEditable(false);
        ((Component)jTextField8).setEnabled(true);
        jTextField8.setFocusable(true);
        jTextField8.setText("");
        jPanel27.add((Component)jTextField8, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel21 = new JLabel();
        jLabel21.setText("Algor\u00edtmo:");
        jPanel27.add((Component)jLabel21, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.serialS = jTextField7 = new JTextField();
        jTextField7.setEditable(false);
        ((Component)jTextField7).setEnabled(true);
        jTextField7.setFocusable(true);
        jTextField7.setText("");
        jPanel27.add((Component)jTextField7, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel22 = new JLabel();
        jLabel22.setText("N\u00famero de Serie:");
        jPanel27.add((Component)jLabel22, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.moreInfoS = jButton4 = new JButton();
        ((Component)jButton4).setEnabled(false);
        jButton4.setFocusPainted(false);
        Font font31 = this.$$$getFont$$$(null, 1, -1, jButton4.getFont());
        if (font31 != null) {
            jButton4.setFont(font31);
        }
        jButton4.setHideActionText(false);
        jButton4.setInheritsPopupMenu(false);
        jButton4.setText("M\u00e1s informaci\u00f3n");
        jPanel25.add((Component)jButton4, new GridConstraints(7, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JLabel jLabel23 = new JLabel();
        jLabel23.setText("   ");
        jPanel25.add((Component)jLabel23, new GridConstraints(8, 0, 1, 1, 8, 2, 0, 0, null, null, null));
        JPanel jPanel28 = new JPanel();
        jPanel28.setLayout(new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane3.addTab("Hardware", null, jPanel28, null);
        jPanel28.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2), null, 0, 0, null, null));
        this.selectedConfCert = jTextField6 = new JTextField();
        jTextField6.setEditable(false);
        ((Component)jTextField6).setEnabled(true);
        jTextField6.setFocusable(true);
        jTextField6.setText("");
        jPanel28.add((Component)jTextField6, new GridConstraints(2, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.selectConfCertButton = jButton3 = new JButton();
        jButton3.setFocusPainted(false);
        jButton3.setFocusable(true);
        Font font32 = this.$$$getFont$$$(null, 0, -1, jButton3.getFont());
        if (font32 != null) {
            jButton3.setFont(font32);
        }
        jButton3.setText("Seleccionar");
        jPanel28.add((Component)jButton3, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel28.add((Component)spacer3, new GridConstraints(7, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.certHwButton = jButton2 = new JButton();
        jButton2.setFocusPainted(false);
        Font font33 = this.$$$getFont$$$(null, 1, -1, jButton2.getFont());
        if (font33 != null) {
            jButton2.setFont(font33);
        }
        jButton2.setText("Extraer");
        jPanel28.add((Component)jButton2, new GridConstraints(6, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JLabel jLabel24 = new JLabel();
        jLabel24.setText("                               ");
        jPanel28.add((Component)jLabel24, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel25 = new JLabel();
        jLabel25.setText("                               ");
        jPanel28.add((Component)jLabel25, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel26 = new JLabel();
        jLabel26.setText("Seleccionar el archivo de configuraci\u00f3n:");
        jPanel28.add((Component)jLabel26, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel27 = new JLabel();
        jLabel27.setText("Contrase\u00f1a:");
        jPanel28.add((Component)jLabel27, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.passwordCertField = jPasswordField = new JPasswordField();
        jPasswordField.setText("");
        jPanel28.add((Component)jPasswordField, new GridConstraints(4, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JPanel jPanel29 = new JPanel();
        jPanel29.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel28.add((Component)jPanel29, new GridConstraints(8, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JPanel jPanel30 = new JPanel();
        jPanel30.setLayout(new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel29.add((Component)jPanel30, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.issuerH = jTextField5 = new JTextField();
        jTextField5.setEditable(false);
        ((Component)jTextField5).setEnabled(true);
        jTextField5.setFocusable(true);
        jTextField5.setText("");
        jPanel30.add((Component)jTextField5, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        this.sinceH = jTextField4 = new JTextField();
        jTextField4.setEditable(false);
        ((Component)jTextField4).setEnabled(true);
        jTextField4.setFocusable(true);
        jTextField4.setText("");
        jPanel30.add((Component)jTextField4, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel28 = new JLabel();
        jLabel28.setText("V\u00e1lido desde:");
        jPanel30.add((Component)jLabel28, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.untilH = jTextField3 = new JTextField();
        jTextField3.setEditable(false);
        ((Component)jTextField3).setEnabled(true);
        jTextField3.setFocusable(true);
        jTextField3.setText("");
        jPanel30.add((Component)jTextField3, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel29 = new JLabel();
        jLabel29.setText("hasta:");
        jPanel30.add((Component)jLabel29, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null, 1));
        JLabel jLabel30 = new JLabel();
        jLabel30.setText("Emisor:");
        jPanel30.add((Component)jLabel30, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.algorithmH = jTextField2 = new JTextField();
        jTextField2.setEditable(false);
        ((Component)jTextField2).setEnabled(true);
        jTextField2.setFocusable(true);
        jTextField2.setText("");
        jPanel30.add((Component)jTextField2, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel31 = new JLabel();
        jLabel31.setText("Algor\u00edtmo:");
        jPanel30.add((Component)jLabel31, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.serialH = jTextField = new JTextField();
        jTextField.setEditable(false);
        ((Component)jTextField).setEnabled(true);
        jTextField.setFocusable(true);
        jTextField.setText("");
        jPanel30.add((Component)jTextField, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null, 1));
        JLabel jLabel32 = new JLabel();
        jLabel32.setText("N\u00famero de Serie:");
        jPanel30.add((Component)jLabel32, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.moreInfoH = jButton = new JButton();
        ((Component)jButton).setEnabled(false);
        jButton.setFocusPainted(false);
        Font font34 = this.$$$getFont$$$(null, 1, -1, jButton.getFont());
        if (font34 != null) {
            jButton.setFont(font34);
        }
        jButton.setHideActionText(false);
        jButton.setInheritsPopupMenu(false);
        jButton.setText("M\u00e1s informaci\u00f3n");
        jPanel28.add((Component)jButton, new GridConstraints(9, 1, 1, 1, 0, 0, 3, 0, null, null, null));
        JLabel jLabel33 = new JLabel();
        jLabel33.setText("   ");
        jPanel28.add((Component)jLabel33, new GridConstraints(10, 0, 1, 1, 8, 2, 0, 0, null, null, null));
        JPanel jPanel31 = new JPanel();
        jPanel31.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane2.addTab("Acerca de...", null, jPanel31, null);
        JPanel jPanel32 = new JPanel();
        jPanel32.setLayout(new GridLayoutManager(1, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        jPanel31.add((Component)jPanel32, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JScrollPane jScrollPane = new JScrollPane();
        jPanel32.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.editorPane1 = jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jScrollPane.setViewportView(jEditorPane);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panelMain;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

