/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keyfactories;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs11.objects.ByteArrayAttribute;
import iaik.pkcs.pkcs11.objects.ECDSAPrivateKey;
import iaik.pkcs.pkcs11.objects.ECDSAPublicKey;
import iaik.pkcs.pkcs11.objects.GenericTemplate;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.NonExtractableComponentException;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeyFactory;
import iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import iaik.pkcs.pkcs11.wrapper.Functions;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class EcDsaKeyFactory
extends PKCS11KeyFactory {
    protected static String c = "ECDSA";
    protected static final ObjectID d = new ObjectID("1.2.840.10045.2.1");
    protected static final AlgorithmID e = new AlgorithmID(d);
    public static final INTEGER EC_PRIVATE_KEY_VERSION = new INTEGER(1);
    private static boolean a;
    private static boolean b;
    static Class f;
    static Class g;

    protected static boolean c() {
        if (!b) {
            try {
                String string = System.getProperty("java.version");
                if (string != null && string.compareTo("1.5") < 0) {
                    a = false;
                } else {
                    Class.forName("iaik.security.ec.common.ECParameterSpec");
                    a = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                a = false;
            }
            catch (SecurityException securityException) {
                a = false;
            }
            b = true;
        }
        return a;
    }

    protected String a() {
        return c;
    }

    protected String b() {
        return c;
    }

    protected PublicKey a(KeySpec keySpec) {
        byte[] byArray;
        byte[] byArray2;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.k = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.k.getKeySpec();
        if (keySpec2 instanceof X509EncodedKeySpec) {
            X509EncodedKeySpec x509EncodedKeySpec = (X509EncodedKeySpec)keySpec2;
            byte[] byArray3 = x509EncodedKeySpec.getEncoded();
            try {
                ASN1 aSN1 = new ASN1(byArray3);
                AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(0));
                ASN1Object aSN1Object = algorithmID.getParameter();
                byArray2 = DerCoder.encode((ASN1Object)aSN1Object);
                BIT_STRING bIT_STRING = (BIT_STRING)aSN1.getComponentAt(1);
                OCTET_STRING oCTET_STRING = new OCTET_STRING((byte[])bIT_STRING.getValue());
                byArray = DerCoder.encode((ASN1Object)oCTET_STRING);
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("The public key spec could not be parsed: " + exception.toString());
            }
        } else {
            if (EcDsaKeyFactory.c()) {
                try {
                    Class<?> clazz = Class.forName("iaik.pkcs.pkcs11.provider.keyfactories.a");
                    EcDsaKeyFactory ecDsaKeyFactory = (EcDsaKeyFactory)clazz.newInstance();
                    return ecDsaKeyFactory.a(keySpec);
                }
                catch (Throwable throwable) {
                    throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.X509EncodedKeySpec.");
                }
            }
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.X509EncodedKeySpec.");
        }
        return this.a(byArray2, byArray);
    }

    protected PublicKey a(byte[] byArray, byte[] byArray2) {
        ECDSAPublicKey eCDSAPublicKey = new ECDSAPublicKey();
        eCDSAPublicKey.getEcdsaParams().setByteArrayValue(byArray);
        eCDSAPublicKey.getEcPoint().setByteArrayValue(byArray2);
        GenericTemplate genericTemplate = new GenericTemplate();
        iaik.pkcs.pkcs11.objects.Object object = this.k.getKeyTemplate();
        if (object != null) {
            genericTemplate.addAllPresentAttributes(object);
        }
        genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)eCDSAPublicKey);
        return (PublicKey)this.a((iaik.pkcs.pkcs11.objects.Object)genericTemplate);
    }

    protected PrivateKey b(KeySpec keySpec) {
        byte[] byArray;
        byte[] byArray2;
        if (keySpec == null) {
            throw new NullPointerException("Argument \"keySpec\" must not be null.");
        }
        if (!(keySpec instanceof PKCS11KeySpec)) {
            throw new IllegalArgumentException("Argument \"keySpec\" must be of instance iaik.pkcs.pkcs11.provider.keyfactories.PKCS11KeySpec.");
        }
        this.k = (PKCS11KeySpec)keySpec;
        KeySpec keySpec2 = this.k.getKeySpec();
        if (keySpec2 instanceof PKCS8EncodedKeySpec) {
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = (PKCS8EncodedKeySpec)keySpec2;
            byte[] byArray3 = pKCS8EncodedKeySpec.getEncoded();
            try {
                ASN1 aSN1 = new ASN1(byArray3);
                AlgorithmID algorithmID = new AlgorithmID(aSN1.getComponentAt(1));
                ASN1Object aSN1Object = algorithmID.getParameter();
                byArray2 = DerCoder.encode((ASN1Object)aSN1Object);
                OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1.getComponentAt(2);
                SEQUENCE sEQUENCE = (SEQUENCE)DerCoder.decode((byte[])((byte[])oCTET_STRING.getValue()));
                INTEGER iNTEGER = (INTEGER)sEQUENCE.getComponentAt(0);
                if (!iNTEGER.getValue().equals(EC_PRIVATE_KEY_VERSION.getValue())) {
                    throw new InvalidKeySpecException("The encoded private key has an invalid version field: " + iNTEGER.toString());
                }
                OCTET_STRING oCTET_STRING2 = (OCTET_STRING)sEQUENCE.getComponentAt(1);
                byArray = (byte[])oCTET_STRING2.getValue();
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw invalidKeySpecException;
            }
            catch (Exception exception) {
                throw new InvalidKeySpecException("The private key spec could not be parsed: " + exception.toString());
            }
        } else {
            if (EcDsaKeyFactory.c()) {
                try {
                    Class<?> clazz = Class.forName("iaik.pkcs.pkcs11.provider.keyfactories.a");
                    EcDsaKeyFactory ecDsaKeyFactory = (EcDsaKeyFactory)clazz.newInstance();
                    return ecDsaKeyFactory.b(keySpec);
                }
                catch (Throwable throwable) {
                    throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.X509EncodedKeySpec.");
                }
            }
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.PKCS8EncodedKeySpec.");
        }
        return this.b(byArray2, byArray);
    }

    protected PrivateKey b(byte[] byArray, byte[] byArray2) {
        ECDSAPrivateKey eCDSAPrivateKey = new ECDSAPrivateKey();
        eCDSAPrivateKey.getEcdsaParams().setByteArrayValue(byArray);
        eCDSAPrivateKey.getValue().setByteArrayValue(byArray2);
        GenericTemplate genericTemplate = new GenericTemplate();
        genericTemplate.addAllPresentAttributes((iaik.pkcs.pkcs11.objects.Object)eCDSAPrivateKey);
        iaik.pkcs.pkcs11.objects.Object object = this.k.getKeyTemplate();
        if (object != null) {
            genericTemplate.addAllPresentAttributes(object);
        }
        return (PrivateKey)this.a((iaik.pkcs.pkcs11.objects.Object)genericTemplate);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected KeySpec a(Key key, Class clazz) {
        void var3_6;
        if (key == null) {
            throw new NullPointerException("Argument \"key\" must not be null.");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument \"keySpecClass\" must not be null.");
        }
        Object var3_3 = null;
        if (clazz.equals(f == null ? (f = EcDsaKeyFactory.b("java.security.spec.X509EncodedKeySpec")) : f)) {
            byte[] byArray;
            if (!(key instanceof IAIKPKCS11PublicKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PublicKey to get an X509EncodedKeySpec.");
            IAIKPKCS11PublicKey iAIKPKCS11PublicKey = (IAIKPKCS11PublicKey)key;
            iaik.pkcs.pkcs11.objects.Key key2 = iAIKPKCS11PublicKey.getKeyObject();
            if (!(key2 instanceof ECDSAPublicKey)) throw new InvalidKeySpecException("This factory does only accept ECDSA keys, but the PKCS#11 key object in the given key is: " + key2);
            ECDSAPublicKey eCDSAPublicKey = (ECDSAPublicKey)key2;
            this.a(eCDSAPublicKey);
            ByteArrayAttribute byteArrayAttribute = eCDSAPublicKey.getEcdsaParams();
            ByteArrayAttribute byteArrayAttribute2 = eCDSAPublicKey.getEcPoint();
            byte[] byArray2 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray3 = byteArrayAttribute2.getByteArrayValue();
            try {
                AlgorithmID algorithmID = (AlgorithmID)e.clone();
                ASN1 aSN1 = new ASN1(byArray2);
                algorithmID.setParameter(aSN1.toASN1Object());
                ASN1Object aSN1Object = DerCoder.decode((byte[])byArray3);
                if (!aSN1Object.isA(ASN.OCTET_STRING)) {
                    throw new InvalidKeySpecException("The encoded public key value of the PKCS#11 key is no OCTET STRING: " + Functions.toHexString((byte[])byArray3));
                }
                OCTET_STRING oCTET_STRING = (OCTET_STRING)aSN1Object;
                BIT_STRING bIT_STRING = new BIT_STRING((byte[])oCTET_STRING.getValue());
                oCTET_STRING = new SEQUENCE();
                oCTET_STRING.addComponent(algorithmID.toASN1Object());
                oCTET_STRING.addComponent((ASN1Object)bIT_STRING);
                byArray = DerCoder.encode((ASN1Object)oCTET_STRING);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of ECDSA public key: " + codingException.toString());
            }
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray);
            return var3_6;
        }
        if (clazz.equals(g == null ? (g = EcDsaKeyFactory.b("java.security.spec.PKCS8EncodedKeySpec")) : g)) {
            byte[] byArray;
            if (!(key instanceof IAIKPKCS11PrivateKey)) throw new InvalidKeySpecException("For this factory, the key must be a IAIKPKCS11PrivateKey to get a PKCS8EncodedKeySpec.");
            IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = (IAIKPKCS11PrivateKey)key;
            iaik.pkcs.pkcs11.objects.Key key3 = iAIKPKCS11PrivateKey.getKeyObject();
            if (!(key3 instanceof ECDSAPrivateKey)) throw new InvalidKeySpecException("This factory does only accept ECDSA keys, but the PKCS#11 key object in the given key is: " + key3);
            ECDSAPrivateKey eCDSAPrivateKey = (ECDSAPrivateKey)key3;
            this.a(eCDSAPrivateKey);
            ByteArrayAttribute byteArrayAttribute = eCDSAPrivateKey.getEcdsaParams();
            ByteArrayAttribute byteArrayAttribute3 = eCDSAPrivateKey.getValue();
            byte[] byArray4 = byteArrayAttribute.getByteArrayValue();
            byte[] byArray5 = byteArrayAttribute3.getByteArrayValue();
            try {
                AlgorithmID algorithmID = (AlgorithmID)e.clone();
                ASN1 aSN1 = new ASN1(byArray4);
                algorithmID.setParameter(aSN1.toASN1Object());
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent((ASN1Object)new INTEGER(0));
                sEQUENCE.addComponent(algorithmID.toASN1Object());
                SEQUENCE sEQUENCE2 = new SEQUENCE();
                sEQUENCE2.addComponent((ASN1Object)EC_PRIVATE_KEY_VERSION);
                sEQUENCE2.addComponent((ASN1Object)new OCTET_STRING(byArray5));
                OCTET_STRING oCTET_STRING = new OCTET_STRING(DerCoder.encode((ASN1Object)sEQUENCE2));
                sEQUENCE.addComponent((ASN1Object)oCTET_STRING);
                byArray = DerCoder.encode((ASN1Object)sEQUENCE);
            }
            catch (CodingException codingException) {
                throw new InvalidKeySpecException("Error during encoding of ECDSA private key: " + codingException.toString());
            }
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray);
            return var3_6;
        }
        if (!EcDsaKeyFactory.c()) throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.PKCS8EncodedKeySpec or java.security.spec.X509EncodedKeySpec.");
        try {
            Class<?> clazz2 = Class.forName("iaik.pkcs.pkcs11.provider.keyfactories.a");
            EcDsaKeyFactory ecDsaKeyFactory = (EcDsaKeyFactory)clazz2.newInstance();
            return ecDsaKeyFactory.a(key, clazz);
        }
        catch (Throwable throwable) {
            throw new InvalidKeySpecException("The actual key spec inside the given PKCS11KeySpec must be of type java.security.spec.PKCS8EncodedKeySpec or java.security.spec.X509EncodedKeySpec.");
        }
    }

    protected void a(ECDSAPublicKey eCDSAPublicKey) {
        ByteArrayAttribute byteArrayAttribute = eCDSAPublicKey.getEcdsaParams();
        ByteArrayAttribute byteArrayAttribute2 = eCDSAPublicKey.getEcPoint();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 EC key object does not possess a parameters attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 EC key object does not possess a point attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's parameters attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's point attribute is sensitive.");
        }
    }

    protected void a(ECDSAPrivateKey eCDSAPrivateKey) {
        ByteArrayAttribute byteArrayAttribute = eCDSAPrivateKey.getEcdsaParams();
        ByteArrayAttribute byteArrayAttribute2 = eCDSAPrivateKey.getValue();
        if (!byteArrayAttribute.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 EC key object does not possess a parameters attribute.");
        }
        if (!byteArrayAttribute2.isPresent()) {
            throw new IAIKPkcs11Exception("The PKCS#11 EC key object does not possess a private value attribute.");
        }
        if (byteArrayAttribute.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's parameters attribute is sensitive.");
        }
        if (byteArrayAttribute2.isSensitive()) {
            throw new NonExtractableComponentException("The PKCS#11 EC key object's private value attribute is sensitive.");
        }
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

