/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11.provider.keypairgenerators;

import iaik.pkcs.pkcs11.Mechanism;
import iaik.pkcs.pkcs11.MechanismInfo;
import iaik.pkcs.pkcs11.Session;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.PrivateKey;
import iaik.pkcs.pkcs11.objects.PublicKey;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11;
import iaik.pkcs.pkcs11.provider.IAIKPkcs11Exception;
import iaik.pkcs.pkcs11.provider.PKCS11EngineClass;
import iaik.pkcs.pkcs11.provider.TokenManager;
import iaik.pkcs.pkcs11.provider.keypairgenerators.PKCS11KeyPairGenerationSpec;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PrivateKey;
import iaik.pkcs.pkcs11.provider.keys.IAIKPKCS11PublicKey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public abstract class PKCS11KeyPairGenerator
extends KeyPairGeneratorSpi
implements PKCS11EngineClass {
    protected TokenManager a;
    protected Session b;
    protected PKCS11KeyPairGenerationSpec c;
    protected boolean d;
    protected boolean e;
    protected Mechanism[] f;
    protected MechanismInfo[][] g;

    protected PKCS11KeyPairGenerator() {
    }

    protected Mechanism[] c() {
        if (this.f == null) {
            Mechanism mechanism = (Mechanism)this.a().clone();
            mechanism.setParameters(null);
            this.f = new Mechanism[]{mechanism};
        }
        return this.f;
    }

    protected MechanismInfo[][] d() {
        if (this.g == null) {
            MechanismInfo mechanismInfo = new MechanismInfo();
            mechanismInfo.setGenerateKeyPair(true);
            this.g = new MechanismInfo[][]{{mechanismInfo}};
        }
        return this.g;
    }

    public boolean isSupportedBy(TokenManager tokenManager) {
        boolean bl;
        try {
            Mechanism[] mechanismArray = this.c();
            MechanismInfo[][] mechanismInfoArray = this.d();
            bl = tokenManager.isMechanismFeatureSupported(mechanismArray, mechanismInfoArray);
        }
        catch (TokenException tokenException) {
            bl = false;
        }
        return bl;
    }

    public void initialize(int n, SecureRandom secureRandom) {
        iaik.pkcs.pkcs11.objects.KeyPair keyPair = IAIKPkcs11.getGlobalKeyHandler().getKeyPairGeneratorTemplate(this.b(), n);
        PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec = this.a(keyPair);
        try {
            this.initialize(pKCS11KeyPairGenerationSpec, null);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidParameterException(invalidAlgorithmParameterException.toString());
        }
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec == null || !(algorithmParameterSpec instanceof PKCS11KeyPairGenerationSpec)) {
            iaik.pkcs.pkcs11.objects.KeyPair keyPair = IAIKPkcs11.getGlobalKeyHandler().getKeyPairGeneratorTemplate(this.b(), algorithmParameterSpec);
            this.c = this.a(keyPair);
        } else {
            this.c = (PKCS11KeyPairGenerationSpec)algorithmParameterSpec;
            this.a(this.c.getAlgorithmParameterSpec());
        }
        this.a = this.c.getTokenManager();
        this.f();
        this.d = true;
    }

    public KeyPair generateKeyPair() {
        if (!this.d) {
            this.initialize(-1, null);
        }
        Mechanism mechanism = this.a();
        iaik.pkcs.pkcs11.objects.Object object = this.a(this.c);
        iaik.pkcs.pkcs11.objects.Object object2 = this.b(this.c);
        iaik.pkcs.pkcs11.objects.KeyPair keyPair = null;
        if (!this.e) {
            this.f();
        }
        try {
            keyPair = this.b.generateKeyPair(mechanism, object2, object);
        }
        catch (TokenException tokenException) {
            this.g();
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
        PrivateKey privateKey = keyPair.getPrivateKey();
        PublicKey publicKey = keyPair.getPublicKey();
        IAIKPKCS11PrivateKey iAIKPKCS11PrivateKey = this.a(this.a, privateKey);
        if (!privateKey.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11PrivateKey.setSession(this.b);
        }
        IAIKPKCS11PublicKey iAIKPKCS11PublicKey = this.a(this.a, publicKey);
        if (!publicKey.getToken().getBooleanValue().booleanValue()) {
            iAIKPKCS11PublicKey.setSession(this.b);
        }
        this.g();
        this.a.notifyKeyStores();
        return new KeyPair(iAIKPKCS11PublicKey, iAIKPKCS11PrivateKey);
    }

    protected iaik.pkcs.pkcs11.objects.Object a(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        return pKCS11KeyPairGenerationSpec.getPrivateKeyTemplate();
    }

    protected iaik.pkcs.pkcs11.objects.Object b(PKCS11KeyPairGenerationSpec pKCS11KeyPairGenerationSpec) {
        return pKCS11KeyPairGenerationSpec.getPublicKeyTemplate();
    }

    protected IAIKPKCS11PrivateKey a(TokenManager tokenManager, PrivateKey privateKey) {
        return IAIKPKCS11PrivateKey.create(tokenManager, privateKey);
    }

    protected IAIKPKCS11PublicKey a(TokenManager tokenManager, PublicKey publicKey) {
        return IAIKPKCS11PublicKey.create(tokenManager, publicKey);
    }

    protected void e() {
        try {
            if (this.b == null) {
                this.b = this.a.getSession(this.c.isUseRwSession());
            }
            if (!this.c.isUseAnonymousRole()) {
                this.a.login(this.b, this.c.isUseSORole(), this.c.getPin());
            } else {
                this.a.makeAuthorizedSession(this.b, null);
            }
        }
        catch (TokenException tokenException) {
            throw new IAIKPkcs11Exception(tokenException.toString());
        }
    }

    protected void f() {
        this.e();
        this.e = true;
    }

    protected void g() {
        this.e = false;
        this.a.disposeSession(this.b);
        this.b = null;
    }

    protected abstract Mechanism a();

    protected abstract String b();

    PKCS11KeyPairGenerationSpec a(iaik.pkcs.pkcs11.objects.KeyPair keyPair) {
        IAIKPkcs11 iAIKPkcs11 = IAIKPkcs11.getCurrentProviderInstance();
        if (iAIKPkcs11 == null) {
            throw new IAIKPkcs11Exception("No IAIKPkcs11 provider available.");
        }
        return (PKCS11KeyPairGenerationSpec)new PKCS11KeyPairGenerationSpec(keyPair.getPublicKey(), keyPair.getPrivateKey()).setUseUserRole(true);
    }

    protected void a(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("This key-pair generator does not accept parameters.");
        }
    }

    protected void finalize() {
        if (this.b != null) {
            this.a.disposeSession(this.b);
        }
        super.finalize();
    }
}

