/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.asn1.EncodedASN1Object;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CON_SPEC
extends ConstructedType {
    byte[] a = null;
    boolean b = false;

    protected CON_SPEC() {
        this.asnType = (ASN)ASN.CON_SPEC.clone();
    }

    public CON_SPEC(int n2, ASN1Object aSN1Object) {
        this(n2, aSN1Object, false);
    }

    public CON_SPEC(int n2, ASN1Object aSN1Object, boolean bl) {
        this();
        this.addComponent(aSN1Object);
        this.asnType.tag = n2;
        this.b = bl;
        if (aSN1Object instanceof EncodedASN1Object && this.b) {
            try {
                ((EncodedASN1Object)aSN1Object).a();
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Error adding EncodedASN1Object: " + iOException.getMessage());
            }
        }
        this.constructed = !this.b ? true : aSN1Object.constructed;
        this.indefinite_length = aSN1Object.indefinite_length;
    }

    public Object clone() {
        CON_SPEC cON_SPEC = (CON_SPEC)super.clone();
        if (this.a != null) {
            cON_SPEC.a = (byte[])this.a.clone();
        }
        return cON_SPEC;
    }

    public Object getValue() {
        if (this.content_count == 1) {
            return this.content_data[0];
        }
        if (this.content_count == 0) {
            return this.a;
        }
        return this.content_data;
    }

    public boolean isImplicitlyTagged() {
        return this.b;
    }

    public void forceImplicitlyTagged(ASN aSN) throws CodingException {
        try {
            if (this.b && this.a == null) {
                return;
            }
            ASN1Object aSN1Object = ASN.create(aSN);
            if (this.b) {
                aSN1Object.decode(this.a.length, new ByteArrayInputStream(this.a));
                this.addComponent(aSN1Object);
                this.constructed = aSN1Object.constructed;
                this.a = null;
                return;
            }
            if (!(aSN1Object instanceof ConstructedType) && this.content_data != null && this.content_count == 1) {
                if (!this.content_data[0].isA(aSN)) {
                    throw new CodingException("Invalid implicit tagging!");
                }
                this.constructed = false;
                this.a = null;
                return;
            }
            ((ConstructedType)aSN1Object).content_data = this.content_data;
            ((ConstructedType)aSN1Object).content_count = this.content_count;
            aSN1Object.constructed = true;
            this.content_data = new ASN1Object[1];
            this.content_data[0] = aSN1Object;
            this.content_count = 1;
            this.constructed = true;
            this.b = true;
        }
        catch (Exception exception) {
            throw new CodingException("Error creating instance of type.");
        }
    }

    protected void encode(OutputStream outputStream) throws IOException {
        if (this.a != null) {
            if (this.constructed) {
                throw new InternalErrorException("Constructed and value != null!");
            }
            outputStream.write(this.a);
            return;
        }
        if (this.stream_mode) {
            for (int i2 = 0; i2 < this.content_count; ++i2) {
                DerCoder.encodeTo(this.content_data[i2], outputStream, this.b);
            }
        } else {
            for (int i3 = this.content_count - 1; i3 >= 0; --i3) {
                DerCoder.a(this.content_data[i3], outputStream, this.b);
            }
        }
    }

    protected void decode(int n2, InputStream inputStream) throws IOException, CodingException {
        if (this.constructed) {
            super.decode(n2, inputStream);
            return;
        }
        try {
            this.a = new byte[n2];
            Util.fillArray(this.a, inputStream);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Not enough memory for decoding ASN.1 CON_SPEC value!");
        }
        this.b = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("[" + this.asnType.tag + "] ");
        stringBuffer.append(this.b ? "IMPLICIT" : "EXPLICIT");
        return stringBuffer.toString();
    }
}

