/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.EncodeListener;
import iaik.asn1.b;
import iaik.asn1.d;
import iaik.utils.ArrayEnumeration;
import iaik.utils.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public abstract class ConstructedType
extends ASN1Object {
    protected ASN1Object[] content_data = new ASN1Object[5];
    protected int content_count;
    boolean c = true;

    public Object clone() {
        ConstructedType constructedType = (ConstructedType)super.clone();
        if (this.content_data != null) {
            int n2 = this.content_data.length;
            constructedType.content_data = new ASN1Object[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                constructedType.content_data[i2] = this.content_data[i2] != null ? (ASN1Object)this.content_data[i2].clone() : null;
            }
        }
        return constructedType;
    }

    public Object getValue() {
        return this.content_data;
    }

    public void setValue(Object object) {
        this.content_data = (ASN1Object[])object;
        this.content_count = this.content_data.length;
        this.constructed = true;
    }

    public void addComponent(ASN1Object aSN1Object) {
        this.addComponent(aSN1Object, this.content_count);
        this.constructed = true;
    }

    public synchronized void addComponent(ASN1Object aSN1Object, int n2) {
        if (this.content_count >= this.content_data.length) {
            ASN1Object[] aSN1ObjectArray = this.content_data;
            this.content_data = new ASN1Object[aSN1ObjectArray.length * 2];
            System.arraycopy(aSN1ObjectArray, 0, this.content_data, 0, aSN1ObjectArray.length);
        }
        if (n2 != this.content_count) {
            System.arraycopy(this.content_data, n2, this.content_data, n2 + 1, this.content_count - n2);
        }
        this.content_data[n2] = aSN1Object;
        ++this.content_count;
        this.constructed = true;
    }

    public synchronized void removeComponent(ASN1Object aSN1Object) {
        for (int i2 = 0; i2 < this.content_count; ++i2) {
            if (!aSN1Object.equals(this.content_data[i2])) continue;
            this.removeComponent(i2);
            return;
        }
    }

    public synchronized void removeComponent(int n2) {
        if (n2 >= this.content_count) {
            throw new ArrayIndexOutOfBoundsException("Index out of range: " + n2 + " >= " + this.content_count);
        }
        this.content_data[n2] = null;
        if (this.content_count - n2 - 1 > 0) {
            System.arraycopy(this.content_data, n2 + 1, this.content_data, n2, this.content_count - n2 - 1);
        }
        --this.content_count;
        this.content_data[this.content_count] = null;
    }

    public ASN1Object getComponentAt(int n2) {
        if (n2 >= this.content_count) {
            throw new ArrayIndexOutOfBoundsException("Index out of range: " + n2 + " >= " + this.content_count);
        }
        return this.content_data[n2];
    }

    public void setComponent(int n2, ASN1Object aSN1Object) {
        if (n2 >= this.content_count) {
            throw new ArrayIndexOutOfBoundsException("Index out of range: " + n2 + " >= " + this.content_count);
        }
        this.content_data[n2] = aSN1Object;
        this.constructed = true;
    }

    public int countComponents() {
        return this.content_count;
    }

    public synchronized Enumeration getComponents() {
        return new ArrayEnumeration(this.content_data, this.content_count);
    }

    protected void encode(OutputStream outputStream) throws IOException {
        if (this.stream_mode) {
            if (this.encode_listener == null) {
                for (int i2 = 0; i2 < this.content_count; ++i2) {
                    DerCoder.encodeTo(this.content_data[i2], outputStream, false);
                }
            } else {
                d d2 = null;
                for (int i3 = 0; i3 < this.content_count; ++i3) {
                    DerCoder.encodeTo(this.content_data[i3], outputStream, false);
                    try {
                        for (int i4 = 0; i4 < this.encode_listener.length; ++i4) {
                            d2 = this.encode_listener[i4];
                            if (d2.c() != i3) continue;
                            d2.a().encodeCalled(this, d2.b());
                        }
                        continue;
                    }
                    catch (CodingException codingException) {
                        throw new IOException("Error from EncodeListener: " + codingException.getMessage());
                    }
                }
            }
        } else {
            for (int i5 = this.content_count - 1; i5 >= 0; --i5) {
                DerCoder.a(this.content_data[i5], outputStream);
            }
        }
    }

    protected void decode(int n2, InputStream inputStream) throws CodingException, IOException {
        int[] nArray = new int[1];
        this.constructed = true;
        if (n2 < 0) {
            int n3;
            this.indefinite_length = true;
            while ((n3 = inputStream.read()) != 0) {
                if (n3 == -1) {
                    throw new CodingException("Unexpected EOF in indefinite encoding!");
                }
                ((b)inputStream).unread(n3);
                ASN1Object aSN1Object = DerCoder.a(inputStream, nArray, this.c);
                if (!this.c) continue;
                this.addComponent(aSN1Object);
            }
            if (inputStream.read() != 0) {
                throw new CodingException("DER decode: infinite length second byte not 0!");
            }
        } else {
            for (int i2 = 0; i2 < n2; i2 += nArray[0]) {
                ASN1Object aSN1Object = DerCoder.a(inputStream, nArray, this.c);
                if (!this.c) continue;
                this.addComponent(aSN1Object);
            }
        }
    }

    public void addEncodeListener(EncodeListener encodeListener, int n2, int n3) {
        d d2 = new d(encodeListener, n2, n3);
        if (this.encode_listener == null) {
            this.encode_listener = new d[]{d2};
            return;
        }
        this.encode_listener = (d[])Util.resizeArray(this.encode_listener, this.encode_listener.length + 1);
        this.encode_listener[this.encode_listener.length - 1] = d2;
    }
}

