/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ConstructedType;
import iaik.asn1.DerCoder;
import iaik.utils.ExtByteArrayOutputStream;
import iaik.utils.InternalErrorException;
import iaik.utils.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;

public class OCTET_STRING
extends ConstructedType {
    byte[] a;
    InputStream b;
    int d = -1;

    private static final int a(InputStream inputStream, byte[] byArray) throws IOException {
        int n2;
        int n3 = 0;
        int n4 = byArray.length;
        for (n2 = 0; n2 < n4 && (n3 = inputStream.read(byArray, n2, n4 - n2)) >= 0; n2 += n3) {
        }
        if (n2 == 0) {
            n2 = n3;
        }
        return n2;
    }

    public OCTET_STRING() {
        this.asnType = ASN.OCTET_STRING;
    }

    public OCTET_STRING(byte[] byArray) {
        this();
        this.a = byArray;
        this.constructed = false;
    }

    public OCTET_STRING(byte[] byArray, int n2) {
        this();
        this.a = byArray;
        if (n2 > 0) {
            this.d = n2;
            this.indefinite_length = true;
            this.constructed = true;
        }
    }

    public OCTET_STRING(InputStream inputStream) {
        this();
        this.b = inputStream;
        this.constructed = false;
    }

    public OCTET_STRING(InputStream inputStream, int n2) {
        this();
        this.b = inputStream;
        if (n2 > 0) {
            this.d = n2;
            this.indefinite_length = true;
            this.constructed = true;
        }
    }

    public Object clone() {
        OCTET_STRING oCTET_STRING = (OCTET_STRING)super.clone();
        if (this.a != null) {
            oCTET_STRING.a = (byte[])this.a.clone();
        } else if (this.b != null) {
            try {
                byte[] byArray = Util.readStream(this.b);
                oCTET_STRING.a = byArray;
                this.a = byArray;
                this.b = null;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Error reading input stream for cloning: " + iOException);
            }
        }
        return oCTET_STRING;
    }

    public Object getValue() {
        try {
            return this.getWholeValue();
        }
        catch (Exception exception) {
            throw new InternalErrorException("Error reading octet string value: " + exception.toString(), exception);
        }
    }

    public byte[] getWholeValue() throws IOException {
        byte[] byArray = this.a;
        if (byArray == null && (this.b != null || this.content_count > 0)) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.a(byteArrayOutputStream, this);
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (byArray == null) {
            byArray = new byte[]{};
        }
        return byArray;
    }

    public void writeWholeValueToStream(OutputStream outputStream) throws IOException {
        if (this.a != null) {
            outputStream.write(this.a);
        } else {
            this.a(outputStream, this);
        }
    }

    public void encodeAsIndefiniteConstructedOctetString(OutputStream outputStream, int n2) throws IOException {
        if (n2 <= 0) {
            n2 = this.d;
        }
        if (n2 <= 0) {
            n2 = 1024;
        }
        outputStream.write(36);
        outputStream.write(128);
        byte[] byArray = new byte[n2];
        ExtByteArrayOutputStream extByteArrayOutputStream = new ExtByteArrayOutputStream(n2);
        this.a(outputStream, this, extByteArrayOutputStream, n2, byArray);
        int n3 = extByteArrayOutputStream.size();
        if (n3 > 0) {
            outputStream.write(4);
            DerCoder.a(null, n3, outputStream);
            outputStream.write(extByteArrayOutputStream.getInternalByteArray(), 0, extByteArrayOutputStream.size());
        }
        outputStream.write(0);
        outputStream.write(0);
    }

    private void a(OutputStream outputStream, OCTET_STRING oCTET_STRING) throws IOException {
        if (!oCTET_STRING.isConstructed()) {
            byte[] byArray = oCTET_STRING.a;
            if (byArray != null) {
                outputStream.write(byArray);
            } else {
                InputStream inputStream = oCTET_STRING.b;
                this.a(inputStream, outputStream);
            }
        } else {
            InputStream inputStream = oCTET_STRING.b;
            if (inputStream != null) {
                this.a(inputStream, outputStream);
            } else {
                Enumeration enumeration = oCTET_STRING.getComponents();
                while (enumeration.hasMoreElements()) {
                    this.a(outputStream, (OCTET_STRING)enumeration.nextElement());
                }
            }
        }
    }

    public void setValue(Object object) {
        this.a = null;
        this.b = null;
        this.content_data = null;
        this.content_count = 0;
        if (object instanceof byte[]) {
            this.a = (byte[])object;
            this.indefinite_length = false;
            this.constructed = false;
            this.d = -1;
        } else if (object instanceof InputStream) {
            this.b = (InputStream)object;
            if (this.d == -1) {
                this.indefinite_length = false;
                this.constructed = false;
            }
        }
    }

    public void setIndefiniteLength(boolean bl) {
        this.indefinite_length = bl;
        if (this.d > 0) {
            this.indefinite_length = true;
        }
        if (!(this.isConstructed() || this.a == null && this.b == null)) {
            this.indefinite_length = false;
        }
    }

    public synchronized void addComponent(ASN1Object aSN1Object, int n2) {
        if (!(aSN1Object instanceof OCTET_STRING)) {
            throw new IllegalArgumentException("Only instances of OCTET_STRING are allowed to be added to an OCTET_STRING object!");
        }
        if (this.a != null || this.b != null) {
            throw new IllegalArgumentException("Cannot add component to a simple OCTET_STRING object!");
        }
        super.addComponent(aSN1Object, n2);
    }

    protected void encode(OutputStream outputStream) throws IOException {
        if (this.a != null) {
            if (this.d <= 0) {
                outputStream.write(this.a);
                return;
            }
            if (this.b == null) {
                this.b = new ByteArrayInputStream(this.a);
            } else {
                ((ByteArrayInputStream)this.b).reset();
            }
            if (!this.stream_mode) {
                int n2;
                byte[] byArray = new byte[this.d];
                ExtByteArrayOutputStream extByteArrayOutputStream = new ExtByteArrayOutputStream();
                while ((n2 = OCTET_STRING.a(this.b, byArray)) >= 0) {
                    if (n2 <= 0) continue;
                    extByteArrayOutputStream.write(4);
                    DerCoder.a(null, n2, extByteArrayOutputStream);
                    extByteArrayOutputStream.write(byArray, 0, n2);
                }
                outputStream.write(extByteArrayOutputStream.getInternalByteArray(), 0, extByteArrayOutputStream.size());
                return;
            }
        }
        if (this.constructed && this.b == null) {
            super.encode(outputStream);
            return;
        }
        if (this.b == null) {
            return;
        }
        if (this.constructed) {
            if (this.stream_mode && this.d > 0) {
                int n3;
                byte[] byArray = new byte[this.d];
                while ((n3 = OCTET_STRING.a(this.b, byArray)) >= 0) {
                    if (n3 <= 0) continue;
                    outputStream.write(4);
                    DerCoder.a(null, n3, outputStream);
                    outputStream.write(byArray, 0, n3);
                }
            } else {
                byte[] byArray = Util.readStream(this.b);
                outputStream.write(byArray);
                DerCoder.a(null, byArray.length, outputStream);
                outputStream.write(4);
            }
        } else if (this.stream_mode) {
            Util.copyStream(this.b, outputStream, null);
        } else {
            byte[] byArray = Util.readStream(this.b);
            outputStream.write(byArray);
        }
    }

    protected void decode(int n2, InputStream inputStream) throws IOException, CodingException {
        try {
            if (this.constructed) {
                super.decode(n2, inputStream);
                return;
            }
            if (n2 < 0) {
                throw new IOException("DER decode ERROR: indefinite length encoding not allowed for primitive octet strings!");
            }
            this.a = new byte[n2];
            Util.fillArray(this.a, inputStream);
            this.constructed = false;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Not enough memory for decoding ASN.1 OCTET STRING value!");
        }
    }

    public OCTET_STRING getSimpleOctetString() throws IOException {
        OCTET_STRING oCTET_STRING = this.b != null && this.countComponents() == 0 ? new OCTET_STRING(this.b) : new OCTET_STRING(this.getWholeValue());
        return oCTET_STRING;
    }

    public int getBlockSize() {
        return this.d;
    }

    private void a(OutputStream outputStream, OCTET_STRING oCTET_STRING, ExtByteArrayOutputStream extByteArrayOutputStream, int n2, byte[] byArray) throws IOException {
        if (!oCTET_STRING.isConstructed()) {
            byte[] byArray2 = oCTET_STRING.a;
            if (byArray2 != null) {
                this.a(new ByteArrayInputStream(byArray2), outputStream, extByteArrayOutputStream, n2, byArray);
            } else {
                InputStream inputStream = oCTET_STRING.b;
                this.a(inputStream, outputStream, extByteArrayOutputStream, n2, byArray);
            }
        } else {
            InputStream inputStream = oCTET_STRING.b;
            if (inputStream != null) {
                this.a(inputStream, outputStream, extByteArrayOutputStream, n2, byArray);
            } else {
                Enumeration enumeration = oCTET_STRING.getComponents();
                while (enumeration.hasMoreElements()) {
                    this.a(outputStream, (OCTET_STRING)enumeration.nextElement(), extByteArrayOutputStream, n2, byArray);
                }
            }
        }
    }

    private void a(InputStream inputStream, OutputStream outputStream, ExtByteArrayOutputStream extByteArrayOutputStream, int n2, byte[] byArray) throws IOException {
        int n3 = -1;
        int n4 = extByteArrayOutputStream.size();
        if (n4 > 0 && (n3 = inputStream.read(byArray, 0, n2 - n4)) != -1) {
            int n5 = n3 + n4;
            if (n5 < n2) {
                extByteArrayOutputStream.write(byArray, 0, n3);
                return;
            }
            outputStream.write(4);
            DerCoder.a(null, n2, outputStream);
            outputStream.write(extByteArrayOutputStream.getInternalByteArray(), 0, n4);
            outputStream.write(byArray, 0, n3);
            extByteArrayOutputStream.reset();
        }
        while ((n3 = inputStream.read(byArray)) != -1) {
            if (n3 < n2) {
                extByteArrayOutputStream.write(byArray, 0, n3);
                continue;
            }
            outputStream.write(4);
            DerCoder.a(null, n3, outputStream);
            outputStream.write(byArray, 0, n3);
        }
    }

    private void a(InputStream inputStream, OutputStream outputStream) throws IOException {
        Util.copyStream(inputStream, outputStream, null);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        if (this.constructed) {
            if (this.content_count > 0) {
                stringBuffer.append(this.content_count + " elements");
            } else {
                stringBuffer.append("block size: " + this.d + " source: " + this.b);
            }
        } else if (this.a != null) {
            stringBuffer.append(this.a.length + " bytes: " + Util.toString(this.a, 0, 5));
            if (this.a.length > 5) {
                stringBuffer.append("...");
            }
        } else {
            stringBuffer.append(this.b);
        }
        return stringBuffer.toString();
    }

    public String toString(boolean bl) {
        return this.a(true, "");
    }

    private String a(boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + super.toString());
        if (this.constructed) {
            if (this.content_count > 0) {
                string = string + "  ";
                stringBuffer.append(this.content_count + " elements\n");
                for (int i2 = 0; i2 < this.content_count; ++i2) {
                    OCTET_STRING oCTET_STRING = (OCTET_STRING)this.content_data[i2];
                    stringBuffer.append(oCTET_STRING.a(true, string));
                }
            } else {
                stringBuffer.append("block size: " + this.d + " source: " + this.b + "\n");
            }
        } else if (this.a != null) {
            if (bl) {
                stringBuffer.append(this.a.length + " bytes: " + Util.toString(this.a, 0, this.a.length) + "\n");
            } else {
                stringBuffer.append(this.a.length + " bytes: " + Util.toString(this.a, 0, 5));
                if (this.a.length > 5) {
                    stringBuffer.append("...\n");
                } else {
                    stringBuffer.append("\n");
                }
            }
        } else {
            stringBuffer.append(this.b + "\n");
        }
        return stringBuffer.toString();
    }
}

