/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1String;
import iaik.asn1.ASN1Type;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.utils.CryptoUtils;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import java.util.HashMap;

public class AVA
implements ASN1Type {
    static HashMap a = new HashMap();
    static ASN b = ASN.PrintableString;
    static ASN c = ASN.UTF8String;
    private ObjectID d;
    private ASN1Object e;

    public static void defineEncoding(ObjectID objectID, ASN aSN) {
        a.put(objectID, aSN);
    }

    public static ASN getEncoding(ObjectID objectID) {
        return (ASN)a.get(objectID);
    }

    public static void setDefaultEncoding(ASN aSN) {
        b = aSN;
    }

    public static void setNonPrintableDefaultEncoding(ASN aSN) {
        c = aSN;
    }

    public static ASN getDefaultEncoding() {
        return b;
    }

    public static ASN getNonPrintableDefaultEncoding() {
        return c;
    }

    public AVA(ObjectID objectID, Object object) throws IllegalArgumentException {
        this(objectID, object, null);
    }

    public AVA(ObjectID objectID, Object object, ASN aSN) throws IllegalArgumentException {
        if (objectID == null || object == null) {
            throw new IllegalArgumentException("Type and value must be non null for creating an AVA!");
        }
        this.d = objectID;
        if (object instanceof ASN1Object) {
            this.e = (ASN1Object)object;
        } else {
            try {
                this.e = AVA.a(object, objectID, aSN);
            }
            catch (CodingException codingException) {
                throw new IllegalArgumentException("Cannot create ASN.1 representation of given object for requested type!");
            }
        }
    }

    public AVA(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object == null) {
            throw new CodingException("Cannot create an AVA from a null object!");
        }
        this.decode(aSN1Object);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.d = (ObjectID)aSN1Object.getComponentAt(0);
        this.e = aSN1Object.getComponentAt(1);
    }

    private static Object a(ASN1Object aSN1Object, ObjectID objectID) {
        Object object = null;
        if (objectID.equals(ObjectID.uniqueIdentifier) && !aSN1Object.isA(ASN.PrintableString)) {
            try {
                ASN1Object aSN1Object2 = DerCoder.decode((byte[])aSN1Object.getValue());
                object = aSN1Object2.getValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (object == null) {
            object = aSN1Object.getValue();
        }
        return object;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.d);
        sEQUENCE.addComponent(this.e);
        return sEQUENCE;
    }

    private static ASN1Object a(Object object, ObjectID objectID, ASN aSN) throws CodingException {
        try {
            ASN aSN2 = AVA.getEncoding(objectID);
            if (aSN != null) {
                aSN2 = aSN;
            }
            if (aSN2 == null) {
                aSN2 = b;
                if (object instanceof String && (b == ASN.NumericString || b == ASN.PrintableString) && !PrintableString.isPrintableString((String)object)) {
                    aSN2 = c;
                }
            }
            if (objectID == ObjectID.uniqueIdentifier && object instanceof String && aSN2.equals(ASN.BIT_STRING)) {
                PrintableString printableString = new PrintableString((String)object);
                BIT_STRING bIT_STRING = new BIT_STRING(DerCoder.encode(printableString));
                return bIT_STRING;
            }
            return ASN.create(aSN2, object);
        }
        catch (Exception exception) {
            throw new CodingException(exception.getMessage());
        }
    }

    public ObjectID getType() {
        return this.d;
    }

    public Object getValue() {
        return AVA.a(this.e, this.d);
    }

    public String getValueAsString() {
        Object object = AVA.a(this.e, this.d);
        if (!(object instanceof String)) {
            object = AVA.a(this.e, true, ":");
        }
        return (String)object;
    }

    public ASN1Object getASN1Value() throws CodingException {
        return this.e;
    }

    public int hashCode() {
        return this.d.hashCode() + AVA.a(this.e, this.d).hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AVA)) {
            return false;
        }
        AVA aVA = (AVA)object;
        if (!this.d.equals(aVA.d)) {
            return false;
        }
        if (this.e.isStringType()) {
            return ((ASN1String)this.e).equals(aVA.e);
        }
        return CryptoUtils.equalsBlock(DerCoder.encode(this.e), DerCoder.encode(aVA.e));
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        Object object = AVA.a(this.e, this.d);
        if (!(object instanceof String)) {
            try {
                object = AVA.a(this.e, true, ":");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        boolean bl2 = false;
        if (object instanceof String) {
            bl2 = ((String)object).indexOf(61) != -1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(bl ? this.d.getName() : this.d.getShortName());
        if (bl2) {
            stringBuffer.append("=\"");
            stringBuffer.append(object);
            stringBuffer.append("\"");
        } else {
            stringBuffer.append("=");
            stringBuffer.append(object);
        }
        return stringBuffer.toString();
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        return this.getRFC2253String(Util.getDefaultRFC2253StringEscaping());
    }

    public String getRFC2253String(boolean bl) throws RFC2253NameParserException {
        Object object = AVA.a(this.e, this.d);
        ASN aSN = this.e.getAsnType();
        boolean bl2 = aSN.equals(ASN.BIT_STRING);
        if (!(object instanceof String) || bl2 || !ObjectID.hasRegisteredName(this.d.getID())) {
            try {
                object = AVA.a(this.e, false, "");
            }
            catch (Exception exception) {
                throw new RFC2253NameParserException("Cannot write this AVA: " + exception.getMessage());
            }
        }
        try {
            object = UTF8String.getRFC2253String((String)object, bl);
        }
        catch (CodingException codingException) {
            throw new RFC2253NameParserException("Cannot write this AVA: " + codingException.getMessage());
        }
        return this.d.getShortName() + "=" + object;
    }

    private static String a(ASN1Object aSN1Object, boolean bl, String string) {
        String string2;
        if (aSN1Object.isA(ASN.BIT_STRING) && bl) {
            BIT_STRING bIT_STRING = (BIT_STRING)aSN1Object;
            string2 = "#'" + bIT_STRING.getBinaryString() + "'B";
        } else {
            byte[] byArray = DerCoder.encode(aSN1Object);
            String string3 = Util.toString(byArray, string);
            string2 = "#" + string3;
        }
        return string2;
    }

    static {
        AVA.defineEncoding(ObjectID.emailAddress, ASN.IA5String);
        AVA.defineEncoding(ObjectID.uniqueIdentifier, ASN.BIT_STRING);
    }
}

