/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.GeneralName;

public class AccessDescription
implements ASN1Type {
    private ObjectID a;
    private GeneralName b;

    public AccessDescription() {
    }

    public AccessDescription(ObjectID objectID, GeneralName generalName) throws IllegalArgumentException {
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot create AccessDescription! No accessMethod specified!");
        }
        if (generalName == null) {
            throw new IllegalArgumentException("Cannot create AccessDescription! No accessLocation specified!");
        }
        this.a = objectID;
        this.b = generalName;
    }

    public AccessDescription(ObjectID objectID, String string) throws IllegalArgumentException {
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot create AccessDescription! No accessMethod specified!");
        }
        if (string == null) {
            throw new IllegalArgumentException("Cannot create AccessDescription! No accessLocation uri specified!");
        }
        this.a = objectID;
        this.b = new GeneralName(6, string);
    }

    public AccessDescription(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        try {
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new CodingException("Cannot parse AccessDescription! Has to be a SEQUENCE!");
            }
            SEQUENCE sEQUENCE = (SEQUENCE)aSN1Object;
            if (sEQUENCE.countComponents() != 2) {
                throw new CodingException("Cannot parse AccessDescription! Wrong number of components!");
            }
            ASN1Object aSN1Object2 = sEQUENCE.getComponentAt(0);
            if (!aSN1Object2.isA(ASN.ObjectID)) {
                throw new CodingException("Cannot parse AccessDescription! First component has to be an ObjectID!");
            }
            this.a = (ObjectID)aSN1Object2;
            aSN1Object2 = sEQUENCE.getComponentAt(1);
            this.b = new GeneralName(aSN1Object2);
        }
        catch (Exception exception) {
            throw new CodingException(exception.toString());
        }
    }

    public ASN1Object toASN1Object() throws CodingException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a == null) {
            throw new CodingException("Cannot create ASN.1 object for this AccessDescription! accessMethod field not specified!");
        }
        if (this.b == null) {
            throw new CodingException("Cannot create ASN.1 object for this AccessDescription! accessLocation field not specified!");
        }
        sEQUENCE.addComponent(this.a);
        sEQUENCE.addComponent(this.b.toASN1Object());
        return sEQUENCE;
    }

    public ObjectID getAccessMethod() {
        return this.a;
    }

    public GeneralName getAccessLocation() {
        return this.b;
    }

    public void setAccessMethod(ObjectID objectID) throws IllegalArgumentException {
        if (objectID == null) {
            throw new IllegalArgumentException("Cannot set null accessMethod!");
        }
        this.a = objectID;
    }

    public void setAccessLocation(GeneralName generalName) throws IllegalArgumentException {
        if (generalName == null) {
            throw new IllegalArgumentException("Cannot set null access location!");
        }
        this.b = generalName;
    }

    public void setUriAccessLocation(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Cannot set null access location!");
        }
        this.b = new GeneralName(6, string);
    }

    public String getUriAccessLocation() {
        String string = null;
        if (this.b != null && this.b.getType() == 6) {
            string = (String)this.b.getName();
        }
        return string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("accessMethod: ");
        stringBuffer.append(this.a == null ? "null" : this.a.toString());
        stringBuffer.append("\naccessLocation: ");
        stringBuffer.append(this.b == null ? "null" : this.b.toString());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

