/*
 * Decompiled with CFR 0.152.
 */
package iaik.asn1.structures;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AVA;
import iaik.asn1.structures.RDN;
import iaik.utils.InternalErrorException;
import iaik.utils.RFC2253NameParser;
import iaik.utils.RFC2253NameParserException;
import iaik.utils.Util;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Vector;

public class Name
implements ASN1Type,
Principal {
    private Vector a = new Vector();

    public Name() {
    }

    public Name(byte[] byArray) throws CodingException {
        this(new ASN1(byArray).toASN1Object());
    }

    public Name(ASN1Object aSN1Object) throws CodingException {
        this();
        this.decode(aSN1Object);
    }

    public Name(String string) throws RFC2253NameParserException {
        this();
        RFC2253NameParser rFC2253NameParser = new RFC2253NameParser(string);
        Name name = rFC2253NameParser.parse();
        Enumeration enumeration = name.elements();
        while (enumeration.hasMoreElements()) {
            this.a.addElement(enumeration.nextElement());
        }
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        if (aSN1Object.isA(ASN.SET)) {
            RDN rDN = new RDN(aSN1Object);
            this.a.addElement(rDN);
        } else {
            for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                RDN rDN = new RDN(aSN1Object.getComponentAt(i2));
                this.a.addElement(rDN);
            }
        }
    }

    public String getRDN(ObjectID objectID) {
        String string = null;
        try {
            string = this.getRDN(objectID, false);
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            // empty catch block
        }
        return string;
    }

    public String getRDN(ObjectID objectID, boolean bl) throws RFC2253NameParserException {
        String string = null;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            RDN rDN = (RDN)enumeration.nextElement();
            AVA aVA = rDN.getAVA(objectID);
            if (aVA == null) continue;
            string = bl ? aVA.getRFC2253String() : (String)aVA.getValue();
            break;
        }
        return string;
    }

    public String[] getRDNs(ObjectID objectID) {
        String[] stringArray = null;
        try {
            stringArray = this.getRDNs(objectID, false);
        }
        catch (RFC2253NameParserException rFC2253NameParserException) {
            // empty catch block
        }
        return stringArray;
    }

    public String[] getRDNs(ObjectID objectID, boolean bl) throws RFC2253NameParserException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            AVA[] aVAArray = objectArray.getAVAs(objectID);
            if (aVAArray.length <= 0) continue;
            for (int i2 = 0; i2 < aVAArray.length; ++i2) {
                vector.addElement(bl ? aVAArray[i2].getRFC2253String() : (String)aVAArray[i2].getValue());
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Object getRDNValue(ObjectID objectID) {
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            RDN rDN = (RDN)enumeration.nextElement();
            AVA aVA = rDN.getAVA(objectID);
            if (aVA == null) continue;
            return aVA.getValue();
        }
        return null;
    }

    public Object[] getRDNValues(ObjectID objectID) {
        Object[] objectArray;
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            AVA[] aVAArray = objectArray.getAVAs(objectID);
            if (aVAArray.length <= 0) continue;
            for (int i2 = 0; i2 < aVAArray.length; ++i2) {
                vector.addElement(aVAArray[i2].getValue());
            }
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public RDN[] getRDNs() {
        Object[] objectArray = new RDN[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public Enumeration elements() {
        return this.a.elements();
    }

    public Enumeration elements(ObjectID objectID) {
        Vector<RDN> vector = new Vector<RDN>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            RDN rDN = (RDN)enumeration.nextElement();
            if (rDN.getAVA(objectID) == null) continue;
            vector.addElement(rDN);
        }
        return vector.elements();
    }

    public RDN element(ObjectID objectID) {
        RDN rDN = null;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            RDN rDN2 = (RDN)enumeration.nextElement();
            if (rDN2.getAVA(objectID) == null) continue;
            rDN = rDN2;
            break;
        }
        return rDN;
    }

    public boolean isEmpty() {
        return this.a.isEmpty();
    }

    public void addRDN(ObjectID objectID, Object object) {
        this.a.addElement(new RDN(objectID, object));
    }

    public void addRDN(RDN rDN) {
        this.a.addElement(rDN);
    }

    public void insertRDNAt(ObjectID objectID, Object object, int n2) {
        this.a.insertElementAt(new RDN(objectID, object), n2);
    }

    public void insertRDNAt(RDN rDN, int n2) {
        this.a.insertElementAt(rDN, n2);
    }

    public boolean removeRDN(ObjectID objectID) {
        boolean bl = false;
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            RDN rDN = (RDN)this.a.elementAt(i2);
            if (rDN.getAVA(objectID) == null) continue;
            this.a.removeElementAt(i2--);
            bl = true;
        }
        return bl;
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        for (int i2 = 0; i2 < this.a.size(); ++i2) {
            sEQUENCE.addComponent(((RDN)this.a.elementAt(i2)).toASN1Object());
        }
        return sEQUENCE;
    }

    public byte[] getEncoded() {
        try {
            return new ASN1(this.toASN1Object()).toByteArray();
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception.toString());
        }
    }

    public int hashCode() {
        int n2;
        int n3 = n2 = this.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            RDN rDN = (RDN)this.a.elementAt(i2);
            n3 = n3 << 7 | n3 >>> 25;
            n3 += rDN.hashCode();
        }
        return n3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Name)) {
            return false;
        }
        Name name = (Name)object;
        int n2 = this.a.size();
        if (n2 != name.a.size()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            RDN rDN;
            RDN rDN2 = (RDN)this.a.elementAt(i2);
            if (rDN2.equals(rDN = (RDN)name.a.elementAt(i2))) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        String string = null;
        try {
            string = this.getRFC2253String(false);
        }
        catch (Exception exception) {
            string = this.toString();
        }
        return string;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            RDN rDN = (RDN)this.a.elementAt(i2);
            stringBuffer.append(rDN.toString(bl));
            if (i2 > 0) {
                stringBuffer.append(",");
            }
            if (!bl) continue;
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public String getRFC2253String() throws RFC2253NameParserException {
        return this.getRFC2253String(Util.getDefaultRFC2253StringEscaping());
    }

    public String getRFC2253String(boolean bl) throws RFC2253NameParserException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = this.a.size() - 1; i2 >= 0; --i2) {
            RDN rDN = (RDN)this.a.elementAt(i2);
            stringBuffer.append(rDN.getRFC2253String(bl));
            if (i2 <= 0) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }
}

