/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs12;

import iaik.asn1.ASN1Object;
import iaik.asn1.BMPString;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.structures.Attribute;
import iaik.utils.Util;
import java.util.Vector;

public class Attributes {
    String a;
    byte[] b;

    public Attributes() {
    }

    public Attributes(String string, byte[] byArray) {
        this.a = string;
        this.b = byArray;
    }

    public void setFriendlyName(String string) {
        this.a = string;
    }

    public void setLocalKeyID(byte[] byArray) {
        this.b = byArray;
    }

    public String getFriendlyName() {
        return this.a;
    }

    public byte[] getLocalKeyID() {
        return this.b;
    }

    protected void setAttributes(Attribute[] attributeArray) {
        if (attributeArray != null) {
            for (int i2 = 0; i2 < attributeArray.length; ++i2) {
                if (attributeArray[i2].getType().equals(ObjectID.friendlyName)) {
                    this.a = (String)attributeArray[i2].getValue()[0].getValue();
                    continue;
                }
                if (!attributeArray[i2].getType().equals(ObjectID.localKeyID)) continue;
                this.b = (byte[])attributeArray[i2].getValue()[0].getValue();
            }
        }
    }

    public Attribute[] getAttributes() {
        Object[] objectArray;
        Vector<Attribute> vector = new Vector<Attribute>();
        if (this.a != null) {
            objectArray = new ASN1Object[]{new BMPString(this.a)};
            vector.addElement(new Attribute(ObjectID.friendlyName, (ASN1Object[])objectArray));
        }
        if (this.b != null) {
            objectArray = new ASN1Object[]{new OCTET_STRING(this.b)};
            vector.addElement(new Attribute(ObjectID.localKeyID, (ASN1Object[])objectArray));
        }
        if (vector.size() == 0) {
            return null;
        }
        objectArray = new Attribute[vector.size()];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = (Attribute)vector.elementAt(i2);
        }
        return objectArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a != null) {
            stringBuffer.append("Friendly name: " + this.a + "\n");
        }
        if (this.b != null) {
            stringBuffer.append("local key ID: " + Util.toString(this.b) + "\n");
        }
        return stringBuffer.toString();
    }
}

