/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs5;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs5.PBES2ParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2ParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2Parameters;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class PBES2Parameters
extends AlgorithmParametersSpi {
    private PBES2ParameterSpec b;
    static Class a;

    protected byte[] engineGetEncoded() throws IOException {
        if (this.b == null) {
            throw new IllegalStateException("PBES2Parameters not initialized yet!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.pbkdf2.clone();
        ASN1Object aSN1Object = PBKDF2Parameters.a(this.b.getSalt(), this.b.getIterationCount(), this.b.getDerivedKeyLength(), this.b.getPrf());
        algorithmID.setParameter(aSN1Object);
        sEQUENCE.addComponent(algorithmID.toASN1Object());
        sEQUENCE.addComponent(this.b.getEncryptionScheme().toASN1Object());
        return DerCoder.encode(sEQUENCE);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        return this.engineGetEncoded();
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (this.b == null) {
            throw new IllegalStateException("PBKDF2Parameters not initialized yet!");
        }
        if (!(a == null ? (a = PBES2Parameters.class$("iaik.pkcs.pkcs5.PBES2ParameterSpec")) : a).isAssignableFrom(clazz)) {
            throw new InvalidParameterSpecException("Can not convert to class " + clazz.getName());
        }
        return this.b;
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof PBES2ParameterSpec)) {
            throw new InvalidParameterSpecException("paramSpec must be PBKDF2ParameterSpec.");
        }
        this.b = (PBES2ParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray) throws IOException {
        try {
            ASN1Object aSN1Object = DerCoder.decode(byArray);
            if (!aSN1Object.isA(ASN.SEQUENCE)) {
                throw new CodingException("PBKDF2 parameters must be ASN.1 SEQUENCE!");
            }
            int n2 = aSN1Object.countComponents();
            if (n2 != 2) {
                throw new CodingException("Invalid number of PBES2 parameter components (" + n2 + "). Must be 2!");
            }
            AlgorithmID algorithmID = new AlgorithmID(aSN1Object.getComponentAt(0));
            if (!AlgorithmID.pbkdf2.equals(algorithmID)) {
                throw new IOException("Unsupported KDF (" + algorithmID.getAlgorithm() + "). Only PBKDF2 supported!");
            }
            PBKDF2ParameterSpec pBKDF2ParameterSpec = PBKDF2Parameters.a(algorithmID.getParameter());
            AlgorithmID algorithmID2 = new AlgorithmID(aSN1Object.getComponentAt(1));
            this.b = new PBES2ParameterSpec(pBKDF2ParameterSpec.getSalt(), pBKDF2ParameterSpec.getIterationCount(), pBKDF2ParameterSpec.getDerivedKeyLength(), algorithmID2);
            this.b.setPrf(pBKDF2ParameterSpec.getPrf());
        }
        catch (CodingException codingException) {
            throw new IOException("Error decoding PBES2 parameters: " + codingException.toString());
        }
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        this.engineInit(byArray);
    }

    protected String engineToString() {
        return this.b == null ? "" : this.b.toString();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

