/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.Name;
import java.math.BigInteger;
import java.security.ProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;

public class IssuerAndSerialNumber {
    private Name a = null;
    private BigInteger b = null;

    public IssuerAndSerialNumber(Name name, BigInteger bigInteger) {
        this.a = name;
        this.b = bigInteger;
    }

    public IssuerAndSerialNumber(X509Certificate x509Certificate) {
        if (x509Certificate instanceof iaik.x509.X509Certificate) {
            this.a = (Name)x509Certificate.getIssuerDN();
        } else {
            try {
                this.a = (Name)new iaik.x509.X509Certificate(x509Certificate.getEncoded()).getIssuerDN();
            }
            catch (CertificateException certificateException) {
                throw new ProviderException("Invalid encoded certificate. Could not decode issuer DN: " + certificateException);
            }
        }
        this.b = x509Certificate.getSerialNumber();
    }

    public IssuerAndSerialNumber(ASN1Object aSN1Object) throws CodingException {
        this.a = new Name(aSN1Object.getComponentAt(0));
        this.b = (BigInteger)aSN1Object.getComponentAt(1).getValue();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(this.a.toASN1Object());
        sEQUENCE.addComponent(new INTEGER(this.b));
        return sEQUENCE;
    }

    public Name getIssuer() {
        return this.a;
    }

    public BigInteger getSerialNumber() {
        return this.b;
    }

    public boolean equals(Object object) {
        return object instanceof IssuerAndSerialNumber && this.a.equals(((IssuerAndSerialNumber)object).a) && this.b.compareTo(((IssuerAndSerialNumber)object).b) == 0;
    }

    public int hashCode() {
        return this.a.hashCode() + this.b.hashCode();
    }

    public boolean isIssuerOf(X509Certificate x509Certificate) {
        return this.a.equals(x509Certificate.getIssuerDN()) && this.b.compareTo(x509Certificate.getSerialNumber()) == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SerialNumber: " + this.b + "\n");
        stringBuffer.append("Issuer: " + this.a + "\n");
        return stringBuffer.toString();
    }
}

