/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.security.random.SecRandom;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class CCMCMSParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a;
    private byte[] b;
    private byte[] c;
    private int d;
    private long e;

    private CCMCMSParameterSpec(long l2, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2) throws InvalidAlgorithmParameterException {
        this.a = byArray;
        this.b = byArray2;
        this.c = byArray3;
        this.d = n2;
        this.e = l2;
        if (this.b == null || this.b.length == 0) {
            this.b = this.e > -1L ? (this.e < Integer.MAX_VALUE ? new byte[11] : new byte[7]) : new byte[7];
            SecureRandom secureRandom = SecRandom.getDefault();
            secureRandom.nextBytes(this.b);
        } else if (this.b.length < 7 || this.b.length > 13) {
            throw new InvalidAlgorithmParameterException("nonce length not between 7 and 13 bytes!");
        }
        if (this.e != -1L) {
            if (this.e < -1L) {
                throw new InvalidAlgorithmParameterException("invalid value for inputLength");
            }
            long l3 = (long)(Math.pow(2.0, 8 * (15 - this.b.length)) - 1.0);
            if (this.e - (long)this.d > l3) {
                throw new InvalidAlgorithmParameterException("parameter inputLength or nonce too long");
            }
        }
        if ((this.c == null || this.c.length == 0) && this.d == -1) {
            this.d = 12;
        } else {
            if (this.d == -1) {
                this.d = this.c.length;
            }
            if (this.d < 4 || this.d > 16) {
                throw new InvalidAlgorithmParameterException("Specified MAC-length not between 4 and 16 bytes!");
            }
        }
    }

    public CCMCMSParameterSpec(long l2, byte[] byArray, byte[] byArray2, int n2) throws Exception {
        this(l2, byArray, byArray2, null, n2);
    }

    public CCMCMSParameterSpec(long l2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        this(l2, byArray, byArray2, byArray3, -1);
    }

    public CCMCMSParameterSpec(byte[] byArray, byte[] byArray2, int n2) throws Exception {
        this(-1L, byArray, byArray2, null, n2);
    }

    public CCMCMSParameterSpec(byte[] byArray, byte[] byArray2, byte[] byArray3) throws Exception {
        this(-1L, byArray, byArray2, byArray3, -1);
    }

    public CCMCMSParameterSpec() throws Exception {
        this(-1L, null, null, null, -1);
    }

    public void setInputLength(long l2) throws InvalidAlgorithmParameterException {
        this.e = l2;
        if (l2 < 0L) {
            throw new InvalidAlgorithmParameterException("invalid value for inputLength");
        }
        long l3 = (long)(Math.pow(2.0, 8 * (15 - this.b.length)) - 1.0);
        if (l2 - (long)this.d > l3) {
            throw new InvalidAlgorithmParameterException("parameter inputLength or nonce too long");
        }
    }

    public void setMacLength(int n2) throws InvalidAlgorithmParameterException {
        this.d = n2;
        if (n2 < 4 || n2 > 16) {
            throw new InvalidAlgorithmParameterException("Specified MAC-length not between 4 and 16 bytes!");
        }
    }

    public byte[] getAssociatedData() {
        return this.a;
    }

    public int getMacLength() {
        return this.d;
    }

    public byte[] getNonce() {
        return this.b;
    }

    public byte[] getMac() {
        return this.c;
    }

    public long getInputLength() {
        return this.e;
    }
}

