/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.cipher;

import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.pkcs5.PBES2ParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2KeyAndParameterSpec;
import iaik.pkcs.pkcs5.PBKDF2ParameterSpec;
import iaik.security.cipher.D;
import iaik.security.cipher.G;
import iaik.security.cipher.H;
import iaik.security.cipher.I;
import iaik.security.cipher.J;
import iaik.security.cipher.K;
import iaik.security.cipher.PBEKey;
import iaik.security.cipher.a;
import iaik.security.cipher.h;
import iaik.security.cipher.l;
import iaik.security.cipher.m;
import iaik.security.cipher.s;
import iaik.security.cipher.t;
import iaik.security.cipher.u;
import iaik.security.cipher.w;
import iaik.security.cipher.y;
import iaik.security.random.SecRandom;
import iaik.utils.CriticalObject;
import iaik.utils.InternalErrorException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class PBES2Cipher
extends a {
    static final AlgorithmID j = (AlgorithmID)AlgorithmID.hMAC_SHA1_.clone();
    private static final AlgorithmID o = (AlgorithmID)AlgorithmID.aes128_CBC.clone();
    private PBES2ParameterSpec p;
    private PBES2ParameterSpec q;
    private AlgorithmID r;
    private int s;
    private AlgorithmID t;
    static Class k;
    static Class l;
    static Class m;
    static Class n;

    private static String[] a(String string) {
        String[] stringArray = new String[3];
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringArray[i2] = stringTokenizer.nextToken().trim();
        }
        if (stringArray[1] == null) {
            stringArray[1] = "CBC";
        }
        if (stringArray[2] == null) {
            stringArray[2] = "PKCS5Padding";
        }
        return stringArray;
    }

    private static t b(String string) throws NoSuchAlgorithmException {
        t t2 = null;
        String string2 = string.toUpperCase();
        if (string2.startsWith("AES")) {
            string2 = "Rijndael";
            t2 = new G();
        } else if (string2.equals("DESEDE")) {
            string2 = "TripleDES";
            t2 = new J();
        } else if (string2.startsWith("CAST")) {
            string2 = "CAST128";
            t2 = new m();
        } else if (string2.equals("ARCFOUR") || string2.equals("RC4")) {
            t2 = new h();
        } else if (string2.equals("BLOWFISH")) {
            t2 = new l();
        } else if (string2.equals("CAMELLIA")) {
            t2 = new s();
        } else if (string2.equals("DES")) {
            t2 = new u();
        } else if (string2.equals("GOST")) {
            t2 = new w();
        } else if (string2.equals("MARS")) {
            t2 = new y();
        } else if (string2.equals("RC2")) {
            t2 = new D();
        } else if (string2.equals("RIJNDAEl256")) {
            t2 = new H();
        } else if (string2.equals("SERPENT")) {
            t2 = new I();
        } else if (string2.equals("TWOFISH")) {
            t2 = new K();
        } else {
            string2 = string;
        }
        if (t2 == null) {
            try {
                Class<?> clazz = Class.forName("iaik.security.cipher.Raw" + string2);
                t2 = (t)clazz.newInstance();
            }
            catch (Throwable throwable) {
                throw new NoSuchAlgorithmException("No Cipher implementation for " + string + ": " + throwable.toString());
            }
        }
        return t2;
    }

    public PBES2Cipher() {
    }

    PBES2Cipher(t t2, int n2, AlgorithmID algorithmID, AlgorithmID algorithmID2) {
        super(t2);
        this.s = n2;
        this.t = (AlgorithmID)algorithmID.clone();
        this.r = (AlgorithmID)algorithmID2.clone();
    }

    public void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algorithmParameterSpec;
        block7: {
            algorithmParameterSpec = null;
            if (algorithmParameters != null) {
                try {
                    String string = algorithmParameters.getAlgorithm().toUpperCase(Locale.US);
                    if (string.startsWith("PBES2")) {
                        algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(k == null ? (k = PBES2Cipher.class$("iaik.pkcs.pkcs5.PBES2ParameterSpec")) : k);
                        break block7;
                    }
                    if ("PBKDF2".equals(string)) {
                        algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(l == null ? (l = PBES2Cipher.class$("iaik.pkcs.pkcs5.PBKDF2ParameterSpec")) : l);
                        break block7;
                    }
                    if ("IV".equals(string)) {
                        algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(m == null ? (m = PBES2Cipher.class$("javax.crypto.spec.IvParameterSpec")) : m);
                        break block7;
                    }
                    if ("PBE".equals(string)) {
                        algorithmParameterSpec = (AlgorithmParameterSpec)algorithmParameters.getParameterSpec(n == null ? (n = PBES2Cipher.class$("javax.crypto.spec.PBEParameterSpec")) : n);
                        break block7;
                    }
                    throw new InvalidAlgorithmParameterException("Parameters must be of type PBES2Parameters.");
                }
                catch (InvalidParameterSpecException invalidParameterSpecException) {
                    throw new InvalidAlgorithmParameterException(invalidParameterSpecException.toString());
                }
            }
        }
        this.a(n2, key, algorithmParameterSpec, secureRandom);
    }

    public void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(n2, key, algorithmParameterSpec, secureRandom);
    }

    public void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.a(n2, key, null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new InvalidKeyException(invalidAlgorithmParameterException.toString());
        }
    }

    public AlgorithmParameters engineGetParameters() {
        if (this.p == null) {
            throw new IllegalStateException("Cipher not initialized yet!");
        }
        try {
            AlgorithmParameters algorithmParameters = AlgorithmParameters.getInstance("PBES2", "IAIK");
            algorithmParameters.init(this.p);
            return algorithmParameters;
        }
        catch (Exception exception) {
            throw new InternalErrorException(exception);
        }
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        return this.s;
    }

    public void engineSetPadding(String string) throws NoSuchPaddingException {
        if (this.a != null) {
            super.engineSetPadding(string);
        }
    }

    public void engineSetMode(String string) throws NoSuchAlgorithmException {
        if (this.a != null) {
            super.engineSetMode(string);
        }
    }

    private String a(AlgorithmID algorithmID) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Object object;
        String string = algorithmID.getImplementationName();
        String[] stringArray = PBES2Cipher.a(string);
        String string2 = stringArray[0];
        if (string2 == null) {
            throw new NoSuchAlgorithmException("Encryption scheme " + algorithmID.getName() + " not supported!");
        }
        if (this.a == null) {
            object = PBES2Cipher.b(string2);
            this.a((t)object);
        }
        object = stringArray[1];
        String string3 = stringArray[2];
        this.engineSetMode((String)object);
        this.engineSetPadding(string3);
        return string2;
    }

    void a(int n2, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        PBES2ParameterSpec pBES2ParameterSpec = null;
        AlgorithmID algorithmID = null;
        AlgorithmID algorithmID2 = null;
        int n3 = 0;
        int n4 = 0;
        byte[] byArray = null;
        if (algorithmParameterSpec instanceof PBES2ParameterSpec) {
            pBES2ParameterSpec = (PBES2ParameterSpec)algorithmParameterSpec;
            algorithmID = pBES2ParameterSpec.getEncryptionScheme();
            if (this.r != null && !this.r.equals(algorithmID)) {
                throw new InvalidAlgorithmParameterException("Illegal encryption scheme (" + algorithmID.getAlgorithm().getName() + "). Must be " + this.r.getAlgorithm().getName());
            }
        } else {
            if (n2 != 1 && n2 != 3) {
                throw new InvalidAlgorithmParameterException("Params must be PBES2ParameterSpec!");
            }
            algorithmID = this.r == null ? (AlgorithmID)o.clone() : (AlgorithmID)this.r.clone();
        }
        if (algorithmParameterSpec instanceof PBKDF2ParameterSpec) {
            PBKDF2ParameterSpec pBKDF2ParameterSpec = (PBKDF2ParameterSpec)algorithmParameterSpec;
            algorithmID2 = pBKDF2ParameterSpec.getPrf();
            if (j.equals(algorithmID2)) {
                if (this.t != null) {
                    algorithmID2 = (AlgorithmID)this.t.clone();
                }
            } else if (this.t != null && !this.t.equals(algorithmID2)) {
                throw new InvalidAlgorithmParameterException("Illegal PRF (" + algorithmID2.getAlgorithm().getName() + "). Must be " + this.t.getAlgorithm().getName());
            }
            if ((n3 = pBKDF2ParameterSpec.getDerivedKeyLength()) <= 0) {
                if (this.s == 0) {
                    throw new InvalidAlgorithmParameterException("Derived key length not specified!");
                }
                n3 = this.s;
            } else if (this.s > 0 && this.s != n3) {
                throw new InvalidAlgorithmParameterException("Illegal key length (" + n3 + "). Must be " + this.s);
            }
            byArray = pBKDF2ParameterSpec.getSalt();
            n4 = pBKDF2ParameterSpec.getIterationCount();
        } else if (algorithmParameterSpec instanceof IvParameterSpec) {
            algorithmID.setAlgorithmParameterSpec(algorithmParameterSpec);
        } else if (algorithmParameterSpec instanceof PBEParameterSpec) {
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            byArray = pBEParameterSpec.getSalt();
            n4 = pBEParameterSpec.getIterationCount();
        } else if (algorithmParameterSpec != null) {
            throw new InvalidAlgorithmParameterException("Params must be PBES2ParameterSpec or PBKDF2ParameterSpec or IvParameterSpec!");
        }
        if (pBES2ParameterSpec == null) {
            if (byArray == null) {
                byArray = new byte[32];
                secureRandom.nextBytes(byArray);
            }
            if (n4 <= 0) {
                n4 = 2000;
            }
            if (algorithmID2 == null) {
                AlgorithmID algorithmID3 = algorithmID2 = this.t != null ? (AlgorithmID)this.t.clone() : (AlgorithmID)j.clone();
            }
            if (n3 <= 0) {
                n3 = this.s > 0 ? this.s : 16;
            }
            pBES2ParameterSpec = new PBES2ParameterSpec(byArray, n4, n3, algorithmID);
            pBES2ParameterSpec.setPrf(algorithmID2);
        }
        this.q = (PBES2ParameterSpec)pBES2ParameterSpec.clone();
        this.p = (PBES2ParameterSpec)pBES2ParameterSpec.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block20: {
            String string;
            if (!(key instanceof PBEKey)) {
                throw new InvalidKeyException("Must be a PBEKey in RAW format (iaik.security.cipher.PBEKey).");
            }
            if (secureRandom == null) {
                secureRandom = SecRandom.getDefault();
            }
            this.a(n2, algorithmParameterSpec, secureRandom);
            AlgorithmID algorithmID = this.p.getEncryptionScheme();
            try {
                string = this.a(algorithmID);
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception.toString());
            }
            KeyGenerator keyGenerator = null;
            try {
                keyGenerator = KeyGenerator.getInstance("PBKDF2", "IAIK");
            }
            catch (Exception exception) {
                throw new InvalidAlgorithmParameterException(exception.toString());
            }
            byte[] byArray = key.getEncoded();
            byte[] byArray2 = this.p.getSalt();
            int n3 = this.p.getIterationCount();
            int n4 = this.p.getDerivedKeyLength();
            AlgorithmID algorithmID2 = this.p.getPrf();
            SecretKey secretKey = null;
            try {
                Object object;
                PBKDF2KeyAndParameterSpec pBKDF2KeyAndParameterSpec = new PBKDF2KeyAndParameterSpec(byArray, byArray2, n3, n4);
                pBKDF2KeyAndParameterSpec.setPrf(algorithmID2);
                keyGenerator.init(pBKDF2KeyAndParameterSpec, secureRandom);
                secretKey = keyGenerator.generateKey();
                SecretKeySpec secretKeySpec = new SecretKeySpec(secretKey.getEncoded(), string);
                try {
                    object = SecretKeyFactory.getInstance(string, "IAIK");
                    secretKey = ((SecretKeyFactory)object).generateSecret(secretKeySpec);
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Error creating encryption scheme key: " + exception.toString());
                }
                object = null;
                try {
                    object = this.q.getEncryptionSchemeParameters();
                }
                catch (Exception exception) {
                    throw new InvalidAlgorithmParameterException("Error parsing encryption scheme parameters: " + exception.toString());
                }
                if (object == null) {
                    super.engineInit(n2, secretKey, secureRandom);
                } else {
                    super.engineInit(n2, (Key)secretKey, (AlgorithmParameterSpec)object, secureRandom);
                }
                AlgorithmParameters algorithmParameters = super.engineGetParameters();
                if (algorithmParameters == null) break block20;
                algorithmID.setAlgorithmParameters(algorithmParameters);
                try {
                    Class<?> clazz = null;
                    if (object == null) {
                        object = algorithmID.getAlgorithmParameterSpec();
                    }
                    if (object != null) {
                        clazz = object.getClass();
                    }
                    if (clazz != null) {
                        object = algorithmParameters.getParameterSpec(clazz);
                        this.p.setEncryptionSchemeParameters((AlgorithmParameterSpec)object);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                CriticalObject.destroy(byArray);
            }
        }
    }

    void a() {
        this.p = (PBES2ParameterSpec)this.q.clone();
        super.a();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class PBES2WithHmacSHA1AndDESede
    extends PBES2Cipher {
        public PBES2WithHmacSHA1AndDESede() {
            super(new J(), 24, AlgorithmID.hMAC_SHA1, AlgorithmID.des_EDE3_CBC);
        }
    }

    public static final class PBES2WithHmacSHA512AndAES256
    extends PBES2Cipher {
        public PBES2WithHmacSHA512AndAES256() {
            super(new G(), 32, AlgorithmID.hMAC_SHA512, AlgorithmID.aes256_CBC);
        }
    }

    public static final class PBES2WithHmacSHA384AndAES192
    extends PBES2Cipher {
        public PBES2WithHmacSHA384AndAES192() {
            super(new G(), 24, AlgorithmID.hMAC_SHA384, AlgorithmID.aes192_CBC);
        }
    }

    public static final class PBES2WithHmacSHA256AndAES
    extends PBES2Cipher {
        public PBES2WithHmacSHA256AndAES() {
            super(new G(), 16, AlgorithmID.hMAC_SHA256, AlgorithmID.aes128_CBC);
        }
    }

    public static final class PBES2WithHmacSHA1AndAES
    extends PBES2Cipher {
        public PBES2WithHmacSHA1AndAES() {
            super(new G(), 16, AlgorithmID.hMAC_SHA1_, AlgorithmID.aes128_CBC);
        }
    }
}

