/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dh;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.InternalErrorException;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class DHPublicKey
extends PublicKeyInfo
implements javax.crypto.interfaces.DHPublicKey {
    private static final long serialVersionUID = 4363294640634943357L;
    private transient ASN1 a;
    private BigInteger c;
    private transient DHParameterSpec d;

    public DHPublicKey(BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        this.c = bigInteger;
        this.d = dHParameterSpec;
        this.a();
    }

    public DHPublicKey(DHPublicKeySpec dHPublicKeySpec) {
        this.c = dHPublicKeySpec.getY();
        this.d = new DHParameterSpec(dHPublicKeySpec.getP(), dHPublicKeySpec.getG());
        this.a();
    }

    public DHPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public DHPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public DHPublicKey(InputStream inputStream) throws IOException, InvalidKeyException {
        super(inputStream);
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.a = new ASN1(byArray);
            this.c = (BigInteger)this.a.toASN1Object().getValue();
            ASN1Object aSN1Object = this.public_key_algorithm.getParameter();
            BigInteger bigInteger = (BigInteger)aSN1Object.getComponentAt(0).getValue();
            BigInteger bigInteger2 = (BigInteger)aSN1Object.getComponentAt(1).getValue();
            if (aSN1Object.countComponents() > 2) {
                int n2 = ((BigInteger)aSN1Object.getComponentAt(2).getValue()).intValue();
                this.d = new DHParameterSpec(bigInteger, bigInteger2, n2);
            } else {
                this.d = new DHParameterSpec(bigInteger, bigInteger2);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No DH Public Key: " + exception.toString());
        }
    }

    private void a() {
        try {
            this.a = new ASN1(new INTEGER(this.c));
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent(new INTEGER(this.d.getP()));
            sEQUENCE.addComponent(new INTEGER(this.d.getG()));
            if (this.d.getL() > 0) {
                sEQUENCE.addComponent(new INTEGER(this.d.getL()));
            }
            this.public_key_algorithm = (AlgorithmID)AlgorithmID.dhKeyAgreement.clone();
            this.public_key_algorithm.setParameter(sEQUENCE);
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPublicKeyInfo();
    }

    public byte[] encode() {
        return this.a.toByteArray();
    }

    public String getAlgorithm() {
        return "DH";
    }

    public BigInteger getY() {
        return this.c;
    }

    public DHParameterSpec getParams() {
        return this.d;
    }

    public byte[] getFingerprint() {
        return this.a.fingerprint();
    }

    public int hashCode() {
        return this.c.hashCode() ^ this.d.hashCode();
    }

    private void readObject(ObjectInputStream objectInputStream) {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DH public key");
        stringBuffer.append(this.d == null ? ":\n" : " (" + this.d.getP().bitLength() + " bits):\n");
        stringBuffer.append("Y: " + this.c.toString(16) + "\n");
        if (this.d != null) {
            stringBuffer.append("key parameters:\n" + this.d.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

