/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.dsa;

import iaik.asn1.ASN;
import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.dsa.DSAParams;
import iaik.utils.InternalErrorException;
import iaik.x509.PublicKeyInfo;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.spec.DSAPublicKeySpec;

public class DSAPublicKey
extends PublicKeyInfo
implements java.security.interfaces.DSAPublicKey {
    private transient ASN1 a;
    private BigInteger c;
    private transient DSAParams d;

    public DSAPublicKey(BigInteger bigInteger, java.security.interfaces.DSAParams dSAParams) {
        this.c = bigInteger;
        if (dSAParams != null) {
            this.d = dSAParams instanceof DSAParams ? (DSAParams)dSAParams : new DSAParams(dSAParams);
        }
        this.a();
    }

    public DSAPublicKey(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        this.c = bigInteger;
        this.d = new DSAParams(bigInteger2, bigInteger3, bigInteger4);
        this.a();
    }

    public DSAPublicKey(DSAPublicKeySpec dSAPublicKeySpec) {
        this(dSAPublicKeySpec.getY(), dSAPublicKeySpec.getP(), dSAPublicKeySpec.getQ(), dSAPublicKeySpec.getG());
    }

    public DSAPublicKey(java.security.interfaces.DSAPublicKey dSAPublicKey) {
        this(dSAPublicKey.getY(), dSAPublicKey.getParams());
    }

    public DSAPublicKey(byte[] byArray) throws InvalidKeyException {
        super(byArray);
    }

    public DSAPublicKey(ASN1Object aSN1Object) throws InvalidKeyException {
        super(aSN1Object);
    }

    public DSAPublicKey(InputStream inputStream) throws InvalidKeyException, IOException {
        super(inputStream);
    }

    public BigInteger getY() {
        return this.c;
    }

    public java.security.interfaces.DSAParams getParams() {
        return this.d;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    protected void decode(byte[] byArray) throws InvalidKeyException {
        try {
            this.a = new ASN1(byArray);
            this.c = (BigInteger)this.a.toASN1Object().getValue();
            ASN1Object aSN1Object = this.public_key_algorithm.getParameter();
            if (aSN1Object != null && !aSN1Object.isA(ASN.NULL)) {
                this.d = new DSAParams(aSN1Object);
            }
        }
        catch (Exception exception) {
            throw new InvalidKeyException("No DSA public key.");
        }
    }

    public byte[] encode() {
        return this.a.toByteArray();
    }

    private void a() {
        try {
            this.public_key_algorithm = (AlgorithmID)AlgorithmID.dsa.clone();
            if (this.d != null) {
                this.public_key_algorithm.setParameter(this.d.toASN1Object());
            } else {
                this.public_key_algorithm.encodeAbsentParametersAsNull(false);
            }
            this.a = new ASN1(new INTEGER(this.c));
        }
        catch (CodingException codingException) {
            throw new InternalErrorException(codingException);
        }
        this.createPublicKeyInfo();
    }

    public int hashCode() {
        return this.d.hashCode() ^ this.c.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof DSAPublicKey) {
            DSAPublicKey dSAPublicKey = (DSAPublicKey)object;
            if (!this.c.equals(dSAPublicKey.getY())) {
                return false;
            }
            return this.d.equals(dSAPublicKey.getParams());
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DSA public key");
        stringBuffer.append(this.d == null ? ":\n" : " (" + this.d.getP().bitLength() + " bits):\n");
        stringBuffer.append("y: " + this.c.toString(16) + "\n");
        if (this.d != null) {
            stringBuffer.append(this.d.toString());
        }
        return stringBuffer.toString();
    }
}

