/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.mac;

import iaik.utils.CryptoUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.MacSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public abstract class CBCMac
extends MacSpi {
    private Cipher a;
    private Key b;
    private int c;
    private byte[] d;
    private int e;

    CBCMac(String string) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        this.a = Cipher.getInstance(string + "/CBC/NoPadding", "IAIK");
        this.c = this.a.getBlockSize();
        this.d = new byte[this.c];
    }

    protected int engineGetMacLength() {
        return this.c;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            byte[] byArray = ((IvParameterSpec)algorithmParameterSpec).getIV();
            int n2 = byArray.length;
            if (n2 != this.c) {
                throw new InvalidAlgorithmParameterException("Invalid iv length (" + n2 + "). Expected " + this.c);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byArray[i2] == 0) continue;
                throw new InvalidAlgorithmParameterException("Invalid iv! All iv bytes must be zero!");
            }
        }
        this.a(key);
        this.b = key;
    }

    protected void engineUpdate(byte by) {
        this.engineUpdate(new byte[]{by}, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return;
        }
        int n5 = n2;
        int n6 = n3;
        if (this.e > 0) {
            n4 = Math.min(n3, this.c - this.e);
            System.arraycopy(byArray, n2, this.d, this.e, n4);
            n5 += n4;
            this.e += n4;
            n6 -= n4;
        }
        if (n6 > 0) {
            if (this.e == this.c) {
                this.a.update(this.d);
                this.e = 0;
            }
            if ((n4 = (n6 - 1) / this.c * this.c) > 0) {
                this.a.update(byArray, n5, n4);
                n5 += n4;
                n6 -= n4;
            }
            System.arraycopy(byArray, n5, this.d, this.e, n6);
            this.e += n6;
        }
    }

    protected byte[] engineDoFinal() {
        byte[] byArray;
        boolean bl;
        boolean bl2 = bl = this.e != this.d.length;
        if (bl) {
            this.d[this.e++] = 0;
            while (this.e < this.d.length) {
                this.d[this.e++] = 0;
            }
        }
        try {
            byArray = this.a.doFinal(this.d);
        }
        catch (Exception exception) {
            throw new ProviderException("encryption error: " + exception);
        }
        this.engineReset();
        return byArray;
    }

    protected void engineReset() {
        try {
            this.a(this.b);
            this.e = 0;
            CryptoUtils.zeroBlock(this.d);
        }
        catch (Exception exception) {
            throw new ProviderException("cipher initialization error: " + exception);
        }
    }

    private void a(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray = new byte[this.c];
        this.a.init(1, key, new IvParameterSpec(byArray));
    }

    public static final class CBCMacDES
    extends CBCMac {
        public CBCMacDES() throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
            super("DES");
        }
    }

    public static final class CBCMacDESede
    extends CBCMac {
        public CBCMacDESede() throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
            super("DESede");
        }
    }

    public static final class CBCMacAES
    extends CBCMac {
        public CBCMacAES() throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
            super("AES");
        }
    }
}

