/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.mac;

import iaik.utils.CryptoUtils;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.MacSpi;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;

public abstract class CMac
extends MacSpi {
    private String a;
    private Cipher b;
    private Key c;
    private byte[] d;
    private byte[] e;
    private int f;
    private byte[] g;
    private int h;
    private int i;

    CMac(String string) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException {
        this.b = Cipher.getInstance(string + "/CBC/NoPadding", "IAIK");
        this.a = string;
        this.f = this.b.getBlockSize();
        this.g = new byte[this.f];
        switch (this.f) {
            case 8: {
                this.i = 27;
                break;
            }
            case 16: {
                this.i = 135;
                break;
            }
            default: {
                throw new ProviderException("CMAC only supports ciphers with block size 64 or 128 bit");
            }
        }
    }

    protected int engineGetMacLength() {
        return this.f;
    }

    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.a(key);
        this.c = key;
        this.d = null;
        this.e = null;
    }

    protected void engineUpdate(byte by) {
        this.engineUpdate(new byte[]{by}, 0, 1);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) {
        int n4;
        if (n3 == 0) {
            return;
        }
        int n5 = n2;
        int n6 = n3;
        if (this.h > 0) {
            n4 = Math.min(n3, this.f - this.h);
            System.arraycopy(byArray, n2, this.g, this.h, n4);
            n5 += n4;
            this.h += n4;
            n6 -= n4;
        }
        if (n6 > 0) {
            if (this.h == this.f) {
                this.b.update(this.g);
                this.h = 0;
            }
            if ((n4 = (n6 - 1) / this.f * this.f) > 0) {
                this.b.update(byArray, n5, n4);
                n5 += n4;
                n6 -= n4;
            }
            System.arraycopy(byArray, n5, this.g, this.h, n6);
            this.h += n6;
        }
    }

    protected byte[] engineDoFinal() {
        byte[] byArray;
        byte[] byArray2;
        boolean bl;
        boolean bl2 = bl = this.h != this.g.length;
        if (bl) {
            this.g[this.h++] = -128;
            while (this.h < this.g.length) {
                this.g[this.h++] = 0;
            }
            byArray2 = this.b();
        } else {
            byArray2 = this.a();
        }
        CryptoUtils.xorBlock(this.g, 0, byArray2, 0, this.g, 0, this.f);
        try {
            byArray = this.b.doFinal(this.g);
        }
        catch (Exception exception) {
            throw new ProviderException("encryption error: " + exception);
        }
        this.engineReset();
        return byArray;
    }

    protected void engineReset() {
        try {
            this.a(this.c);
            this.h = 0;
            CryptoUtils.zeroBlock(this.g);
        }
        catch (Exception exception) {
            throw new ProviderException("cipher initialization error: " + exception);
        }
    }

    private void a(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte[] byArray = new byte[this.f];
        this.b.init(1, key, new IvParameterSpec(byArray));
    }

    private byte[] a() {
        if (this.d == null) {
            byte[] byArray;
            Object object;
            byte[] byArray2 = new byte[this.f];
            try {
                object = Cipher.getInstance(this.a + "/ECB/NoPadding", "IAIK");
                ((Cipher)object).init(1, this.c);
                byArray = ((Cipher)object).doFinal(byArray2);
            }
            catch (Exception exception) {
                throw new ProviderException("unxecpected internal error: " + exception);
            }
            object = CryptoUtils.shiftLeft(byArray);
            if ((byArray[0] & 0x80) != 0) {
                Object object2 = object;
                int n2 = ((Object)object).length - 1;
                object2[n2] = (byte)(object2[n2] ^ this.i);
            }
            this.d = (byte[])object;
        }
        return this.d;
    }

    private byte[] b() {
        if (this.e == null) {
            byte[] byArray = this.a();
            byte[] byArray2 = CryptoUtils.shiftLeft(byArray);
            if ((byArray[0] & 0x80) != 0) {
                int n2 = byArray2.length - 1;
                byArray2[n2] = (byte)(byArray2[n2] ^ this.i);
            }
            this.e = byArray2;
        }
        return this.e;
    }
}

