/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.iso.iso9796.ISO9796P2S2S3Signature;
import iaik.security.rsa.RSA;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;

public class RSAISO9796P2S2S3Signature
extends ISO9796P2S2S3Signature {
    private RSA p;
    private int q;

    public RSAISO9796P2S2S3Signature() {
        super("RSA-ISO9796-2-2-3");
    }

    protected RSAISO9796P2S2S3Signature(String string, int n2, byte by) {
        super(string, n2, by);
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        try {
            this.p = RSA.a();
            this.p.setMode("ECB");
            this.p.setPadding("NoPadding");
            this.p.init(2, publicKey, null);
            RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
            BigInteger bigInteger = rSAPublicKey.getModulus();
            this.q = bigInteger.bitLength();
            this.reset(bigInteger);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitVerify error: " + exception.toString());
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        try {
            this.p = RSA.a();
            this.p.setMode("ECB");
            this.p.setPadding("NoPadding");
            this.p.init(1, privateKey, this.getSecureRandom());
            RSAPrivateKey rSAPrivateKey = (RSAPrivateKey)privateKey;
            BigInteger bigInteger = rSAPrivateKey.getModulus();
            this.q = bigInteger.bitLength();
            this.reset(bigInteger);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw invalidKeyException;
        }
        catch (Exception exception) {
            throw new InvalidKeyException("InitSign error: " + exception.toString());
        }
    }

    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engineInitSign(privateKey);
        this.setSecureRandom(secureRandom);
    }

    protected byte[] produceSignature(byte[] byArray) throws SignatureException {
        if (this.p == null) {
            throw new NullPointerException("RSA Cipher must not be null!");
        }
        this.p.setSecureRandom(this.getSecureRandom());
        try {
            return this.p.doFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected byte[] openSignature(byte[] byArray) throws SignatureException {
        if (this.p == null) {
            throw new NullPointerException("RSA Cipher must not be null!");
        }
        int n2 = (this.q + 7) / 8;
        if (n2 != byArray.length) {
            throw new SignatureException("Signature value must be k bits long.");
        }
        try {
            return this.p.doFinal(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            throw new SignatureException(exception.toString());
        }
    }

    protected void setSecureRandom(SecureRandom secureRandom) {
        super.setSecureRandom(secureRandom);
        if (this.p != null) {
            this.p.setSecureRandom(secureRandom);
        }
    }
}

