/*
 * Decompiled with CFR 0.152.
 */
package iaik.security.rsa;

import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.rsa.b;
import iaik.utils.CryptoUtils;
import java.security.MessageDigest;
import java.security.SignatureException;

public abstract class RSASignature
extends b {
    private byte[][] a;

    RSASignature(AlgorithmID algorithmID, MessageDigest messageDigest, byte[][] byArray) {
        this(algorithmID, messageDigest);
        this.a(byArray);
    }

    void a(byte[][] byArray) {
        this.a = byArray;
    }

    protected RSASignature(AlgorithmID algorithmID, MessageDigest messageDigest) {
        super(algorithmID.getName() + "withRSA", algorithmID, messageDigest, "PKCS1Padding");
    }

    protected RSASignature(String string, MessageDigest messageDigest) {
        super(string, messageDigest, "PKCS1Padding");
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.c == null) {
            throw new NullPointerException("Cannot calculate signature. Digest algorithm must not be null!");
        }
        byte[] byArray = this.a();
        byte[] byArray2 = null;
        try {
            if (this.a != null) {
                byte[] byArray3 = this.a[0];
                int n2 = byArray3.length;
                byArray2 = new byte[n2 + byArray.length];
                System.arraycopy(byArray3, 0, byArray2, 0, n2);
                System.arraycopy(byArray, 0, byArray2, n2, byArray.length);
            } else {
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent(this.c.toASN1Object());
                sEQUENCE.addComponent(new OCTET_STRING(byArray));
                byArray2 = DerCoder.encode(sEQUENCE);
            }
            return this.a(byArray2);
        }
        catch (Exception exception) {
            throw new SignatureException("Signing error: " + exception.toString());
        }
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        byte[] byArray3 = this.a();
        try {
            byArray2 = this.a(byArray);
        }
        catch (Exception exception) {
            throw new SignatureException("Signature decryption error: " + exception.toString());
        }
        try {
            boolean bl = false;
            if (this.a != null) {
                for (int i2 = 0; i2 < this.a.length; ++i2) {
                    byte[] byArray4 = this.a[i2];
                    int n2 = byArray4.length;
                    if (byArray2.length <= n2 || !CryptoUtils.equalsBlock(byArray4, 0, byArray2, 0, n2)) continue;
                    int n3 = byArray2.length - n2;
                    if (n3 == byArray3.length) {
                        bl = CryptoUtils.secureEqualsBlock(byArray3, 0, byArray2, n2, n3);
                    }
                    break;
                }
            } else {
                if (this.c == null) {
                    throw new NullPointerException("Cannot calculate signature. Digest algorithm must not be null!");
                }
                SEQUENCE sEQUENCE = new SEQUENCE();
                sEQUENCE.addComponent(this.c.toASN1Object());
                sEQUENCE.addComponent(new OCTET_STRING(byArray3));
                bl = CryptoUtils.equalsBlock(DerCoder.encode(sEQUENCE), byArray2);
            }
            return bl;
        }
        catch (Exception exception) {
            throw new SignatureException("Signature ASN.1 formatting error: " + exception.toString());
        }
    }
}

