/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr;

import iaik.asn1.ASN1Object;
import iaik.asn1.BIT_STRING;
import iaik.asn1.CodingException;
import iaik.asn1.ENUMERATED;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class ObjectDigestInfo {
    public static final int PUBLIC_KEY = 0;
    public static final int PUBLIC_KEY_CERT = 1;
    public static final int OTHER_OBJECT_TYPES = 2;
    int a;
    ObjectID b;
    AlgorithmID c;
    byte[] d;

    ObjectDigestInfo() {
        this.a = -1;
    }

    public ObjectDigestInfo(int n2, AlgorithmID algorithmID, byte[] byArray, ObjectID objectID) {
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Invalid object type: " + n2);
        }
        if (n2 == 2 && objectID == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo for otherObjectTypes. Missing otherObjectTypeID!");
        }
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing digestAlgorithm!");
        }
        if (byArray == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing digest value!");
        }
        this.a = n2;
        this.c = algorithmID;
        this.d = byArray;
        if (n2 == 2) {
            this.b = objectID;
        }
    }

    public ObjectDigestInfo(PublicKey publicKey, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        if (publicKey == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing publicKey!");
        }
        String string = publicKey.getFormat().toLowerCase();
        if (!string.equals("x.509") && !string.equals("x509")) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo from public key: Invalid encoding format: " + string);
        }
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing digestAlgorithm!");
        }
        this.a = 0;
        this.c = algorithmID;
        this.d = ObjectDigestInfo.calculateDigest(publicKey.getEncoded(), algorithmID);
    }

    public ObjectDigestInfo(X509Certificate x509Certificate, AlgorithmID algorithmID) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing publicKey!");
        }
        if (algorithmID == null) {
            throw new IllegalArgumentException("Cannot create ObjectDigestInfo. Missing digestAlgorithm!");
        }
        this.a = 1;
        this.c = algorithmID;
        this.d = ObjectDigestInfo.calculateDigest(x509Certificate.getEncoded(), algorithmID);
    }

    public ObjectDigestInfo(ASN1Object aSN1Object) throws CodingException {
        this.a(aSN1Object);
    }

    public static byte[] calculateDigest(byte[] byArray, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = algorithmID.getMessageDigestInstance();
        return messageDigest.digest(byArray);
    }

    public int getObjectType() {
        return this.a;
    }

    public String getObjectTypeName() {
        String string = "publicKey";
        switch (this.a) {
            case 0: {
                break;
            }
            case 1: {
                string = "publicKeyCert";
                break;
            }
            case 2: {
                string = "otherObjectTypes" + (this.b != null ? " (" + this.b.getName() + ")" : "");
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    public ObjectID getOtherObjectTypeID() {
        return this.b;
    }

    public AlgorithmID getDigestAlgorithm() {
        return this.c;
    }

    public byte[] getObjectDigest() {
        return this.d;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ObjectDigestInfo)) {
            return false;
        }
        ObjectDigestInfo objectDigestInfo = (ObjectDigestInfo)object;
        if (this.a != objectDigestInfo.a) {
            return false;
        }
        if (!this.c.equals(objectDigestInfo.c)) {
            return false;
        }
        if (!CryptoUtils.equalsBlock(this.d, objectDigestInfo.d)) {
            return false;
        }
        if (this.b != null && objectDigestInfo.b != null) {
            return this.b.equals(objectDigestInfo.b);
        }
        return this.b == null && objectDigestInfo.b == null;
    }

    public int hashCode() {
        return Util.calculateHashCode(this.d);
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new ENUMERATED(this.a));
        if (this.b != null) {
            sEQUENCE.addComponent(this.b);
        }
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(new BIT_STRING(this.d));
        return sEQUENCE;
    }

    private void a(ASN1Object aSN1Object) throws CodingException {
        this.a = (Integer)aSN1Object.getComponentAt(0).getValue();
        if (this.a < 0 || this.a > 2) {
            throw new CodingException("cannot decode ObjectDigestInfo. Invalid object type: " + this.a);
        }
        int n2 = 1;
        if (aSN1Object.countComponents() == 4) {
            this.b = (ObjectID)aSN1Object.getComponentAt(n2);
            ++n2;
        }
        if (this.a == 2 && this.b == null) {
            throw new CodingException("Cannot decode ObjectDigestInfo. Missing otherObjectTypeID for otherObjectTypes!");
        }
        this.c = new AlgorithmID(aSN1Object.getComponentAt(n2 + 0));
        this.d = (byte[])aSN1Object.getComponentAt(n2 + 1).getValue();
    }

    public boolean identifiesCert(X509Certificate x509Certificate) throws NoSuchAlgorithmException, CertificateEncodingException {
        if (this.a != 1) {
            return false;
        }
        byte[] byArray = ObjectDigestInfo.calculateDigest(x509Certificate.getEncoded(), this.c);
        return CryptoUtils.equalsBlock(this.d, byArray);
    }

    public boolean identifiesKey(PublicKey publicKey) throws NoSuchAlgorithmException {
        if (this.a != 0) {
            return false;
        }
        byte[] byArray = ObjectDigestInfo.calculateDigest(publicKey.getEncoded(), this.c);
        return CryptoUtils.equalsBlock(byArray, this.d);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("digestObjectType: " + this.getObjectTypeName() + "\n");
        stringBuffer.append("digestAlgorithm: " + this.c + "\n");
        stringBuffer.append("objectDigest: " + Util.toString(this.d));
        return stringBuffer.toString();
    }
}

