/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.attr.Holder;
import iaik.x509.attr.Target;
import iaik.x509.attr.TargetException;
import iaik.x509.attr.Targets;
import java.util.Enumeration;
import java.util.Vector;

public class ProxyInfo
extends V3Extension {
    public static final ObjectID oid = ObjectID.attrCertExt_ProxyInfo;
    private Vector a = new Vector();
    private Holder b;

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new X509ExtensionException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getName() + ") of ProxyInfo extension; must be a SEQUENCE!");
        }
        this.a.removeAllElements();
        try {
            for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                this.a.addElement(new Targets(aSN1Object.getComponentAt(i2)));
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Error parsing Targets object: " + codingException.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        Enumeration enumeration = this.a.elements();
        try {
            while (enumeration.hasMoreElements()) {
                sEQUENCE.addComponent(((Targets)enumeration.nextElement()).toASN1Object());
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Cannot create ASN.1 Targets: " + codingException.getMessage());
        }
        return sEQUENCE;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public boolean addTargets(Targets targets) {
        boolean bl = true;
        if (this.a.contains(targets)) {
            bl = false;
        } else {
            this.a.addElement(targets);
        }
        return bl;
    }

    public void setTargets(Targets[] targetsArray) {
        this.a.removeAllElements();
        if (targetsArray != null) {
            for (int i2 = 0; i2 < targetsArray.length; ++i2) {
                this.a.addElement(targetsArray[i2]);
            }
        }
    }

    public boolean removeTargets(Targets targets) {
        return this.a.removeElement(targets);
    }

    public boolean removeTargetElement(Target target) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Targets targets = (Targets)enumeration.nextElement();
            if (!targets.removeTarget(target)) continue;
            bl = true;
            if (targets.size() != 0) continue;
            this.a.removeElement(targets);
        }
        return bl;
    }

    public void removeAllTargets() {
        this.a.removeAllElements();
    }

    public Targets[] getTargets() {
        Object[] objectArray = new Targets[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public Target[] getTargetElements() {
        Object[] objectArray;
        Vector<Target> vector = new Vector<Target>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            Target[] targetArray = objectArray.getTargets();
            for (int i2 = 0; i2 < targetArray.length; ++i2) {
                vector.addElement(targetArray[i2]);
            }
        }
        objectArray = new Target[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int numberOfTargets() {
        return this.a.size();
    }

    public int numberOfTargetElements() {
        return this.getTargetElements().length;
    }

    public Targets getTargets(Object object) throws TargetException {
        Targets targets = null;
        if (this.a.size() > 0) {
            TargetException targetException = null;
            Enumeration enumeration = this.a.elements();
            while (enumeration.hasMoreElements()) {
                Targets targets2 = (Targets)enumeration.nextElement();
                try {
                    if (!targets2.isTargetFor(object)) continue;
                    targets = targets2;
                    break;
                }
                catch (TargetException targetException2) {
                    targetException = targetException2;
                }
            }
            if (targets == null && targetException != null) {
                throw targetException;
            }
        }
        return targets;
    }

    public boolean checkProxy(Object object, Object object2) throws TargetException {
        boolean bl = false;
        if (object instanceof Holder) {
            if (this.b == null) {
                throw new NullPointerException("Cannot verify sender identity since AC holder not specified!");
            }
            bl = this.b.equals(object) && (this.a.size() == 0 || this.getTargets(object2) != null);
        } else {
            Targets targets;
            bl = this.a.size() == 0 ? true : ((targets = this.getTargets(object)) == null ? false : targets.isTargetFor(object2));
        }
        return bl;
    }

    public boolean checkProxyChain(Target[] targetArray) throws TargetException {
        if (targetArray == null) {
            throw new NullPointerException("Cannot check null array of Target elements.");
        }
        if (targetArray.length == 0) {
            throw new NullPointerException("Cannot check empty array of Target elements.");
        }
        boolean bl = false;
        if (this.a.size() > 0) {
            Targets targets = this.getTargets(targetArray[0]);
            if (targets != null) {
                bl = true;
                for (int i2 = 1; i2 < targetArray.length; ++i2) {
                    if (targets.isTargetFor(targetArray[i2])) continue;
                    bl = false;
                    break;
                }
            }
        } else {
            throw new TargetException("Cannot verify proxy chain since no Targets are included in this ProxyInfo extension.");
        }
        return bl;
    }

    public boolean containsTargetElement(Target target) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Targets targets = (Targets)enumeration.nextElement();
            if (!targets.containsTarget(target)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void specifyHolder(Holder holder) {
        this.b = holder;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.isEmpty()) {
            stringBuffer.append("This ProxyInfo does not contain any Targets.");
        } else {
            int n2 = this.a.size();
            if (bl) {
                stringBuffer.append("This ProxyInfo contains " + n2 + " Targets object(s):\n");
                int n3 = 1;
                Enumeration enumeration = this.a.elements();
                while (enumeration.hasMoreElements()) {
                    if (n3 > 1) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("Targets " + n3++ + ":\n");
                    Util.printIndented(((Targets)enumeration.nextElement()).toString(true), true, stringBuffer);
                }
            } else {
                stringBuffer.append("This ProxyInfo contains " + n2 + " Targets object(s).");
            }
        }
        return stringBuffer.toString();
    }
}

