/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.attr.extensions;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.utils.Util;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;
import iaik.x509.attr.Target;
import iaik.x509.attr.TargetException;
import iaik.x509.attr.Targets;
import java.util.Enumeration;
import java.util.Vector;

public class TargetInformation
extends V3Extension {
    public static final ObjectID oid = ObjectID.attrCertExt_TargetInformation;
    private Vector a = new Vector();

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (!aSN1Object.isA(ASN.SEQUENCE)) {
            throw new X509ExtensionException("Invalid ASN.1 type (" + aSN1Object.getAsnType().getName() + ") of TargetInformation extension; must be a SEQUENCE!");
        }
        this.a.removeAllElements();
        try {
            for (int i2 = 0; i2 < aSN1Object.countComponents(); ++i2) {
                this.a.addElement(new Targets(aSN1Object.getComponentAt(i2)));
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Error parsing Targets object: " + codingException.getMessage());
        }
    }

    public ASN1Object toASN1Object() throws X509ExtensionException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        Enumeration enumeration = this.a.elements();
        try {
            while (enumeration.hasMoreElements()) {
                sEQUENCE.addComponent(((Targets)enumeration.nextElement()).toASN1Object());
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException("Cannot create ASN.1 Targets: " + codingException.getMessage());
        }
        return sEQUENCE;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public boolean addTargetElement(Target target) {
        boolean bl = false;
        if (target != null && !this.containsTargetElement(target)) {
            Targets targets;
            if (this.a.isEmpty()) {
                targets = new Targets();
                this.a.addElement(targets);
            } else {
                targets = (Targets)this.a.elementAt(0);
            }
            bl = targets.addTarget(target);
        }
        return bl;
    }

    public void setTargetElements(Target[] targetArray) {
        this.a.removeAllElements();
        if (targetArray != null) {
            Targets targets = new Targets();
            targets.setTargets(targetArray);
            this.a.addElement(targets);
        }
    }

    public void setTargets(Targets[] targetsArray) {
        this.a.removeAllElements();
        if (targetsArray != null) {
            for (int i2 = 0; i2 < targetsArray.length; ++i2) {
                this.a.addElement(targetsArray[i2]);
            }
        }
    }

    public boolean removeTargets(Targets targets) {
        return this.a.removeElement(targets);
    }

    public boolean removeTargetElement(Target target) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Targets targets = (Targets)enumeration.nextElement();
            if (!targets.removeTarget(target)) continue;
            bl = true;
            if (targets.size() != 0) continue;
            this.a.removeElement(targets);
        }
        return bl;
    }

    public void removeAllTargets() {
        this.a.removeAllElements();
    }

    public Targets[] getTargets() {
        Object[] objectArray = new Targets[this.a.size()];
        this.a.copyInto(objectArray);
        return objectArray;
    }

    public Target[] getTargetElements() {
        Object[] objectArray;
        Vector<Target> vector = new Vector<Target>();
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            Target[] targetArray = objectArray.getTargets();
            for (int i2 = 0; i2 < targetArray.length; ++i2) {
                vector.addElement(targetArray[i2]);
            }
        }
        objectArray = new Target[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public int numberOfTargets() {
        return this.a.size();
    }

    public int numberOfTargetElements() {
        return this.getTargetElements().length;
    }

    public boolean isTargetFor(Object object) throws TargetException {
        boolean bl = false;
        Target[] targetArray = this.getTargetElements();
        if (targetArray.length == 0) {
            bl = true;
        } else {
            TargetException targetException = null;
            for (int i2 = 0; i2 < targetArray.length; ++i2) {
                try {
                    if (!targetArray[i2].isTargetFor(object)) continue;
                    bl = true;
                    break;
                }
                catch (TargetException targetException2) {
                    targetException = targetException2;
                }
            }
            if (!bl && targetException != null) {
                throw targetException;
            }
        }
        return bl;
    }

    public boolean containsTargetElement(Target target) {
        boolean bl = false;
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            Targets targets = (Targets)enumeration.nextElement();
            if (!targets.containsTarget(target)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.a.isEmpty()) {
            stringBuffer.append("This TargetInformation does not contain any Targets.");
        } else {
            int n2 = this.a.size();
            if (bl) {
                stringBuffer.append("Target list contains " + n2 + " Targets object(s):\n");
                int n3 = 1;
                Enumeration enumeration = this.a.elements();
                while (enumeration.hasMoreElements()) {
                    if (n3 > 1) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append("Targets " + n3++ + ":\n");
                    Util.printIndented(((Targets)enumeration.nextElement()).toString(true), true, stringBuffer);
                }
            } else {
                stringBuffer.append("Target list contains " + n2 + " Targets object(s).");
            }
        }
        return stringBuffer.toString();
    }
}

