/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.qualified.structures.etsi;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.x509.extensions.qualified.structures.QCStatementInfo;
import java.math.BigInteger;

public class QcEuLimitValue
extends QCStatementInfo {
    public static final ObjectID statementID = ObjectID.qcEuLimitValue;
    Object a;
    int b;
    int c;

    public QcEuLimitValue() {
    }

    public QcEuLimitValue(int n2, int n3, int n4) throws IllegalArgumentException {
        if (n2 < 1 || n2 > 999) {
            throw new IllegalArgumentException("Invalid ISO 4217 curreny code. Must be between 1 .. 999.");
        }
        this.a = BigInteger.valueOf(n2);
        this.b = n3;
        this.c = n4;
    }

    public QcEuLimitValue(String string, int n2, int n3) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create QcEuLimitValue. Missing currency specification.");
        }
        if (string.length() != 3) {
            throw new IllegalArgumentException("Invalid ISO 4217 currency code");
        }
        this.a = string;
        this.b = n2;
        this.c = n3;
    }

    public ObjectID getStatementID() {
        return statementID;
    }

    public Object getCurrency() {
        return this.a;
    }

    public int getAmount() {
        return this.b;
    }

    public int getExponent() {
        return this.c;
    }

    public BigInteger getValue() {
        return BigInteger.valueOf(this.b).multiply(BigInteger.valueOf(10L).pow(this.c));
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = aSN1Object.getComponentAt(0).getValue();
        this.b = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
        this.c = ((BigInteger)aSN1Object.getComponentAt(2).getValue()).intValue();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a instanceof BigInteger) {
            sEQUENCE.addComponent(new INTEGER((BigInteger)this.a));
        } else {
            sEQUENCE.addComponent(new PrintableString((String)this.a));
        }
        sEQUENCE.addComponent(new INTEGER(this.b));
        sEQUENCE.addComponent(new INTEGER(this.c));
        return sEQUENCE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Currency: " + this.a + "\n");
        stringBuffer.append("Amount: " + this.b + "\n");
        stringBuffer.append("Exponent: " + this.c + "\n");
        return stringBuffer.toString();
    }
}

