/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.ocsp.extensions;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;

public class AcceptableResponses
extends V3Extension {
    public static final ObjectID oid = ObjectID.ocspExt_AcceptableResponses;
    private ObjectID[] a;

    public AcceptableResponses() {
    }

    public AcceptableResponses(ObjectID[] objectIDArray) {
        this.a = objectIDArray;
    }

    public void setAcceptableResponseTypes(ObjectID[] objectIDArray) {
        this.a = objectIDArray;
    }

    public ObjectID[] getAcceptableResponseTypes() {
        return this.a;
    }

    public boolean isResponseTypeAcceptable(ObjectID objectID) {
        if (this.a == null) {
            return true;
        }
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (!this.a[i2].equals(objectID)) continue;
            return true;
        }
        return false;
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        try {
            int n2 = aSN1Object.countComponents();
            this.a = new ObjectID[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                this.a[i2] = (ObjectID)aSN1Object.getComponentAt(i2);
            }
        }
        catch (CodingException codingException) {
            throw new X509ExtensionException(codingException.getMessage());
        }
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                sEQUENCE.addComponent(this.a[i2]);
            }
        }
        return sEQUENCE;
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("acceptable responses: {");
        if (this.a != null) {
            for (int i2 = 0; i2 < this.a.length; ++i2) {
                stringBuffer.append("\n  " + this.a[i2].getName());
            }
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }
}

