/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs11;

import iaik.pkcs.pkcs11.parameters.Parameters;
import iaik.pkcs.pkcs11.wrapper.Constants;
import iaik.pkcs.pkcs11.wrapper.Functions;

public class Mechanism
implements Cloneable {
    public static final Mechanism RSA_PKCS_KEY_PAIR_GEN = new Mechanism(0L);
    public static final Mechanism RSA_PKCS = new Mechanism(1L);
    public static final Mechanism RSA_9796 = new Mechanism(2L);
    public static final Mechanism RSA_X_509 = new Mechanism(3L);
    public static final Mechanism MD2_RSA_PKCS = new Mechanism(4L);
    public static final Mechanism MD5_RSA_PKCS = new Mechanism(5L);
    public static final Mechanism SHA1_RSA_PKCS = new Mechanism(6L);
    public static final Mechanism RIPEMD128_RSA_PKCS = new Mechanism(7L);
    public static final Mechanism RIPEMD160_RSA_PKCS = new Mechanism(8L);
    public static final Mechanism SHA256_RSA_PKCS = new Mechanism(64L);
    public static final Mechanism SHA384_RSA_PKCS = new Mechanism(65L);
    public static final Mechanism SHA512_RSA_PKCS = new Mechanism(66L);
    public static final Mechanism RSA_PKCS_OAEP = new Mechanism(9L);
    public static final Mechanism RSA_X9_31_KEY_PAIR_GEN = new Mechanism(10L);
    public static final Mechanism RSA_X9_31 = new Mechanism(11L);
    public static final Mechanism SHA1_RSA_X9_31 = new Mechanism(12L);
    public static final Mechanism RSA_PKCS_PSS = new Mechanism(13L);
    public static final Mechanism SHA1_RSA_PKCS_PSS = new Mechanism(14L);
    public static final Mechanism SHA256_RSA_PKCS_PSS = new Mechanism(67L);
    public static final Mechanism SHA384_RSA_PKCS_PSS = new Mechanism(68L);
    public static final Mechanism SHA512_RSA_PKCS_PSS = new Mechanism(69L);
    public static final Mechanism DSA_KEY_PAIR_GEN = new Mechanism(16L);
    public static final Mechanism DSA = new Mechanism(17L);
    public static final Mechanism DSA_SHA1 = new Mechanism(18L);
    public static final Mechanism DH_PKCS_KEY_PAIR_GEN = new Mechanism(32L);
    public static final Mechanism DH_PKCS_DERIVE = new Mechanism(33L);
    public static final Mechanism X9_42_DH_KEY_PAIR_GEN = new Mechanism(48L);
    public static final Mechanism X9_42_DH_DERIVE = new Mechanism(49L);
    public static final Mechanism X9_42_DH_HYBRID_DERIVE = new Mechanism(50L);
    public static final Mechanism X9_42_MQV_DERIVE = new Mechanism(51L);
    public static final Mechanism RC2_KEY_GEN = new Mechanism(256L);
    public static final Mechanism RC2_ECB = new Mechanism(257L);
    public static final Mechanism RC2_CBC = new Mechanism(258L);
    public static final Mechanism RC2_MAC = new Mechanism(259L);
    public static final Mechanism RC2_MAC_GENERAL = new Mechanism(260L);
    public static final Mechanism RC2_CBC_PAD = new Mechanism(261L);
    public static final Mechanism RC4_KEY_GEN = new Mechanism(272L);
    public static final Mechanism RC4 = new Mechanism(273L);
    public static final Mechanism DES_KEY_GEN = new Mechanism(288L);
    public static final Mechanism DES_ECB = new Mechanism(289L);
    public static final Mechanism DES_CBC = new Mechanism(290L);
    public static final Mechanism DES_MAC = new Mechanism(291L);
    public static final Mechanism DES_MAC_GENERAL = new Mechanism(292L);
    public static final Mechanism DES_CBC_PAD = new Mechanism(293L);
    public static final Mechanism DES_OFB64 = new Mechanism(336L);
    public static final Mechanism DES_OFB8 = new Mechanism(337L);
    public static final Mechanism DES_CFB64 = new Mechanism(338L);
    public static final Mechanism DES_CFB8 = new Mechanism(339L);
    public static final Mechanism DES2_KEY_GEN = new Mechanism(304L);
    public static final Mechanism DES3_KEY_GEN = new Mechanism(305L);
    public static final Mechanism DES3_ECB = new Mechanism(306L);
    public static final Mechanism DES3_CBC = new Mechanism(307L);
    public static final Mechanism DES3_MAC = new Mechanism(308L);
    public static final Mechanism DES3_MAC_GENERAL = new Mechanism(309L);
    public static final Mechanism DES3_CBC_PAD = new Mechanism(310L);
    public static final Mechanism CDMF_KEY_GEN = new Mechanism(320L);
    public static final Mechanism CDMF_ECB = new Mechanism(321L);
    public static final Mechanism CDMF_CBC = new Mechanism(322L);
    public static final Mechanism CDMF_MAC = new Mechanism(323L);
    public static final Mechanism CDMF_MAC_GENERAL = new Mechanism(324L);
    public static final Mechanism CDMF_CBC_PAD = new Mechanism(325L);
    public static final Mechanism MD2 = new Mechanism(512L);
    public static final Mechanism MD2_HMAC = new Mechanism(513L);
    public static final Mechanism MD2_HMAC_GENERAL = new Mechanism(514L);
    public static final Mechanism MD5 = new Mechanism(528L);
    public static final Mechanism MD5_HMAC = new Mechanism(529L);
    public static final Mechanism MD5_HMAC_GENERAL = new Mechanism(530L);
    public static final Mechanism SHA_1 = new Mechanism(544L);
    public static final Mechanism SHA_1_HMAC = new Mechanism(545L);
    public static final Mechanism SHA_1_HMAC_GENERAL = new Mechanism(546L);
    public static final Mechanism SHA256 = new Mechanism(592L);
    public static final Mechanism SHA256_HMAC = new Mechanism(593L);
    public static final Mechanism SHA256_HMAC_GENERAL = new Mechanism(594L);
    public static final Mechanism SHA384 = new Mechanism(608L);
    public static final Mechanism SHA384_HMAC = new Mechanism(609L);
    public static final Mechanism SHA384_HMAC_GENERAL = new Mechanism(610L);
    public static final Mechanism SHA512 = new Mechanism(624L);
    public static final Mechanism SHA512_HMAC = new Mechanism(625L);
    public static final Mechanism SHA512_HMAC_GENERAL = new Mechanism(626L);
    public static final Mechanism RIPEMD128 = new Mechanism(560L);
    public static final Mechanism RIPEMD128_HMAC = new Mechanism(561L);
    public static final Mechanism RIPEMD128_HMAC_GENERAL = new Mechanism(562L);
    public static final Mechanism RIPEMD160 = new Mechanism(576L);
    public static final Mechanism RIPEMD160_HMAC = new Mechanism(577L);
    public static final Mechanism RIPEMD160_HMAC_GENERAL = new Mechanism(578L);
    public static final Mechanism CAST_KEY_GEN = new Mechanism(768L);
    public static final Mechanism CAST_ECB = new Mechanism(769L);
    public static final Mechanism CAST_CBC = new Mechanism(770L);
    public static final Mechanism CAST_MAC = new Mechanism(771L);
    public static final Mechanism CAST_MAC_GENERAL = new Mechanism(772L);
    public static final Mechanism CAST_CBC_PAD = new Mechanism(773L);
    public static final Mechanism CAST3_KEY_GEN = new Mechanism(784L);
    public static final Mechanism CAST3_ECB = new Mechanism(785L);
    public static final Mechanism CAST3_CBC = new Mechanism(786L);
    public static final Mechanism CAST3_MAC = new Mechanism(787L);
    public static final Mechanism CAST3_MAC_GENERAL = new Mechanism(788L);
    public static final Mechanism CAST3_CBC_PAD = new Mechanism(789L);
    public static final Mechanism CAST5_KEY_GEN = new Mechanism(800L);
    public static final Mechanism CAST128_KEY_GEN = new Mechanism(800L);
    public static final Mechanism CAST5_ECB = new Mechanism(801L);
    public static final Mechanism CAST128_ECB = new Mechanism(801L);
    public static final Mechanism CAST5_CBC = new Mechanism(802L);
    public static final Mechanism CAST128_CBC = new Mechanism(802L);
    public static final Mechanism CAST5_MAC = new Mechanism(803L);
    public static final Mechanism CAST128_MAC = new Mechanism(803L);
    public static final Mechanism CAST5_MAC_GENERAL = new Mechanism(804L);
    public static final Mechanism CAST128_MAC_GENERAL = new Mechanism(804L);
    public static final Mechanism CAST5_CBC_PAD = new Mechanism(805L);
    public static final Mechanism CAST128_CBC_PAD = new Mechanism(805L);
    public static final Mechanism RC5_KEY_GEN = new Mechanism(816L);
    public static final Mechanism RC5_ECB = new Mechanism(817L);
    public static final Mechanism RC5_CBC = new Mechanism(818L);
    public static final Mechanism RC5_MAC = new Mechanism(819L);
    public static final Mechanism RC5_MAC_GENERAL = new Mechanism(820L);
    public static final Mechanism RC5_CBC_PAD = new Mechanism(821L);
    public static final Mechanism IDEA_KEY_GEN = new Mechanism(832L);
    public static final Mechanism IDEA_ECB = new Mechanism(833L);
    public static final Mechanism IDEA_CBC = new Mechanism(834L);
    public static final Mechanism IDEA_MAC = new Mechanism(835L);
    public static final Mechanism IDEA_MAC_GENERAL = new Mechanism(836L);
    public static final Mechanism IDEA_CBC_PAD = new Mechanism(837L);
    public static final Mechanism GENERIC_SECRET_KEY_GEN = new Mechanism(848L);
    public static final Mechanism CONCATENATE_BASE_AND_KEY = new Mechanism(864L);
    public static final Mechanism CONCATENATE_BASE_AND_DATA = new Mechanism(866L);
    public static final Mechanism CONCATENATE_DATA_AND_BASE = new Mechanism(867L);
    public static final Mechanism XOR_BASE_AND_DATA = new Mechanism(868L);
    public static final Mechanism EXTRACT_KEY_FROM_KEY = new Mechanism(869L);
    public static final Mechanism SSL3_PRE_MASTER_KEY_GEN = new Mechanism(880L);
    public static final Mechanism SSL3_MASTER_KEY_DERIVE = new Mechanism(881L);
    public static final Mechanism SSL3_KEY_AND_MAC_DERIVE = new Mechanism(882L);
    public static final Mechanism SSL3_MASTER_KEY_DERIVE_DH = new Mechanism(883L);
    public static final Mechanism TLS_PRE_MASTER_KEY_GEN = new Mechanism(884L);
    public static final Mechanism TLS_MASTER_KEY_DERIVE = new Mechanism(885L);
    public static final Mechanism TLS_KEY_AND_MAC_DERIVE = new Mechanism(886L);
    public static final Mechanism TLS_MASTER_KEY_DERIVE_DH = new Mechanism(887L);
    public static final Mechanism TLS_PRF = new Mechanism(888L);
    public static final Mechanism WTLS_PRE_MASTER_KEY_GEN = new Mechanism(976L);
    public static final Mechanism WTLS_MASTER_KEY_DERIVE = new Mechanism(977L);
    public static final Mechanism WTLS_MASTER_KEY_DERIVE_DH_ECC = new Mechanism(978L);
    public static final Mechanism WTLS_PRF = new Mechanism(979L);
    public static final Mechanism WTLS_SERVER_KEY_AND_MAC_DERIVE = new Mechanism(980L);
    public static final Mechanism WTLS_CLIENT_KEY_AND_MAC_DERIVE = new Mechanism(981L);
    public static final Mechanism SSL3_MD5_MAC = new Mechanism(896L);
    public static final Mechanism SSL3_SHA1_MAC = new Mechanism(897L);
    public static final Mechanism MD5_KEY_DERIVATION = new Mechanism(912L);
    public static final Mechanism MD2_KEY_DERIVATION = new Mechanism(913L);
    public static final Mechanism SHA1_KEY_DERIVATION = new Mechanism(914L);
    public static final Mechanism SHA256_KEY_DERIVATION = new Mechanism(915L);
    public static final Mechanism SHA384_KEY_DERIVATION = new Mechanism(916L);
    public static final Mechanism SHA512_KEY_DERIVATION = new Mechanism(917L);
    public static final Mechanism PBE_MD2_DES_CBC = new Mechanism(928L);
    public static final Mechanism PBE_MD5_DES_CBC = new Mechanism(929L);
    public static final Mechanism PBE_MD5_CAST_CBC = new Mechanism(930L);
    public static final Mechanism PBE_MD5_CAST3_CBC = new Mechanism(931L);
    public static final Mechanism PBE_MD5_CAST5_CBC = new Mechanism(932L);
    public static final Mechanism PBE_MD5_CAST128_CBC = new Mechanism(932L);
    public static final Mechanism PBE_SHA1_CAST5_CBC = new Mechanism(933L);
    public static final Mechanism PBE_SHA1_CAST128_CBC = new Mechanism(933L);
    public static final Mechanism PBE_SHA1_RC4_128 = new Mechanism(934L);
    public static final Mechanism PBE_SHA1_RC4_40 = new Mechanism(935L);
    public static final Mechanism PBE_SHA1_DES3_EDE_CBC = new Mechanism(936L);
    public static final Mechanism PBE_SHA1_DES2_EDE_CBC = new Mechanism(937L);
    public static final Mechanism PBE_SHA1_RC2_128_CBC = new Mechanism(938L);
    public static final Mechanism PBE_SHA1_RC2_40_CBC = new Mechanism(939L);
    public static final Mechanism PKCS5_PBKD2 = new Mechanism(944L);
    public static final Mechanism PBA_SHA1_WITH_SHA1_HMAC = new Mechanism(960L);
    public static final Mechanism KEY_WRAP_LYNKS = new Mechanism(1024L);
    public static final Mechanism KEY_WRAP_SET_OAEP = new Mechanism(1025L);
    public static final Mechanism SKIPJACK_KEY_GEN = new Mechanism(4096L);
    public static final Mechanism SKIPJACK_ECB64 = new Mechanism(4097L);
    public static final Mechanism SKIPJACK_CBC64 = new Mechanism(4098L);
    public static final Mechanism SKIPJACK_OFB64 = new Mechanism(4099L);
    public static final Mechanism SKIPJACK_CFB64 = new Mechanism(4100L);
    public static final Mechanism SKIPJACK_CFB32 = new Mechanism(4101L);
    public static final Mechanism SKIPJACK_CFB16 = new Mechanism(4102L);
    public static final Mechanism SKIPJACK_CFB8 = new Mechanism(4103L);
    public static final Mechanism SKIPJACK_WRAP = new Mechanism(4104L);
    public static final Mechanism SKIPJACK_PRIVATE_WRAP = new Mechanism(4105L);
    public static final Mechanism SKIPJACK_RELAYX = new Mechanism(4106L);
    public static final Mechanism KEA_KEY_PAIR_GEN = new Mechanism(4112L);
    public static final Mechanism KEA_KEY_DERIVE = new Mechanism(4113L);
    public static final Mechanism FORTEZZA_TIMESTAMP = new Mechanism(4128L);
    public static final Mechanism BATON_KEY_GEN = new Mechanism(4144L);
    public static final Mechanism BATON_ECB128 = new Mechanism(4145L);
    public static final Mechanism BATON_ECB96 = new Mechanism(4146L);
    public static final Mechanism BATON_CBC128 = new Mechanism(4147L);
    public static final Mechanism BATON_COUNTER = new Mechanism(4148L);
    public static final Mechanism BATON_SHUFFLE = new Mechanism(4149L);
    public static final Mechanism BATON_WRAP = new Mechanism(4150L);
    public static final Mechanism ECDSA_KEY_PAIR_GEN = new Mechanism(4160L);
    public static final Mechanism EC_KEY_PAIR_GEN = new Mechanism(4160L);
    public static final Mechanism ECDSA = new Mechanism(4161L);
    public static final Mechanism ECDSA_SHA1 = new Mechanism(4162L);
    public static final Mechanism ECDH1_DERIVE = new Mechanism(4176L);
    public static final Mechanism ECDH1_COFACTOR_DERIVE = new Mechanism(4177L);
    public static final Mechanism ECMQV_DERIVE = new Mechanism(4178L);
    public static final Mechanism JUNIPER_KEY_GEN = new Mechanism(4192L);
    public static final Mechanism JUNIPER_ECB128 = new Mechanism(4193L);
    public static final Mechanism JUNIPER_CBC128 = new Mechanism(4194L);
    public static final Mechanism JUNIPER_COUNTER = new Mechanism(4195L);
    public static final Mechanism JUNIPER_SHUFFLE = new Mechanism(4196L);
    public static final Mechanism JUNIPER_WRAP = new Mechanism(4197L);
    public static final Mechanism FASTHASH = new Mechanism(4208L);
    public static final Mechanism AES_KEY_GEN = new Mechanism(4224L);
    public static final Mechanism AES_ECB = new Mechanism(4225L);
    public static final Mechanism AES_CBC = new Mechanism(4226L);
    public static final Mechanism AES_MAC = new Mechanism(4227L);
    public static final Mechanism AES_MAC_GENERAL = new Mechanism(4228L);
    public static final Mechanism AES_CBC_PAD = new Mechanism(4229L);
    public static final Mechanism BLOWFISH_KEY_GEN = new Mechanism(4240L);
    public static final Mechanism BLOWFISH_CBC = new Mechanism(4241L);
    public static final Mechanism DSA_PARAMETER_GEN = new Mechanism(8192L);
    public static final Mechanism DH_PKCS_PARAMETER_GEN = new Mechanism(8193L);
    public static final Mechanism X9_42_DH_PARAMETER_GEN = new Mechanism(8194L);
    public static final Mechanism DES_ECB_ENCRYPT_DATA = new Mechanism(4352L);
    public static final Mechanism DES_CBC_ENCRYPT_DATA = new Mechanism(4353L);
    public static final Mechanism DES3_ECB_ENCRYPT_DATA = new Mechanism(4354L);
    public static final Mechanism DES3_CBC_ENCRYPT_DATA = new Mechanism(4355L);
    public static final Mechanism AES_ECB_ENCRYPT_DATA = new Mechanism(4356L);
    public static final Mechanism AES_CBC_ENCRYPT_DATA = new Mechanism(4357L);
    public static final Mechanism VENDOR_DEFINED = new Mechanism(0x80000000L);
    protected long pkcs11MechanismCode_;
    protected Parameters parameters_;

    public Mechanism(long pkcs11MechanismCode) {
        this.pkcs11MechanismCode_ = pkcs11MechanismCode;
    }

    public static Mechanism get(long pkcs11MechanismCode) {
        return new Mechanism(pkcs11MechanismCode);
    }

    public Object clone() {
        Mechanism clone = null;
        try {
            clone = (Mechanism)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public boolean equals(Object otherObject) {
        boolean euqal = false;
        if (otherObject instanceof Mechanism) {
            Mechanism other = (Mechanism)otherObject;
            euqal = this == other || this.pkcs11MechanismCode_ == other.pkcs11MechanismCode_ && (this.parameters_ == null && other.parameters_ == null || this.parameters_ != null && this.parameters_.equals(other.parameters_));
        }
        return euqal;
    }

    public int hashCode() {
        return (int)this.pkcs11MechanismCode_;
    }

    public boolean isDigestMechanism() {
        return Functions.isDigestMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isFullEncryptDecryptMechanism() {
        return Functions.isFullEncryptDecryptMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isFullSignVerifyMechanism() {
        return Functions.isFullSignVerifyMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isKeyDerivationMechanism() {
        return Functions.isKeyDerivationMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isKeyGenerationMechanism() {
        return Functions.isKeyGenerationMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isKeyPairGenerationMechanism() {
        return Functions.isKeyPairGenerationMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isSignVerifyRecoverMechanism() {
        return Functions.isSignVerifyRecoverMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isSingleOperationEncryptDecryptMechanism() {
        return Functions.isSingleOperationEncryptDecryptMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isSingleOperationSignVerifyMechanism() {
        return Functions.isSingleOperationSignVerifyMechanism(this.pkcs11MechanismCode_);
    }

    public boolean isWrapUnwrapMechanism() {
        return Functions.isWrapUnwrapMechanism(this.pkcs11MechanismCode_);
    }

    public Parameters getParameters() {
        return this.parameters_;
    }

    public void setParameters(Parameters parameters) {
        this.parameters_ = parameters;
    }

    public long getMechanismCode() {
        return this.pkcs11MechanismCode_;
    }

    public String getName() {
        return Functions.mechanismCodeToString(this.pkcs11MechanismCode_);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("  ");
        buffer.append("Mechanism: ");
        buffer.append(Functions.mechanismCodeToString(this.pkcs11MechanismCode_));
        buffer.append(Constants.NEWLINE);
        buffer.append("  ");
        buffer.append("Parameters: ");
        buffer.append(Constants.NEWLINE);
        buffer.append(this.parameters_);
        return buffer.toString();
    }
}

