/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Validate {
    private static void showHelp() {
        System.out.println("Uso:    java -jar validar.jar [--list/--xml] [documento/lista] [output-msg] [output-error]");
        System.out.println("                              [--help/--licencia]");
        System.out.println();
        System.out.println("        --help      -h                       Muestra \u00e9sta ayuda");
        System.out.println("        --licencia  -l                       Muestra la licencia del programa");
        System.out.println("        --list      -l    lista              Lista con los documentos a validar, uno debajo de otro");
        System.out.println("        --xml       -x    documento          Documento a validar");
        System.out.println();
        System.out.println("        output-msg    OPCIONAL               Documento de salida de mensajes, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("        output-error  OPCIONAL*              Documento de salida de errores, si no se especifica, se mostrar\u00e1 en pantalla");
        System.out.println("                                             *Opcional s\u00f3lo si output-msg est\u00e1 establecido");
    }

    public static void main(String[] args) throws CustomException, Exception {
        Path file;
        String outputMsg = null;
        String startup = "DS-COD versi\u00f3n 1.2.2\nDerechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\nCopyright \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\nDS-COD carece totalmente de garant\u00eda. Este es Software Libre y\nest\u00e1 permitido redistribuirlo bajo ciertas condiciones.\nAgregue \"--licencia\" al comando para m\u00e1s detalles.\n";
        System.out.println(startup);
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        if (Integer.parseInt(version) != 8) {
            System.out.println("Error: Por favor ejecute con java 8");
        }
        String licencia = " Derechos Reservados \u00a9 2017 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\n Este es un Software Libre; como tal redistribuirlo y/o modificarlo est\u00e1\n permitido, siempre y cuando se haga bajo los t\u00e9rminos y condiciones de la\n Licencia P\u00fablica General GNU publicada por la Free Software Foundation,\n ya sea en su versi\u00f3n 2 \u00f3 cualquier otra de las posteriores a la misma.\n\n Este \"Programa\" se distribuye con la intenci\u00f3n de que sea \u00fatil, sin\n embargo carece de garant\u00eda, ni siquiera tiene la garant\u00eda impl\u00edcita de\n tipo comercial o inherente al prop\u00f3sito del mismo \"Programa\". Ver la\n Licencia P\u00fablica General GNU para m\u00e1s detalles.\n\n Se debe haber recibido una copia de la Licencia P\u00fablica General GNU con\n este \"Programa\", si este no fue el caso, favor de escribir a la Free\n Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,\n MA 02110-1301 USA.\n\n Autor: Mart\u00edn Iv\u00e1n R\u00edos\n Correo electr\u00f3nico: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com\n Empresa: Grupo Sauken S.A.\n WebSite: http://www.sauken.com.ar/\n\n                                  --------------------------------------------------------------\n\n Copyright \u00a9 Mart\u00edn Iv\u00e1n R\u00edos, Grupo Sauken S.A.\n\n This program is free software; you can redistribute it and/or modify\n it under the terms of the GNU General Public License as published by\n the Free Software Foundation; either version 2 of the License, or\n (at your option) any later version.\n\n This program is distributed in the hope that it will be useful,\n but WITHOUT ANY WARRANTY; without even the implied warranty of\n MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n GNU General Public License for more details.\n\n You should have received a copy of the GNU General Public License along\n with this program; if not, write to the Free Software Foundation, Inc.,\n 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.\n\n Author: Mart\u00edn Iv\u00e1n R\u00edos\n E-mail: mailto:irios@sauken.com.ar,rios.martinivan@gmail.com\n Company: Grupo Sauken S.A.\n WebSite: http://www.sauken.com.ar/\n";
        if (args.length == 0) {
            Validate.showHelp();
            System.exit(0);
        }
        switch (args[0]) {
            case "--licencia": {
                System.out.println(licencia);
                System.exit(0);
                break;
            }
            case "-l": {
                System.out.println(licencia);
                System.exit(0);
                break;
            }
            case "-h": {
                Validate.showHelp();
                System.exit(0);
                break;
            }
            case "--help": {
                Validate.showHelp();
                System.exit(0);
            }
        }
        int codID = 0;
        int codehID = 1;
        if (args.length > 3) {
            file = Paths.get(args[3], new String[0]);
            Files.deleteIfExists(file);
            Files.createFile(file, new FileAttribute[0]);
            PrintStream err = new PrintStream(new FileOutputStream(args[3]));
            System.setErr(err);
            List<String> linesTmp = Collections.singletonList("####");
            Files.write(file, linesTmp, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            System.out.println("Errores en " + args[3]);
        }
        if (args.length > 2) {
            outputMsg = args[2];
            file = Paths.get(outputMsg, new String[0]);
            Files.deleteIfExists(file);
            Files.createFile(file, new FileAttribute[0]);
            List<String> lines = Collections.singletonList("####");
            Files.write(file, lines, Charset.forName("UTF-8"), new OpenOption[0]);
            System.out.println("Salida en " + args[2]);
        }
        switch (args[0]) {
            case "--list": {
                String[] arr;
                if (!args[1].contains(".txt")) {
                    throw new CustomException("#### \n" + args[1] + " no es una lista valida");
                }
                Scanner sc = new Scanner(new File(args[1]));
                ArrayList<String> docLines = new ArrayList<String>();
                while (sc.hasNextLine()) {
                    docLines.add(sc.nextLine());
                }
                for (String docPath : arr = docLines.toArray(new String[0])) {
                    File f = new File(docPath);
                    String docName = f.getName();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    Document doc = dbf.newDocumentBuilder().parse(new FileInputStream(docPath));
                    boolean verifiedCOD = Validate.verifySignature(doc, docName, codID, outputMsg);
                    if (!verifiedCOD) continue;
                    Validate.verifySignature(doc, docName, codehID, outputMsg);
                }
                break;
            }
            case "-l": {
                String[] arr2;
                if (!args[1].contains(".txt")) {
                    throw new CustomException("#### \n" + args[1] + " no es una lista valida");
                }
                Scanner sc2 = new Scanner(new File(args[1]));
                ArrayList<String> docLines2 = new ArrayList<String>();
                while (sc2.hasNextLine()) {
                    docLines2.add(sc2.nextLine());
                }
                for (String docPath : arr2 = docLines2.toArray(new String[0])) {
                    File f = new File(docPath);
                    String docName = f.getName();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    Document doc = dbf.newDocumentBuilder().parse(new FileInputStream(docPath));
                    boolean verifiedCOD = Validate.verifySignature(doc, docName, codID, outputMsg);
                    if (!verifiedCOD) continue;
                    Validate.verifySignature(doc, docName, codehID, outputMsg);
                }
                break;
            }
            case "--xml": {
                if (!args[1].contains(".xml")) {
                    throw new CustomException("#### \n" + args[1] + " no es un xml valido");
                }
                File f = new File(args[1]);
                String docName = f.getName();
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                Document doc = dbf.newDocumentBuilder().parse(new FileInputStream(args[1]));
                boolean verifiedCOD = Validate.verifySignature(doc, docName, codID, outputMsg);
                if (!verifiedCOD) break;
                Validate.verifySignature(doc, docName, codehID, outputMsg);
                break;
            }
            case "-x": {
                if (!args[1].contains(".xml")) {
                    throw new CustomException("#### \n" + args[1] + " no es un xml valido");
                }
                File f2 = new File(args[1]);
                String docName2 = f2.getName();
                DocumentBuilderFactory dbf2 = DocumentBuilderFactory.newInstance();
                dbf2.setNamespaceAware(true);
                Document doc2 = dbf2.newDocumentBuilder().parse(new FileInputStream(args[1]));
                boolean verifiedCOD2 = Validate.verifySignature(doc2, docName2, codID, outputMsg);
                if (!verifiedCOD2) break;
                Validate.verifySignature(doc2, docName2, codehID, outputMsg);
                break;
            }
            default: {
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList("Por favor, use las opciones \"--list\" o \"--xml\" solamente");
                    Path file2 = Paths.get(outputMsg, new String[0]);
                    Files.write(file2, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                    break;
                }
                System.out.println("Por favor, use las opciones \"--list\" o \"--xml\" solamente");
            }
        }
    }

    private static String getExecutionPath(Class c) {
        URL rootPath = c.getProtectionDomain().getCodeSource().getLocation();
        String URI2 = rootPath.toString().substring(6);
        String[] currentPath = URI2.split("validar.jar");
        currentPath[0] = currentPath[0].replaceAll("%20", " ");
        return currentPath[0];
    }

    private static boolean verifySignature(Document doc, String docName, int id, String outputMsg) throws Exception {
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": No se puede encontrar la firma");
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": No se puede encontrar la firma");
            }
            return false;
        }
        if (id == 1 && nl.getLength() < 2) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": CODEH no firmado");
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": CODEH no firmado");
            }
            return false;
        }
        Element nodeElement = (Element)nl.item(id);
        NodeList sigInfo = nodeElement.getElementsByTagName("ds:SignedInfo");
        Element sigElement = (Element)sigInfo.item(0);
        NodeList referenceURI = sigElement.getElementsByTagName("ds:Reference");
        Element referenceElement = (Element)referenceURI.item(0);
        String URI2 = referenceElement.getAttributes().getNamedItem("URI").getNodeValue();
        NodeList keyInfo = nodeElement.getElementsByTagName("ds:KeyInfo");
        Element keyElement = (Element)keyInfo.item(0);
        NodeList keyData = keyElement.getElementsByTagName("ds:X509Data");
        Element keyDataElement = (Element)keyData.item(0);
        NodeList certificate = keyDataElement.getElementsByTagName("ds:X509Certificate");
        Element certificateElement = (Element)certificate.item(0);
        String certElm = certificateElement.getTextContent();
        String pemCert = "-----BEGIN CERTIFICATE-----\n" + certElm + "\n-----END CERTIFICATE-----";
        String i = id == 0 ? "cod" : "codeh";
        String pem = Validate.getExecutionPath(Validate.class) + "temp-xml-" + i + ".pem";
        Path pemPath = Paths.get(pem, new String[0]);
        Files.deleteIfExists(pemPath);
        Files.createFile(pemPath, new FileAttribute[0]);
        List<String> pemLines = Collections.singletonList(pemCert);
        Files.write(pemPath, pemLines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
        XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (URI2 != null && URI2.equals("#COD")) {
            XPathExpression exprCOD = xpath.compile(String.format("//*[@id='%s']", "COD"));
            NodeList nodesCOD = (NodeList)exprCOD.evaluate(doc, XPathConstants.NODESET);
            Node nodeCOD = nodesCOD.item(0);
            ((Element)nodeCOD).setIdAttribute("id", true);
        } else if (URI2 != null && URI2.equals("#CODEH")) {
            XPathExpression exprCODEH = xpath.compile(String.format("//*[@id='%s']", "CODEH"));
            NodeList nodesCODEH = (NodeList)exprCODEH.evaluate(doc, XPathConstants.NODESET);
            Node nodeCODEH = nodesCODEH.item(0);
            ((Element)nodeCODEH).setIdAttribute("id", true);
        }
        DOMValidateContext valContext = new DOMValidateContext(new KeyValueKeySelector(), nl.item(id));
        XMLSignature signature = fac.unmarshalXMLSignature(valContext);
        boolean coreValidity = signature.validate(valContext);
        if (!coreValidity) {
            if (id == 0) {
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": La firma en COD ha fallado la verificaci\u00f3n base");
                    Path file = Paths.get(outputMsg, new String[0]);
                    Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": La firma en COD ha fallado la verificaci\u00f3n base");
                }
                boolean sv = signature.getSignatureValue().validate(valContext);
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": Estado de validez del COD: " + sv);
                    Path path = Paths.get(outputMsg, new String[0]);
                    Files.write(path, (Iterable<? extends CharSequence>)lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": Estado de validez : " + sv);
                }
                for (Object e : signature.getSignedInfo().getReferences()) {
                    boolean refValid = ((Reference)e).validate(valContext);
                    if (outputMsg != null) {
                        List<String> lines = Collections.singletonList(docName + ": Estado de validez del COD: " + refValid);
                        Path file = Paths.get(outputMsg, new String[0]);
                        Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                        continue;
                    }
                    System.out.println(docName + ": Estado de validez del COD: " + refValid);
                }
            } else if (id == 1) {
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": La firma en CODEH ha fallado la verificaci\u00f3n base");
                    Path file = Paths.get(outputMsg, new String[0]);
                    Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": La firma en CODEH ha fallado la verificaci\u00f3n base");
                }
                boolean sv = signature.getSignatureValue().validate(valContext);
                if (outputMsg != null) {
                    List<String> lines = Collections.singletonList(docName + ": Estado de validez del CODEH: " + sv);
                    Path path = Paths.get(outputMsg, new String[0]);
                    Files.write(path, (Iterable<? extends CharSequence>)lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": Estado de validez : " + sv);
                }
                for (Object e : signature.getSignedInfo().getReferences()) {
                    boolean refValid = ((Reference)e).validate(valContext);
                    if (outputMsg != null) {
                        List<String> lines = Collections.singletonList(docName + ": Estado de validez del CODEH: " + refValid);
                        Path file = Paths.get(outputMsg, new String[0]);
                        Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                        continue;
                    }
                    System.out.println(docName + ": Estado de validez del CODEH: " + refValid);
                }
            }
            return false;
        }
        if (id == 0) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": La firma en COD ha pasado la verificaci\u00f3n base");
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": La firma en COD ha pasado la verificaci\u00f3n base");
            }
            Validate.checkCertValidity(outputMsg, pem, docName, id);
        } else if (id == 1) {
            if (outputMsg != null) {
                List<String> lines = Collections.singletonList(docName + ": La firma en CODEH ha pasado la verificaci\u00f3n base");
                Path file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": La firma en CODEH ha pasado la verificaci\u00f3n base");
            }
            Validate.checkCertValidity(outputMsg, pem, docName, id);
        }
        return true;
    }

    private static void checkCertValidity(String outputMsg, String pem, String docName, int id) throws CertificateException, IOException, CRLException {
        Path file;
        List<String> lines;
        String i = id == 0 ? "COD" : "CODEH";
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream(pem);
        X509Certificate cert = (X509Certificate)fact.generateCertificate(is);
        String cn = cert.getIssuerX500Principal().toString().split("CN=")[1].split(",")[0];
        try {
            cert.checkValidity();
            if (outputMsg != null) {
                List<String> lines2 = Collections.singletonList(docName + ": El certificado de la firma en " + i + " es v\u00e1lido actualmente");
                Path file2 = Paths.get(outputMsg, new String[0]);
                Files.write(file2, lines2, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": El certificado de la firma en " + i + " es v\u00e1lido actualmente");
            }
        }
        catch (CertificateExpiredException e) {
            if (outputMsg != null) {
                lines = Collections.singletonList(docName + ": El certificado de la firma en " + i + " ha expirado");
                file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": El certificado de la firma en " + i + " ha expirado");
            }
        }
        catch (CertificateNotYetValidException e) {
            if (outputMsg != null) {
                lines = Collections.singletonList(docName + ": El certificado de la firma en " + i + " todab\u00eda no es v\u00e1lido");
                file = Paths.get(outputMsg, new String[0]);
                Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            }
            System.out.println(docName + ": El certificado de la firma en " + i + " todab\u00eda no es v\u00e1lido");
        }
        String certString = cert.toString();
        if (certString.contains("CRLDistributionPoints")) {
            List<String> lines3;
            String[] tmp = certString.split("CRLDistributionPoints \\[");
            String[] parts = tmp[1].split("]]");
            String[] distPoints = parts[0].substring(4, parts[0].length() - 1).split(",");
            boolean noInternetError = false;
            boolean revoked = false;
            ArrayList<String> urlList = new ArrayList<String>();
            for (String tempDist : distPoints) {
                X509CRL crl;
                String url;
                String[] tmpUrl = tempDist.split("\\[URIName: ");
                try {
                    url = tmpUrl[1].substring(0, tmpUrl[1].length() - 1).replaceAll("]", "");
                }
                catch (Exception ignored) {
                    url = tmpUrl[0].replaceAll("]", "");
                }
                if (!url.substring(url.length() - 3).equals("crl")) {
                    url = tmpUrl[1].replaceAll("]", "");
                }
                url = url.replace("URIName: ", "");
                url = url.replace("URIName:", "");
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                try {
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                }
                catch (Exception sc) {
                    // empty catch block
                }
                URL crlUrl = new URL(url);
                HttpURLConnection connection = (HttpURLConnection)crlUrl.openConnection();
                connection.connect();
                try {
                    String tmp2;
                    if (connection.getResponseCode() == 301) {
                        connection = (HttpURLConnection)new URL(connection.getHeaderField("Location")).openConnection();
                    }
                    StringBuilder inputLine = new StringBuilder();
                    DataInputStream inStream = new DataInputStream(connection.getInputStream());
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inStream));
                    int i2 = 0;
                    while ((tmp2 = bufferedReader.readLine()) != null) {
                        if (i2 > 20) {
                            i2 = 0;
                            break;
                        }
                        inputLine.append(tmp2);
                        ++i2;
                    }
                    bufferedReader.close();
                    inStream.close();
                    if (i2 > 0 && inputLine.toString().contains(".assign(\"")) {
                        String[] a = inputLine.toString().split(Pattern.quote(".assign(\""));
                        String finalStr = a[1].split(Pattern.quote("\");"))[0];
                        connection = (HttpURLConnection)new URL(finalStr).openConnection();
                    } else {
                        connection.disconnect();
                        connection = (HttpURLConnection)crlUrl.openConnection();
                        if (connection.getResponseCode() == 301) {
                            connection = (HttpURLConnection)new URL(connection.getHeaderField("Location")).openConnection();
                        }
                    }
                    inStream = new DataInputStream(connection.getInputStream());
                    crl = (X509CRL)fact.generateCRL(inStream);
                }
                catch (UnknownHostException e) {
                    noInternetError = true;
                    break;
                }
                X509CRLEntry revokedCertificate = crl.getRevokedCertificate(cert.getSerialNumber());
                if (revokedCertificate != null) {
                    revoked = true;
                }
                urlList.add(url);
            }
            String parsedUrlList = "";
            for (String url : urlList) {
                if (parsedUrlList.equals("")) {
                    parsedUrlList = url;
                    continue;
                }
                parsedUrlList = parsedUrlList + ", " + url;
            }
            if (noInternetError) {
                if (outputMsg != null) {
                    lines3 = Collections.singletonList(docName + ": No es posible validar contra AC del certificado de la firma en " + i + ", no hay conneci\u00f3n a internet");
                    Path file3 = Paths.get(outputMsg, new String[0]);
                    Files.write(file3, lines3, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": No es posible validar contra AC del certificado de la firma en " + i + ", no hay conneci\u00f3n a internet");
                }
                return;
            }
            if (revoked) {
                if (outputMsg != null) {
                    lines3 = Collections.singletonList(docName + ": El certificado de la firma en " + i + " est\u00e1 actualmente revocado, contra la AC: " + cn);
                    Path file4 = Paths.get(outputMsg, new String[0]);
                    Files.write(file4, lines3, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
                } else {
                    System.out.println(docName + ": El certificado de la firma en " + i + " est\u00e1 actualmente revocado, contra la AC: " + cn);
                }
            } else if (outputMsg != null) {
                lines3 = Collections.singletonList(docName + ": El certificado de la firma en " + i + " es actualmente v\u00e1lido, contra la AC: " + cn);
                Path file5 = Paths.get(outputMsg, new String[0]);
                Files.write(file5, lines3, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": El certificado de la firma en " + i + " es actualmente v\u00e1lido, contra la AC: " + cn);
            }
            if (outputMsg != null) {
                lines3 = Collections.singletonList(docName + ": Revoked list urls: " + parsedUrlList);
                Path file6 = Paths.get(outputMsg, new String[0]);
                Files.write(file6, lines3, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
            } else {
                System.out.println(docName + ": URLs de las listas de revocados: " + parsedUrlList);
            }
        } else if (outputMsg != null) {
            lines = Collections.singletonList(docName + ": No pudo validarse si la firma esta revocada");
            file = Paths.get(outputMsg, new String[0]);
            Files.write(file, lines, Charset.forName("UTF-8"), StandardOpenOption.APPEND);
        } else {
            System.out.println(docName + ": No pudo validarse si la firma esta revocada");
        }
    }

    public static class CustomException
    extends Throwable {
        @Override
        public String toString() {
            String s = this.getClass().getName();
            String message = this.getLocalizedMessage();
            return message != null ? message : s;
        }

        CustomException(String message) {
            super(message, null, true, false);
        }
    }

    private static class SimpleKeySelectorResult
    implements KeySelectorResult {
        private PublicKey pk;

        SimpleKeySelectorResult(PublicKey pk) {
            this.pk = pk;
        }

        @Override
        public Key getKey() {
            return this.pk;
        }
    }

    private static class KeyValueKeySelector
    extends KeySelector {
        private KeyValueKeySelector() {
        }

        @Override
        public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
            if (keyInfo == null) {
                throw new KeySelectorException("#### \nEl objeto KeyInfo no existe!");
            }
            SignatureMethod sm = (SignatureMethod)method;
            List<XMLStructure> list = keyInfo.getContent();
            for (XMLStructure aList : list) {
                PublicKey pk;
                List<?> l;
                XMLStructure xmlStructure = aList;
                if (xmlStructure instanceof X509Data && (l = ((X509Data)xmlStructure).getContent()).size() > 0) {
                    X509Certificate cert = (X509Certificate)l.get(0);
                    pk = cert.getPublicKey();
                    if (this.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) {
                        return new SimpleKeySelectorResult(pk);
                    }
                }
                if (!(xmlStructure instanceof KeyValue)) continue;
                pk = null;
                try {
                    pk = ((KeyValue)xmlStructure).getPublicKey();
                }
                catch (KeyException keyException) {
                    // empty catch block
                }
                assert (pk != null);
                if (!this.algEquals(sm.getAlgorithm(), pk.getAlgorithm())) continue;
                return new SimpleKeySelectorResult(pk);
            }
            throw new KeySelectorException("#### \nKeyValue no encontrado!");
        }

        boolean algEquals(String algURI, String algName) {
            return algName.equalsIgnoreCase("DSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || algName.equalsIgnoreCase("RSA") && algURI.equalsIgnoreCase("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        }
    }
}

