/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.cipher;

import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.xml.crypto.alg.cipher.ProxyCipher;
import java.io.ByteArrayOutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class AESKWProxyCipher
extends ProxyCipher {
    public static final byte[] NIST_KEY_WRAP_IV = new byte[]{-90, -90, -90, -90, -90, -90, -90, -90};
    protected ByteArrayOutputStream buffer_ = new ByteArrayOutputStream();
    protected int opmode_;

    protected String getCipherName() {
        return "AES/ECB/NoPadding";
    }

    protected void engineInit(int n2, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        switch (n2) {
            case 4: {
                this.opmode_ = 2;
                break;
            }
            case 3: {
                this.opmode_ = 1;
                break;
            }
            default: {
                this.opmode_ = n2;
            }
        }
        super.engineInit(this.opmode_, key, algorithmParameters, secureRandom);
    }

    protected void engineInit(int n2, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        switch (n2) {
            case 4: {
                this.opmode_ = 2;
                break;
            }
            case 3: {
                this.opmode_ = 1;
                break;
            }
            default: {
                this.opmode_ = n2;
            }
        }
        super.engineInit(this.opmode_, key, algorithmParameterSpec, secureRandom);
    }

    protected void engineInit(int n2, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        switch (n2) {
            case 4: {
                this.opmode_ = 2;
                break;
            }
            case 3: {
                this.opmode_ = 1;
                break;
            }
            default: {
                this.opmode_ = n2;
            }
        }
        super.engineInit(this.opmode_, key, secureRandom);
    }

    protected Key engineUnwrap(byte[] byArray, String string, int n2) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] byArray2;
        try {
            byArray2 = this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
        return Util.decodeKey((int)n2, (String)string, (byte[])byArray2);
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] byArray = key.getEncoded();
        try {
            return this.engineDoFinal(byArray, 0, byArray.length);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            throw new InvalidKeyException(illegalBlockSizeException.getMessage());
        }
        catch (BadPaddingException badPaddingException) {
            throw new InvalidKeyException(badPaddingException.getMessage());
        }
    }

    protected byte[] engineUpdate(byte[] byArray, int n2, int n3) {
        this.buffer_.write(byArray, n2, n3);
        return null;
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException {
        this.buffer_.write(byArray, n2, n3);
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] engineDoFinal(byte[] byArray, int n2, int n3) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2;
        if (this.buffer_.size() == 0) {
            if (n2 == 0 && n3 == byArray.length) {
                byArray2 = byArray;
            } else {
                byArray2 = new byte[n3];
                System.arraycopy(byArray, n2, byArray2, 0, n3);
            }
        } else {
            this.buffer_.write(byArray, n2, n3);
            byArray2 = this.buffer_.toByteArray();
            this.buffer_.reset();
        }
        if (byArray == null) throw new IllegalBlockSizeException();
        if (byArray.length % 8 != 0) {
            throw new IllegalBlockSizeException();
        }
        if (this.opmode_ == 1 || this.opmode_ == 3) {
            int n4;
            byte[] byArray3 = new byte[8];
            byte[] byArray4 = new byte[16];
            int n5 = byArray2.length / 8;
            int n6 = 6 * n5;
            byte[][] byArray5 = new byte[n5][8];
            if (byArray2.length == 8) {
                System.arraycopy(NIST_KEY_WRAP_IV, 0, byArray4, 0, NIST_KEY_WRAP_IV.length);
                System.arraycopy(byArray2, 0, byArray4, NIST_KEY_WRAP_IV.length, byArray2.length);
                return this.cipher_.doFinal(byArray4);
            }
            System.arraycopy(NIST_KEY_WRAP_IV, 0, byArray3, 0, NIST_KEY_WRAP_IV.length);
            for (n4 = 0; n4 < n5; ++n4) {
                System.arraycopy(byArray2, n4 * 8, byArray5[n4], 0, 8);
            }
            for (n4 = 0; n4 < 6; ++n4) {
                for (int i2 = 1; i2 <= n5; ++i2) {
                    int n7 = i2 + n4 * n5;
                    int[] nArray = new int[]{0, n7};
                    byte[] byArray6 = new byte[8];
                    CryptoUtils.spreadIntsToBytes((int[])nArray, (int)0, (byte[])byArray6, (int)0, (int)2);
                    byte[] byArray7 = new byte[16];
                    System.arraycopy(byArray3, 0, byArray7, 0, byArray3.length);
                    System.arraycopy(byArray5[i2 - 1], 0, byArray7, byArray3.length, byArray5[i2 - 1].length);
                    byArray4 = this.cipher_.doFinal(byArray7);
                    byte[] byArray8 = new byte[8];
                    byte[] byArray9 = new byte[8];
                    System.arraycopy(byArray4, 0, byArray8, 0, 8);
                    CryptoUtils.xorBlock((byte[])byArray6, (byte[])byArray8, (byte[])byArray3);
                    System.arraycopy(byArray4, 8, byArray5[i2 - 1], 0, 8);
                }
            }
            byte[] byArray10 = new byte[8 * (n5 + 1)];
            System.arraycopy(byArray3, 0, byArray10, 0, 8);
            n4 = 0;
            while (n4 < n5) {
                System.arraycopy(byArray5[n4], 0, byArray10, 8 * (n4 + 1), 8);
                ++n4;
            }
            return byArray10;
        }
        byte[] byArray11 = null;
        Object var6_6 = null;
        byte[] byArray12 = new byte[8];
        byte[] byArray13 = new byte[16];
        int n8 = byArray2.length / 8 - 1;
        byte[][] byArray14 = new byte[n8][8];
        byArray11 = new byte[n8 * 8];
        if (byArray2.length != 16) {
            int n9;
            System.arraycopy(byArray2, 0, byArray12, 0, 8);
            for (n9 = 0; n9 < n8; ++n9) {
                System.arraycopy(byArray2, 8 * (n9 + 1), byArray14[n9], 0, 8);
            }
            for (n9 = 5; n9 >= 0; --n9) {
                for (int i3 = n8; i3 > 0; --i3) {
                    int n10 = i3 + n9 * n8;
                    int[] nArray = new int[]{0, n10};
                    byte[] byArray15 = new byte[8];
                    CryptoUtils.spreadIntsToBytes((int[])nArray, (int)0, (byte[])byArray15, (int)0, (int)2);
                    byte[] byArray16 = new byte[8];
                    CryptoUtils.xorBlock((byte[])byArray15, (byte[])byArray12, (byte[])byArray16);
                    byte[] byArray17 = new byte[16];
                    System.arraycopy(byArray16, 0, byArray17, 0, 8);
                    System.arraycopy(byArray14[i3 - 1], 0, byArray17, 8, 8);
                    byArray13 = this.cipher_.doFinal(byArray17);
                    System.arraycopy(byArray13, 0, byArray12, 0, 8);
                    System.arraycopy(byArray13, 8, byArray14[i3 - 1], 0, 8);
                }
            }
            if (CryptoUtils.compareBlock((byte[])byArray12, (byte[])NIST_KEY_WRAP_IV) >= 0) throw new BadPaddingException();
            n9 = 0;
            while (n9 < n8) {
                System.arraycopy(byArray14[n9], 0, byArray11, 8 * n9, 8);
                ++n9;
            }
            return byArray11;
        }
        byArray13 = this.cipher_.doFinal(byArray2);
        if (CryptoUtils.compareBlock((byte[])byArray13, (int)0, (byte[])NIST_KEY_WRAP_IV, (int)0, (int)8) >= 0) throw new BadPaddingException();
        System.arraycopy(byArray13, 8, byArray11, 0, 8);
        return byArray11;
    }

    protected int engineDoFinal(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n2, n3);
        if (byArray3 == null) {
            return 0;
        }
        if (byArray3.length > byArray2.length - n4) {
            throw new ShortBufferException();
        }
        System.arraycopy(byArray3, 0, byArray2, n4, byArray3.length);
        return byArray3.length;
    }

    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SecretKey) {
            return key.getEncoded().length << 3;
        }
        throw new InvalidKeyException("Not a AES key.");
    }
}

