/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.keyfactory;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.alg.keyfactory.a;
import iaik.xml.crypto.alg.keyfactory.b;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyFactorySpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;

public abstract class ProxyKeyFactory
extends KeyFactorySpi {
    protected KeyFactory keyfac_;

    public ProxyKeyFactory() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (!XSecProvider.lateAlgorithmProxyInstantiation()) {
            this.getInstanceUncaught(null);
        }
    }

    protected void getInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException, NoSuchProviderException {
        String string = this.getKeyFactoryName();
        Provider provider = XSecProvider.getDelegationProvider("KeyFactory." + string, purpose);
        if (provider != null) {
            try {
                this.keyfac_ = KeyFactory.getInstance(string, provider);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                this.keyfac_ = KeyFactory.getInstance(string, provider.getName());
            }
        }
        if (this.keyfac_ == null) {
            this.keyfac_ = KeyFactory.getInstance(string);
        }
    }

    protected void getInstance(XSecProvider.Purpose purpose) {
        if (this.keyfac_ != null) {
            return;
        }
        try {
            this.getInstanceUncaught(purpose);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new a(this, "Delegation provider not registered, any more.", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new b(this, noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    protected abstract String getKeyFactoryName();

    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.keyfac_ == null) {
            this.getInstance(null);
        }
        return this.keyfac_.generatePublic(keySpec);
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (this.keyfac_ == null) {
            this.getInstance(null);
        }
        return this.keyfac_.generatePrivate(keySpec);
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        if (this.keyfac_ == null) {
            this.getInstance(null);
        }
        return this.keyfac_.getKeySpec(key, clazz);
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        if (this.keyfac_ == null) {
            this.getInstance(null);
        }
        return this.keyfac_.translateKey(key);
    }
}

