/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.alg.signature;

import iaik.asn1.ASN1;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.SEQUENCE;
import iaik.xml.crypto.alg.signature.ProxySignature;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.util.Arrays;

public class DSASHA1ProxySignature
extends ProxySignature {
    protected String getSignatureName() {
        return "DSA";
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        byte[] byArray2;
        if (byArray.length != 40) {
            throw new SignatureException("Specified signature does not consist of exactly 40 bytes.");
        }
        byte[] byArray3 = new byte[21];
        byte[] byArray4 = new byte[21];
        System.arraycopy(byArray, 0, byArray3, 1, 20);
        System.arraycopy(byArray, 20, byArray4, 1, 20);
        BigInteger bigInteger = new BigInteger(byArray3);
        BigInteger bigInteger2 = new BigInteger(byArray4);
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent((ASN1Object)new INTEGER(bigInteger));
        sEQUENCE.addComponent((ASN1Object)new INTEGER(bigInteger2));
        try {
            byArray2 = new ASN1((ASN1Object)sEQUENCE).toByteArray();
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.getMessage());
        }
        return super.engineVerify(byArray2);
    }

    protected byte[] engineSign() throws SignatureException {
        INTEGER iNTEGER;
        INTEGER iNTEGER2;
        Object object;
        byte[] byArray = super.engineSign();
        try {
            object = new ASN1(byArray);
            iNTEGER2 = (INTEGER)object.getComponentAt(0);
            iNTEGER = (INTEGER)object.getComponentAt(1);
        }
        catch (CodingException codingException) {
            throw new SignatureException(codingException.getMessage());
        }
        object = ((BigInteger)iNTEGER2.getValue()).toByteArray();
        byte[] byArray2 = ((BigInteger)iNTEGER.getValue()).toByteArray();
        byte[] byArray3 = this.removeSignumAndAlign20((byte[])object);
        byte[] byArray4 = this.removeSignumAndAlign20(byArray2);
        byte[] byArray5 = new byte[40];
        System.arraycopy(byArray3, 0, byArray5, 0, 20);
        System.arraycopy(byArray4, 0, byArray5, 20, 20);
        return byArray5;
    }

    protected byte[] removeSignumAndAlign20(byte[] byArray) {
        byte[] byArray2 = new byte[20];
        Arrays.fill(byArray2, (byte)0);
        if (byArray.length == 21) {
            System.arraycopy(byArray, 1, byArray2, 0, 20);
        } else {
            System.arraycopy(byArray, 0, byArray2, 20 - byArray.length, byArray.length);
        }
        return byArray2;
    }
}

