/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.dsig.TransformImpl;
import iaik.xml.crypto.dsig.d;
import iaik.xml.crypto.dsig.e;
import iaik.xml.crypto.dsig.f;
import iaik.xml.crypto.dsig.g;
import iaik.xml.crypto.utils.URI;
import iaik.xml.crypto.utils.URIException;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import org.w3c.dom.Node;

public class CanonicalizationMethodImpl
extends TransformImpl
implements CanonicalizationMethod {
    public static final String C14n11_INCLUSIVE = "http://www.w3.org/2006/12/xml-c14n11";
    public static final String C14n11_INCLUSIVE_WITH_COMMENTS = "http://www.w3.org/2006/12/xml-c14n11#WithComments";

    public CanonicalizationMethodImpl(String string, TransformParameterSpec transformParameterSpec, Provider provider) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (string == null) {
            throw new NullPointerException("Argument 'algorithm' must not be null.");
        }
        try {
            this.algorithm_ = new URI(string);
        }
        catch (URIException uRIException) {
            throw new NoSuchAlgorithmException("Algorithm URI '" + string + "' is not RFC 2396 compliant.");
        }
        if (provider == null) {
            provider = XSecProvider.getDelegationProvider("TransformService." + this.algorithm_.toString(), null);
        }
        if (provider != null) {
            try {
                this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM", provider);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                try {
                    this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM", provider.getName());
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new d(this, noSuchProviderException);
                }
            }
        } else {
            this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM");
        }
        this.service_.init(transformParameterSpec);
    }

    public CanonicalizationMethodImpl(String string, TransformParameterSpec transformParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        this(string, transformParameterSpec, null);
    }

    public CanonicalizationMethodImpl(String string, DOMStructure dOMStructure) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(string, dOMStructure);
        if (!(this.service_ instanceof CanonicalizationMethod)) {
            throw new NoSuchAlgorithmException("Cannot find algorithm '" + this.algorithm_.toString() + "' for mechanism type 'DOM'.");
        }
    }

    public CanonicalizationMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        try {
            Provider provider = XSecProvider.getDelegationProvider("TransformService." + this.algorithm_.toString(), null);
            if (provider != null) {
                try {
                    this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM", provider);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    try {
                        this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM", provider.getName());
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        throw new e(this, noSuchProviderException);
                    }
                }
            } else {
                this.service_ = TransformService.getInstance(this.algorithm_.toString(), "DOM");
            }
            this.service_.init(this, dOMCryptoContext);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new f(this, noSuchAlgorithmException, noSuchAlgorithmException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new g(this, invalidAlgorithmParameterException, invalidAlgorithmParameterException);
        }
    }

    public String getLocalName() {
        return "CanonicalizationMethod";
    }
}

