/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dsig.DigestMethodImpl;
import iaik.xml.crypto.dsig.DigestValueImpl;
import iaik.xml.crypto.utils.DOMUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.w3c.dom.Node;

public abstract class DigestAlgAndValueType
extends DOMStructure {
    protected DigestMethodImpl digestMethod_;
    protected DigestValueImpl digestValue_;

    protected DigestAlgAndValueType(Node node) throws MarshalException {
        super(node);
    }

    protected DigestAlgAndValueType(DigestMethodImpl digestMethodImpl) {
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null");
        }
        this.digestMethod_ = digestMethodImpl;
        this.digestValue_ = new DigestValueImpl();
    }

    protected DigestAlgAndValueType(DigestMethodImpl digestMethodImpl, byte[] byArray) {
        if (digestMethodImpl == null) {
            throw new NullPointerException("Argument 'digestMethod' must not be null");
        }
        this.digestMethod_ = digestMethodImpl;
        if (byArray == null) {
            throw new NullPointerException("Argument 'digestValue' must not be null");
        }
        this.digestValue_ = new DigestValueImpl(byArray);
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod_;
    }

    public byte[] getDigestValue() {
        return this.digestValue_ != null ? this.digestValue_.getDigestValue() : null;
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        if (this.digestMethod_ != null) {
            list.add(this.digestMethod_);
        }
        if (this.digestValue_ != null) {
            list.add(this.digestValue_);
        }
        return list;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof DigestMethod) {
            this.digestMethod_ = (DigestMethodImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof DigestValueImpl) {
            this.digestValue_ = (DigestValueImpl)dOMStructure;
            return;
        }
    }

    public byte[] calculateDigestValue(InputStream inputStream, XMLCryptoContext xMLCryptoContext) throws XMLSignatureException, IOException {
        return this.digestMethod_.calculateDigestValue(inputStream);
    }

    public void calculateAndAppendDigestValue(DOMCryptoContext dOMCryptoContext, InputStream inputStream) throws MarshalException, XMLSignatureException, IOException {
        if (this.digestValue_.getDigestValue() == null) {
            byte[] byArray = this.calculateDigestValue(inputStream, dOMCryptoContext);
            this.digestValue_.appendValue(dOMCryptoContext, byArray);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("  " + this.getLocalName() + ":\n");
        stringBuffer.append("    DigestMethod : " + this.getDigestMethod().getAlgorithm() + "\n");
        stringBuffer.append("    DigestValue : ");
        try {
            stringBuffer.append(DOMUtils.bytesToBase64String(this.getDigestValue(), new byte[0]) + "\n");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            stringBuffer.append(iOException);
        }
        return stringBuffer.toString();
    }
}

