/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.alg.NoSuchAlgorithmRuntimeException;
import iaik.xml.crypto.dsig.AlgorithmMethodImpl;
import iaik.xml.crypto.dsig.h;
import iaik.xml.crypto.dsig.i;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidParameterSpecException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.spec.DigestMethodParameterSpec;
import org.w3c.dom.Node;

public class DigestMethodImpl
extends AlgorithmMethodImpl
implements DigestMethod {
    protected MessageDigest digest_;
    static Class h;

    public DigestMethodImpl(String string, DigestMethodParameterSpec digestMethodParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(string, digestMethodParameterSpec);
        if (!XSecProvider.lateAlgorithmInstantiation()) {
            this.getAlgorithmInstanceUncaught(null);
        }
    }

    public DigestMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null.");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.algorithm_ == null) {
            throw new MarshalException("The content of element '" + node.getLocalName() + "' is not complete.");
        }
        if (!XSecProvider.lateAlgorithmInstantiation()) {
            try {
                this.getAlgorithmInstanceUncaught(null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new MarshalException(noSuchAlgorithmException);
            }
        }
    }

    protected void getAlgorithmInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException {
        String string = this.algorithm_.toString();
        Provider provider = XSecProvider.getDelegationProvider("MessageDigest." + string, purpose);
        if (provider != null) {
            try {
                this.digest_ = MessageDigest.getInstance(string, provider);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                try {
                    this.digest_ = MessageDigest.getInstance(string, provider.getName());
                }
                catch (NoSuchProviderException noSuchProviderException) {
                    throw new h(this, "Delegation provider not registered, any more.", noSuchProviderException);
                }
            }
        }
        if (this.digest_ == null) {
            this.digest_ = MessageDigest.getInstance(string);
        }
        super.getParamInstanceUncaught(purpose);
        if (this.params_ != null) {
            try {
                this.spec_ = this.params_.getParameterSpec(this.getParameterSpecClass());
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new i(this, invalidParameterSpecException);
            }
        }
    }

    public String getLocalName() {
        return "DigestMethod";
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    public byte[] calculateDigestValue(InputStream inputStream) throws IOException {
        int n2;
        if (this.digest_ == null) {
            try {
                this.getAlgorithmInstance(null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new NoSuchAlgorithmRuntimeException("Delegation provider not registered, any more.", noSuchAlgorithmException);
            }
        }
        if (inputStream == null) {
            this.digest_.reset();
            return null;
        }
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            this.digest_.update(byArray, 0, n2);
        }
        byArray = this.digest_.digest();
        this.digest_.reset();
        return byArray;
    }

    protected Class getParameterSpecClass() {
        return h == null ? (h = DigestMethodImpl.b("javax.xml.crypto.dsig.spec.DigestMethodParameterSpec")) : h;
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

