/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.dsig;

import iaik.xml.crypto.XSecProvider;
import iaik.xml.crypto.dsig.AbstractSignatureMethodImpl;
import iaik.xml.crypto.dsig.l;
import iaik.xml.crypto.dsig.m;
import iaik.xml.crypto.dsig.n;
import iaik.xml.crypto.dsig.o;
import iaik.xml.crypto.utils.Debug;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;
import javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec;
import org.w3c.dom.Node;

public class SignatureMethodImpl
extends AbstractSignatureMethodImpl
implements SignatureMethod {
    protected Signature signature_;
    protected Mac mac_;
    static Class h;

    public SignatureMethodImpl(String string, SignatureMethodParameterSpec signatureMethodParameterSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        super(string, signatureMethodParameterSpec);
        if (!XSecProvider.lateAlgorithmInstantiation()) {
            this.getAlgorithmInstanceUncaught(null);
        }
    }

    public SignatureMethodImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(dOMCryptoContext, node);
        this.unmarshal(dOMCryptoContext);
        if (!XSecProvider.lateAlgorithmInstantiation()) {
            try {
                this.getAlgorithmInstanceUncaught(null);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new l(this, noSuchAlgorithmException);
            }
        }
    }

    protected void getAlgorithmInstanceUncaught(XSecProvider.Purpose purpose) throws NoSuchAlgorithmException {
        block16: {
            String string = this.algorithm_.toString();
            try {
                Provider provider = XSecProvider.getDelegationProvider("Mac." + string, purpose);
                if (provider != null) {
                    try {
                        this.mac_ = Mac.getInstance(string, provider);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        try {
                            this.mac_ = Mac.getInstance(string, provider.getName());
                        }
                        catch (NoSuchProviderException noSuchProviderException) {
                            throw new m(this, "Mac." + string + " delegation provider not registered, any more.", noSuchProviderException);
                        }
                    }
                }
                if (this.mac_ == null) {
                    this.mac_ = Mac.getInstance(string);
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                Provider provider = XSecProvider.getDelegationProvider("Signature." + string, purpose);
                if (provider != null) {
                    try {
                        this.signature_ = Signature.getInstance(string, provider);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        try {
                            this.signature_ = Signature.getInstance(string, provider.getName());
                        }
                        catch (NoSuchProviderException noSuchProviderException) {
                            throw new n(this, "Signature." + string + " delegation provider not registered, any more.", noSuchProviderException);
                        }
                    }
                }
                if (this.signature_ != null) break block16;
                this.signature_ = Signature.getInstance(string);
            }
        }
        super.getParamInstanceUncaught(purpose);
        if (this.params_ != null) {
            try {
                this.spec_ = this.params_.getParameterSpec(h == null ? (h = SignatureMethodImpl.b("javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec")) : h);
            }
            catch (InvalidParameterSpecException invalidParameterSpecException) {
                throw new o(this, invalidParameterSpecException);
            }
        }
    }

    public String getLocalName() {
        return "SignatureMethod";
    }

    public String getNamespace() {
        return "http://www.w3.org/2000/09/xmldsig#";
    }

    private boolean a(XMLCryptoContext xMLCryptoContext, boolean bl) throws XMLSignatureException {
        boolean bl2;
        boolean bl3;
        int n2;
        int n3 = n2 = this.mac_.getMacLength() * 8;
        if (this.spec_ instanceof HMACParameterSpec) {
            n3 = ((HMACParameterSpec)this.spec_).getOutputLength();
        }
        Integer n4 = null;
        Boolean bl4 = null;
        Boolean bl5 = null;
        Boolean bl6 = null;
        if (xMLCryptoContext != null) {
            n4 = (Integer)xMLCryptoContext.getProperty("iaik.xml.crypto.dsig.HMAC.minimum.OutputLength");
            bl4 = (Boolean)xMLCryptoContext.getProperty("iaik.xml.crypto.dsig.HMAC.minimum.HalfLength");
            bl5 = (Boolean)xMLCryptoContext.getProperty("iaik.xml.crypto.dsig.HMAC.OutputLength.mod8");
            bl6 = (Boolean)xMLCryptoContext.getProperty("iaik.xml.crypto.dsig.HMAC.minimum.ThrowExceptionOnVerify");
        }
        n4 = n4 != null ? n4 : new Integer(80);
        bl4 = bl4 != null ? bl4 : Boolean.TRUE;
        bl5 = bl5 != null ? bl5 : Boolean.TRUE;
        bl6 = bl6 != null ? bl6 : Boolean.FALSE;
        boolean bl7 = n3 < n4;
        if (bl7 | (bl3 = bl4 != false && 2.0 < (double)((float)n2 / (float)n3)) | (bl2 = bl5 != false && n3 % 8 != 0)) {
            String string = "Insecure HMAC: " + (bl7 ? "\n * a) macOutputLenBits (" + n3 + ") < minMacOutputLenBits (" + n4 + ")" : "") + (bl3 ? "\n * b) macOutputLenBits (" + n3 + ") shorter than half macLenBits(" + n2 + ")" : "") + (bl2 ? "\n * c) macOutputLenBits (" + n3 + ") is not divisible by 8" : "");
            if (!bl6.booleanValue() && !bl) {
                OutputStreamWriter outputStreamWriter = Debug.getOutputStreamWriterFrom(xMLCryptoContext);
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.write(string);
                        outputStreamWriter.flush();
                    }
                    catch (IOException iOException) {
                        Debug.topLevelLog("Failed to write to debug output stream. " + iOException.getMessage() + "\n, Could not log: " + string);
                    }
                }
                return false;
            }
            throw new XMLSignatureException(string);
        }
        return true;
    }

    public boolean validateSignatureValue(Key key, byte[] byArray, InputStream inputStream) throws XMLSignatureException, IOException {
        return this.validateSignatureValue(new DOMValidateContext(key, this.getNode().getParentNode().getParentNode()), key, byArray, inputStream);
    }

    public boolean validateSignatureValue(XMLCryptoContext xMLCryptoContext, Key key, byte[] byArray, InputStream inputStream) throws XMLSignatureException, IOException {
        int n2;
        int n3;
        if (this.signature_ == null && this.mac_ == null) {
            try {
                this.getAlgorithmInstance(XSecProvider.Purpose.SignaturePurpose.VERIFY);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
        }
        if (this.signature_ != null) {
            if (this.spec_ != null) {
                try {
                    this.signature_.setParameter(this.spec_);
                }
                catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                    throw new XMLSignatureException(invalidAlgorithmParameterException);
                }
            }
            try {
                if (!(key instanceof PublicKey)) {
                    throw new InvalidKeyException("Key '" + key + "' is not a valid public key.");
                }
                this.signature_.initVerify((PublicKey)key);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new XMLSignatureException(invalidKeyException);
            }
            try {
                int n4;
                byte[] byArray2 = new byte[1024];
                while ((n4 = inputStream.read(byArray2)) != -1) {
                    this.signature_.update(byArray2, 0, n4);
                }
                return this.signature_.verify(byArray);
            }
            catch (SignatureException signatureException) {
                throw new XMLSignatureException(signatureException);
            }
        }
        Boolean bl = (Boolean)xMLCryptoContext.getProperty("iaik.xml.crypto.dsig.HMAC.legacy.OutputLength.floored");
        if (bl != null && bl.booleanValue() && this.spec_ instanceof HMACParameterSpec && (n3 = (n2 = ((HMACParameterSpec)this.spec_).getOutputLength()) % 8) != 0) {
            this.spec_ = new HMACParameterSpec(n2 - n3);
        }
        try {
            this.mac_.init(key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException(invalidAlgorithmParameterException);
        }
        if (!this.a(xMLCryptoContext, false)) {
            this.mac_.reset();
            return false;
        }
        byte[] byArray3 = new byte[1024];
        while ((n2 = inputStream.read(byArray3)) != -1) {
            this.mac_.update(byArray3, 0, n2);
        }
        byArray3 = this.mac_.doFinal();
        this.mac_.reset();
        return Arrays.equals(byArray3, byArray);
    }

    public byte[] calculateSignatureValue(Key key, InputStream inputStream) throws XMLSignatureException, IOException {
        return this.calculateSignatureValue(null, key, inputStream);
    }

    public byte[] calculateSignatureValue(XMLCryptoContext xMLCryptoContext, Key key, InputStream inputStream) throws XMLSignatureException, IOException {
        int n2;
        if (this.signature_ == null && this.mac_ == null) {
            try {
                this.getAlgorithmInstance(XSecProvider.Purpose.SignaturePurpose.SIGN);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new XMLSignatureException(noSuchAlgorithmException);
            }
        }
        if (this.signature_ != null) {
            try {
                if (!(key instanceof PrivateKey)) {
                    throw new InvalidKeyException("Key '" + key + "' is not a valid private key.");
                }
                this.signature_.initSign((PrivateKey)key);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new XMLSignatureException(invalidKeyException);
            }
            try {
                int n3;
                if (this.spec_ != null) {
                    try {
                        this.signature_.setParameter(this.spec_);
                    }
                    catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                        throw new XMLSignatureException(invalidAlgorithmParameterException);
                    }
                }
                byte[] byArray = new byte[1024];
                while ((n3 = inputStream.read(byArray)) != -1) {
                    this.signature_.update(byArray, 0, n3);
                }
                return this.signature_.sign();
            }
            catch (SignatureException signatureException) {
                throw new XMLSignatureException(signatureException);
            }
        }
        try {
            this.mac_.init(key, this.spec_);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new XMLSignatureException(invalidKeyException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new XMLSignatureException(invalidAlgorithmParameterException);
        }
        try {
            this.a(xMLCryptoContext, true);
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw xMLSignatureException;
        }
        finally {
            this.mac_.reset();
        }
        byte[] byArray = new byte[1024];
        while ((n2 = inputStream.read(byArray)) != -1) {
            this.mac_.update(byArray, 0, n2);
        }
        byArray = this.mac_.doFinal();
        this.mac_.reset();
        return byArray;
    }

    protected Class getParameterSpecClass() {
        return h == null ? (h = SignatureMethodImpl.b("javax.xml.crypto.dsig.spec.SignatureMethodParameterSpec")) : h;
    }

    static Class b(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

