/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc;

import iaik.xml.crypto.dom.DOMStructure;
import iaik.xml.crypto.dom.XencDOMStructure;
import iaik.xml.crypto.enc.CipherReferenceImpl;
import iaik.xml.crypto.enc.CipherValueImpl;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.enc.CipherData;
import javax.xml.crypto.enc.XMLDecryptContext;
import javax.xml.crypto.enc.XMLEncryptionException;
import org.w3c.dom.Node;

public class CipherDataImpl
extends XencDOMStructure {
    protected CipherValueImpl cipherValue_;
    protected CipherReferenceImpl cipherReference_;
    protected byte[] cipherText_;

    public CipherDataImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.cipherValue_ == null && this.cipherReference_ == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public CipherDataImpl(CipherReferenceImpl cipherReferenceImpl) {
        if (cipherReferenceImpl == null) {
            throw new NullPointerException("Argument 'cipherReference' must not be null.");
        }
        this.cipherReference_ = cipherReferenceImpl;
    }

    public CipherDataImpl(CipherValueImpl cipherValueImpl) {
        if (cipherValueImpl == null) {
            throw new NullPointerException("Argument 'cipherValue' must not be null.");
        }
        this.cipherValue_ = cipherValueImpl;
    }

    public String getLocalName() {
        return "CipherData";
    }

    public CipherData getCipherData() {
        if (this.cipherValue_ != null) {
            return this.cipherValue_;
        }
        return this.cipherReference_;
    }

    public InputStream getCipherText() {
        if (this.cipherText_ != null) {
            return new ByteArrayInputStream(this.cipherText_);
        }
        throw new IllegalStateException();
    }

    public void setCipherText(byte[] byArray) {
        if (this.cipherValue_ != null) {
            this.cipherValue_.setValue(byArray);
        } else {
            this.cipherText_ = byArray;
        }
    }

    public InputStream getCipherData(XMLDecryptContext xMLDecryptContext) throws XMLEncryptionException {
        Data data;
        if (this.cipherValue_ != null) {
            return this.cipherValue_.getValueStream();
        }
        try {
            data = this.cipherReference_.dereference(xMLDecryptContext);
        }
        catch (URIReferenceException uRIReferenceException) {
            throw new XMLEncryptionException(uRIReferenceException);
        }
        catch (TransformException transformException) {
            throw new XMLEncryptionException(transformException);
        }
        if (data instanceof OctetStreamData) {
            return ((OctetStreamData)data).getOctetStream();
        }
        throw new XMLEncryptionException("Failed to dereference CipherReference.");
    }

    protected List getChildStructures() {
        List list = super.getChildStructures();
        if (this.cipherValue_ != null) {
            list.add(this.cipherValue_);
        } else {
            list.add(this.cipherReference_);
        }
        return list;
    }

    protected void putChildStructure(DOMStructure dOMStructure) throws MarshalException {
        super.putChildStructure(dOMStructure);
        if (dOMStructure instanceof CipherReferenceImpl) {
            this.cipherReference_ = (CipherReferenceImpl)dOMStructure;
            return;
        }
        if (dOMStructure instanceof CipherValueImpl) {
            this.cipherValue_ = (CipherValueImpl)dOMStructure;
            return;
        }
    }
}

