/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc;

import iaik.xml.crypto.dom.XencDOMStructure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.enc.CipherValue;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CipherValueImpl
extends XencDOMStructure
implements CipherValue {
    byte[] h = null;

    public CipherValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
        if (this.h == null) {
            throw new MarshalException("The content of element '" + node + "' is not complete.");
        }
    }

    public CipherValueImpl() {
    }

    public CipherValueImpl(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("Argument 'cipherValueStream' must not be null.");
        }
        byte[] byArray = new byte[1024];
        int n2 = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            while ((n2 = inputStream.read(byArray)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.getMessage());
        }
        this.h = byteArrayOutputStream.toByteArray();
    }

    public String getLocalName() {
        return "CipherValue";
    }

    public byte[] getValue() {
        return this.h != null ? (byte[])this.h.clone() : null;
    }

    public void setValue(byte[] byArray) {
        this.h = byArray;
    }

    public InputStream getValueStream() {
        return this.h != null ? new ByteArrayInputStream(this.h) : null;
    }

    protected Element marshalElement(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element = super.marshalElement(dOMCryptoContext, node, node2);
        if (this.h != null) {
            CipherValueImpl.addBytesToElement(element, this.h, dOMCryptoContext);
        }
        return element;
    }

    protected void unmarshalElement(DOMCryptoContext dOMCryptoContext, Element element) throws MarshalException {
        super.unmarshalElement(dOMCryptoContext, element);
        this.h = CipherValueImpl.getBytesFromElement(element);
    }

    public void appendValue(DOMCryptoContext dOMCryptoContext, byte[] byArray) throws MarshalException {
        if (this.state_ < 1) {
            throw new MarshalException("Element hasn't been marshaled yet.");
        }
        if (this.h != null) {
            throw new MarshalException("Digest value has already been appended.");
        }
        this.h = byArray;
        CipherValueImpl.addBytesToElement((Element)this.getNode(), byArray, dOMCryptoContext);
    }
}

