/*
 * Decompiled with CFR 0.152.
 */
package iaik.xml.crypto.enc.keyinfo;

import iaik.security.dh.ESDHParameterSpec;
import iaik.security.dh.ESDHPublicKey;
import iaik.security.dh.ESDHPublicKeySpec;
import iaik.utils.Util;
import iaik.xml.crypto.dsig.keyinfo.KeyValueType;
import iaik.xml.crypto.utils.DOMUtils;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.interfaces.DHPublicKey;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DHKeyValueImpl
extends KeyValueType {
    protected BigInteger primeP_ = null;
    protected BigInteger primeQ_ = null;
    protected BigInteger publicValue_ = null;
    protected BigInteger generator_ = null;
    protected byte[] seed_ = null;
    protected int pGenCounter_ = 0;

    public DHKeyValueImpl(DOMCryptoContext dOMCryptoContext, Node node) throws MarshalException {
        super(node);
        if (dOMCryptoContext == null) {
            throw new NullPointerException("Argument 'context' must not be null");
        }
        this.unmarshal(dOMCryptoContext);
    }

    public DHKeyValueImpl(DHPublicKey dHPublicKey) {
        super(dHPublicKey);
    }

    public String getLocalName() {
        return "DHKeyValue";
    }

    public Node marshal(DOMCryptoContext dOMCryptoContext, Node node, Node node2) throws MarshalException {
        Element element;
        Element element2;
        Node node3 = super.marshal(dOMCryptoContext, node, node2);
        Document document = DOMUtils.getOwnerDocument(node);
        String string = dOMCryptoContext.getNamespacePrefix("http://www.w3.org/2001/04/xmlenc#", dOMCryptoContext.getDefaultNamespacePrefix());
        if (!(this.publicKey_ instanceof ESDHPublicKey)) {
            throw new MarshalException("PublicKey must be of instance \"iaik.security.dh.DHPublicKey\"");
        }
        ESDHPublicKey eSDHPublicKey = (ESDHPublicKey)this.publicKey_;
        ESDHParameterSpec eSDHParameterSpec = (ESDHParameterSpec)eSDHPublicKey.getParams();
        BigInteger bigInteger = eSDHParameterSpec.getP();
        BigInteger bigInteger2 = eSDHParameterSpec.getQ();
        BigInteger bigInteger3 = eSDHParameterSpec.getG();
        BigInteger bigInteger4 = eSDHPublicKey.getY();
        byte[] byArray = eSDHParameterSpec.getSeed();
        Integer n2 = new Integer(eSDHParameterSpec.getPGenCounter());
        byte[] byArray2 = Util.toByteArray((String)n2.toString());
        if (bigInteger != null) {
            element2 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DHKeyValueImpl.getQualifiedName(string, "P"));
            DHKeyValueImpl.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger), dOMCryptoContext);
            node3.appendChild(element2);
        }
        if (bigInteger2 != null) {
            element2 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DHKeyValueImpl.getQualifiedName(string, "Q"));
            DHKeyValueImpl.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger2), dOMCryptoContext);
            node3.appendChild(element2);
        }
        if (bigInteger3 != null) {
            element2 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DHKeyValueImpl.getQualifiedName(string, "Generator"));
            DHKeyValueImpl.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger3), dOMCryptoContext);
            node3.appendChild(element2);
        }
        if (bigInteger4 == null) {
            throw new MarshalException("Value \"Public\" must not be null");
        }
        element2 = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DHKeyValueImpl.getQualifiedName(string, "Public"));
        DHKeyValueImpl.addBytesToElement(element2, DOMUtils.bigInteger2byteArray(bigInteger4), dOMCryptoContext);
        node3.appendChild(element2);
        if (byArray != null) {
            element = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DHKeyValueImpl.getQualifiedName(string, "seed"));
            DHKeyValueImpl.addBytesToElement(element, byArray, dOMCryptoContext);
            node3.appendChild(element);
        }
        if (n2 != null) {
            element = document.createElementNS("http://www.w3.org/2001/04/xmlenc#", DHKeyValueImpl.getQualifiedName(string, "pgenCounter"));
            DHKeyValueImpl.addBytesToElement(element, byArray2, dOMCryptoContext);
            node3.appendChild(element);
        }
        return node3;
    }

    protected void unmarshalStructures(NodeList nodeList, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Object object;
        if (nodeList == null) {
            return;
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            object = nodeList.item(i2);
            if (object.getNodeType() != 1 || !object.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) continue;
            if (object.getLocalName().equals("P")) {
                this.primeP_ = new BigInteger(1, DHKeyValueImpl.getBytesFromElement((Element)object));
                continue;
            }
            if (object.getLocalName().equals("Q")) {
                this.primeQ_ = new BigInteger(1, DHKeyValueImpl.getBytesFromElement((Element)object));
                continue;
            }
            if (object.getLocalName().equals("Public")) {
                this.publicValue_ = new BigInteger(1, DHKeyValueImpl.getBytesFromElement((Element)object));
                continue;
            }
            if (object.getLocalName().equals("Generator")) {
                this.generator_ = new BigInteger(1, DHKeyValueImpl.getBytesFromElement((Element)object));
                continue;
            }
            if (object.getLocalName().equals("seed")) {
                this.seed_ = DHKeyValueImpl.getBytesFromElement((Element)object);
                continue;
            }
            if (!object.getLocalName().equals("Public")) continue;
            this.pGenCounter_ = new BigInteger(1, DHKeyValueImpl.getBytesFromElement((Element)object)).intValue();
        }
        ESDHPublicKeySpec eSDHPublicKeySpec = new ESDHPublicKeySpec(this.publicValue_, this.primeP_, this.primeQ_, this.generator_, this.seed_, this.pGenCounter_);
        try {
            object = KeyFactory.getInstance("ESDH", "IAIK");
            this.publicKey_ = (ESDHPublicKey)((KeyFactory)object).generatePublic((KeySpec)eSDHPublicKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MarshalException("Failed to create DH Public key");
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new MarshalException("Failed to create DH Public key");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new MarshalException("Failed to create DH Public key");
        }
    }

    public BigInteger getGenerator() {
        return this.generator_;
    }

    public int getPGenCounter() {
        return this.pGenCounter_;
    }

    public BigInteger getPrimeP() {
        return this.primeP_;
    }

    public BigInteger getPrimeQ() {
        return this.primeQ_;
    }

    public BigInteger getPublicValue() {
        return this.publicValue_;
    }

    public byte[] getSeed() {
        return this.seed_;
    }
}

